"use strict";
// *****************************************************************************
// Copyright (C) 2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonWorkspaceUtils = exports.getTemporaryWorkspaceFileUri = exports.VSCODE_EXT = exports.THEIA_EXT = void 0;
// TODO get rid of util files, replace with methods in a responsible class
const uri_1 = require("@theia/core/lib/common/uri");
const inversify_1 = require("@theia/core/shared/inversify");
const files_1 = require("@theia/filesystem/lib/common/files");
exports.THEIA_EXT = 'theia-workspace';
exports.VSCODE_EXT = 'code-workspace';
/**
 * @deprecated since 1.4.0 - because of https://github.com/eclipse-theia/theia/tree/master/doc/coding-guidelines.md#di-function-export,
 * use `WorkspaceService.getUntitledWorkspace` instead
 */
async function getTemporaryWorkspaceFileUri(envVariableServer) {
    const configDirUri = await envVariableServer.getConfigDirUri();
    return new uri_1.default(configDirUri).resolve(`Untitled.${exports.THEIA_EXT}`);
}
exports.getTemporaryWorkspaceFileUri = getTemporaryWorkspaceFileUri;
let CommonWorkspaceUtils = class CommonWorkspaceUtils {
    /**
     * Check if the file should be considered as a workspace file.
     *
     * Example: We should not try to read the contents of an .exe file.
     */
    isWorkspaceFile(candidate) {
        const uri = files_1.FileStat.is(candidate) ? candidate.resource : candidate;
        return uri.path.ext === `.${exports.THEIA_EXT}` || uri.path.ext === `.${exports.VSCODE_EXT}`;
    }
    isUntitledWorkspace(candidate) {
        return !!candidate && this.isWorkspaceFile(candidate) && candidate.path.base.startsWith('Untitled');
    }
    async getUntitledWorkspaceUri(configDirUri, isAcceptable, warnOnHits) {
        const parentDir = configDirUri.resolve('workspaces');
        let uri;
        let attempts = 0;
        do {
            attempts++;
            uri = parentDir.resolve(`Untitled-${Math.round(Math.random() * 1000)}.${exports.THEIA_EXT}`);
            if (attempts === 10) {
                warnOnHits === null || warnOnHits === void 0 ? void 0 : warnOnHits();
            }
            if (attempts === 50) {
                throw new Error('Workspace Service: too many attempts to find unused filename.');
            }
        } while (!(await isAcceptable(uri)));
        return uri;
    }
};
CommonWorkspaceUtils = __decorate([
    (0, inversify_1.injectable)()
], CommonWorkspaceUtils);
exports.CommonWorkspaceUtils = CommonWorkspaceUtils;
//# sourceMappingURL=utils.js.map