"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const inversify_1 = require("inversify");
const browser_1 = require("@theia/core/lib/browser");
const trace_viewer_1 = require("./trace-viewer");
const trace_viewer_contribution_1 = require("./trace-viewer-contribution");
const trace_server_url_provider_1 = require("../../common/trace-server-url-provider");
const common_1 = require("@theia/core/lib/common");
require("ag-grid-community/dist/styles/ag-grid.css");
require("ag-grid-community/dist/styles/ag-theme-balham-dark.css");
require("ag-grid-community/dist/styles/ag-theme-balham.css");
require("react-grid-layout/css/styles.css");
require("react-resizable/css/styles.css");
const trace_explorer_contribution_1 = require("../trace-explorer/trace-explorer-contribution");
const trace_explorer_widget_1 = require("../trace-explorer/trace-explorer-widget");
const tsp_client_provider_impl_1 = require("../tsp-client-provider-impl");
const theia_message_manager_1 = require("../theia-message-manager");
const trace_server_url_provider_frontend_impl_1 = require("../trace-server-url-provider-frontend-impl");
const trace_server_bindings_1 = require("../trace-server-bindings");
const trace_server_config_1 = require("../../common/trace-server-config");
const tab_bar_toolbar_1 = require("@theia/core/lib/browser/shell/tab-bar-toolbar");
const trace_viewer_toolbar_contribution_1 = require("./trace-viewer-toolbar-contribution");
const lazy_tsp_client_1 = require("traceviewer-base/lib/lazy-tsp-client");
const backend_file_service_1 = require("../../common/backend-file-service");
const charts_cheatsheet_component_1 = require("../trace-explorer/trace-explorer-sub-widgets/trace-explorer-keyboard-shortcuts/charts-cheatsheet-component");
const trace_server_status_1 = require("../trace-server-status");
exports.default = new inversify_1.ContainerModule(bind => {
    bind(trace_server_url_provider_frontend_impl_1.TraceServerUrlProviderImpl).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(trace_server_url_provider_frontend_impl_1.TraceServerUrlProviderImpl);
    bind(trace_server_url_provider_1.TraceServerUrlProvider).toService(trace_server_url_provider_frontend_impl_1.TraceServerUrlProviderImpl);
    bind(lazy_tsp_client_1.LazyTspClientFactory).toFunction(lazy_tsp_client_1.LazyTspClientFactory);
    bind(tsp_client_provider_impl_1.TspClientProvider).toSelf().inSingletonScope();
    bind(charts_cheatsheet_component_1.ChartShortcutsDialog).toSelf().inSingletonScope();
    bind(charts_cheatsheet_component_1.ChartShortcutsDialogProps).toConstantValue({ title: 'Trace Viewer Keyboard and Mouse Shortcuts' });
    bind(theia_message_manager_1.TheiaMessageManager).toSelf().inSingletonScope();
    bind(trace_viewer_toolbar_contribution_1.TraceViewerToolbarContribution).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(trace_viewer_toolbar_contribution_1.TraceViewerToolbarContribution);
    bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(trace_viewer_toolbar_contribution_1.TraceViewerToolbarContribution);
    bind(common_1.CommandContribution).toService(trace_viewer_toolbar_contribution_1.TraceViewerToolbarContribution);
    bind(trace_server_status_1.TraceServerConnectionStatusService).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(trace_server_status_1.TraceServerConnectionStatusService);
    bind(trace_viewer_1.TraceViewerWidget).toSelf();
    bind(browser_1.WidgetFactory).toDynamicValue(context => ({
        id: trace_viewer_1.TraceViewerWidget.ID,
        async createWidget(options) {
            const child = new inversify_1.Container({ defaultScope: 'Singleton' });
            child.parent = context.container;
            child.bind(trace_viewer_1.TraceViewerWidgetOptions).toConstantValue(options);
            return child.get(trace_viewer_1.TraceViewerWidget);
        }
    })).inSingletonScope();
    bind(trace_viewer_contribution_1.TraceViewerContribution).toSelf().inSingletonScope();
    [common_1.CommandContribution, browser_1.OpenHandler, browser_1.FrontendApplicationContribution, browser_1.KeybindingContribution].forEach(serviceIdentifier => bind(serviceIdentifier).toService(trace_viewer_contribution_1.TraceViewerContribution));
    (0, browser_1.bindViewContribution)(bind, trace_explorer_contribution_1.TraceExplorerContribution);
    bind(browser_1.FrontendApplicationContribution).toService(trace_explorer_contribution_1.TraceExplorerContribution);
    bind(browser_1.WidgetFactory).toDynamicValue(context => ({
        id: trace_explorer_widget_1.TraceExplorerWidget.ID,
        createWidget: () => trace_explorer_widget_1.TraceExplorerWidget.createWidget(context.container)
    })).inSingletonScope();
    bind(trace_server_config_1.TraceServerConfigService).toDynamicValue(ctx => {
        const connection = ctx.container.get(browser_1.WebSocketConnectionProvider);
        return connection.createProxy(trace_server_config_1.traceServerPath);
    }).inSingletonScope();
    (0, trace_server_bindings_1.bindTraceServerPreferences)(bind);
    bind(backend_file_service_1.BackendFileService).toDynamicValue(ctx => {
        const connection = ctx.container.get(browser_1.WebSocketConnectionProvider);
        return connection.createProxy(backend_file_service_1.backendFileServicePath);
    }).inSingletonScope();
    // bindViewContribution(bind, TracePropertiesContribution);
    // bind(TracePropertiesWidget).toSelf();
    // bind(WidgetFactory).toDynamicValue(context => ({
    //     id: TRACE_PROPERTIES_ID,
    //     createWidget: () => context.container.get<TracePropertiesWidget>(TracePropertiesWidget)
    // }));
});
//# sourceMappingURL=trace-viewer-frontend-module.js.map