"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TspClientProvider = void 0;
const inversify_1 = require("inversify");
const trace_server_url_provider_1 = require("../common/trace-server-url-provider");
const tsp_client_1 = require("tsp-typescript-client/lib/protocol/tsp-client");
const experiment_manager_1 = require("traceviewer-base/lib/experiment-manager");
const trace_manager_1 = require("traceviewer-base/lib/trace-manager");
const lazy_tsp_client_1 = require("traceviewer-base/lib/lazy-tsp-client");
let TspClientProvider = class TspClientProvider {
    constructor(tspUrlProvider, lazyTspClientFactory) {
        this.tspUrlProvider = tspUrlProvider;
        this.lazyTspClientFactory = lazyTspClientFactory;
        const traceServerUrlPromise = this.tspUrlProvider.getTraceServerUrlPromise();
        this._tspClient = this.lazyTspClientFactory(traceServerUrlPromise);
        this._traceManager = new trace_manager_1.TraceManager(this._tspClient);
        this._experimentManager = new experiment_manager_1.ExperimentManager(this._tspClient, this._traceManager);
        this._listeners = [];
        // Skip the first event fired when the Trace Server URL gets initialized.
        traceServerUrlPromise.then(() => {
            tspUrlProvider.onDidChangeTraceServerUrl(url => {
                this._tspClient = new tsp_client_1.TspClient(url);
                this._traceManager = new trace_manager_1.TraceManager(this._tspClient);
                this._experimentManager = new experiment_manager_1.ExperimentManager(this._tspClient, this._traceManager);
                for (const listener of this._listeners) {
                    listener(this._tspClient);
                }
            });
        });
    }
    getTspClient() {
        return this._tspClient;
    }
    getTraceManager() {
        return this._traceManager;
    }
    getExperimentManager() {
        return this._experimentManager;
    }
    /**
     * Add a listener for trace server url changes
     * @param listener The listener function to be called when the url is
     * changed
     */
    addTspClientChangeListener(listener) {
        this._listeners.push(listener);
    }
};
TspClientProvider = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(trace_server_url_provider_1.TraceServerUrlProvider)),
    __param(1, (0, inversify_1.inject)(lazy_tsp_client_1.LazyTspClientFactory)),
    __metadata("design:paramtypes", [Object, Function])
], TspClientProvider);
exports.TspClientProvider = TspClientProvider;
//# sourceMappingURL=tsp-client-provider-impl.js.map