"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphChartArrows = void 0;
var time_graph_arrow_1 = require("../components/time-graph-arrow");
var time_graph_chart_layer_1 = require("./time-graph-chart-layer");
var TimeGraphChartArrows = /** @class */ (function (_super) {
    __extends(TimeGraphChartArrows, _super);
    function TimeGraphChartArrows() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.rowIds = [];
        return _this;
    }
    TimeGraphChartArrows.prototype.afterAddToContainer = function () {
        var _this = this;
        this._updateHandler = function () { return _this.update(); };
        this.unitController.onViewRangeChanged(this._updateHandler);
        this.rowController.onVerticalOffsetChangedHandler(function (verticalOffset) {
            _this.layer.position.y = -verticalOffset;
        });
    };
    TimeGraphChartArrows.prototype.getCoordinates = function (arrow) {
        var sourceIndex = this.rowIds.indexOf(arrow.sourceId);
        var destinationIndex = this.rowIds.indexOf(arrow.destinationId);
        if (sourceIndex === -1 || destinationIndex === -1) {
            return undefined;
        }
        var relativeStartPosition = arrow.range.start - this.unitController.viewRange.start;
        var start = {
            x: this.getPixel(relativeStartPosition),
            y: (sourceIndex * this.rowController.rowHeight) + (this.rowController.rowHeight / 2)
        };
        var end = {
            x: this.getPixel(relativeStartPosition + arrow.range.end - arrow.range.start),
            y: (destinationIndex * this.rowController.rowHeight) + (this.rowController.rowHeight / 2)
        };
        return { start: start, end: end };
    };
    TimeGraphChartArrows.prototype.addArrow = function (arrow) {
        var coords = this.getCoordinates(arrow);
        if (!coords) {
            return;
        }
        var arrowComponent = new time_graph_arrow_1.TimeGraphArrowComponent('arrow', arrow, coords);
        this.arrows.set(arrow, arrowComponent);
        this.addChild(arrowComponent);
    };
    TimeGraphChartArrows.prototype.addArrows = function (arrows, rowIds) {
        var _this = this;
        this.rowIds = rowIds;
        if (!this.stateController) {
            throw ('Add this TimeGraphChartArrows to a container before adding arrows.');
        }
        if (this.arrows) {
            this.removeChildren();
        }
        this.arrows = new Map();
        arrows.forEach(function (arrow) {
            _this.addArrow(arrow);
        });
    };
    TimeGraphChartArrows.prototype.update = function () {
        var e_1, _a;
        if (this.arrows) {
            try {
                for (var _b = __values(this.arrows.keys()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var arrow = _c.value;
                    this.updateArrow(arrow);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
    };
    TimeGraphChartArrows.prototype.updateArrow = function (arrow) {
        var arrowComponent = this.arrows.get(arrow);
        if (arrowComponent) {
            var coords = this.getCoordinates(arrow);
            if (!coords) {
                this.removeChild(arrowComponent);
                this.arrows.delete(arrow);
            }
            else {
                arrowComponent.update(coords);
            }
        }
    };
    TimeGraphChartArrows.prototype.destroy = function () {
        if (this.unitController) {
            this.unitController.removeViewRangeChangedHandler(this._updateHandler);
        }
        _super.prototype.destroy.call(this);
    };
    return TimeGraphChartArrows;
}(time_graph_chart_layer_1.TimeGraphChartLayer));
exports.TimeGraphChartArrows = TimeGraphChartArrows;
//# sourceMappingURL=time-graph-chart-arrows.js.map