"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphChartSelectionRange = void 0;
var time_graph_rectangle_1 = require("../components/time-graph-rectangle");
var time_graph_layer_1 = require("./time-graph-layer");
var TimeGraphChartSelectionRange = /** @class */ (function (_super) {
    __extends(TimeGraphChartSelectionRange, _super);
    function TimeGraphChartSelectionRange(id, style) {
        var _this = _super.call(this, id) || this;
        _this.color = 0x0000ff;
        if (style && style.color) {
            _this.color = style.color;
        }
        return _this;
    }
    TimeGraphChartSelectionRange.prototype.updateScaleAndPosition = function () {
        if (this.unitController.selectionRange && this.selectionRange) {
            var firstCursorPosition = this.getPixel(this.unitController.selectionRange.start - this.unitController.viewRange.start);
            var width = this.getPixel(this.unitController.selectionRange.end - this.unitController.selectionRange.start);
            this.selectionRange.update({
                position: {
                    x: firstCursorPosition,
                    y: 0
                },
                height: this.stateController.canvasDisplayHeight,
                width: width
            });
        }
    };
    TimeGraphChartSelectionRange.prototype.afterAddToContainer = function () {
        var _this = this;
        this._viewRangeUpdateHandler = function () {
            _this.updateScaleAndPosition();
        };
        this._updateHandler = function () { return _this.update(); };
        this.unitController.onViewRangeChanged(this._viewRangeUpdateHandler);
        this.unitController.onSelectionRangeChange(this._updateHandler);
        this.update();
    };
    TimeGraphChartSelectionRange.prototype.removeSelectionRange = function () {
        this.removeChildren();
        delete this.selectionRange;
    };
    TimeGraphChartSelectionRange.prototype.update = function () {
        if (this.unitController.selectionRange) {
            var firstCursorPosition = this.getPixel(this.unitController.selectionRange.start - this.unitController.viewRange.start);
            var secondCursorPosition = this.getPixel(this.unitController.selectionRange.end - this.unitController.viewRange.start);
            if (secondCursorPosition !== firstCursorPosition) {
                if (!this.selectionRange) {
                    this.selectionRange = new time_graph_rectangle_1.TimeGraphRectangle({
                        color: this.color,
                        opacity: 0.2,
                        position: {
                            x: firstCursorPosition,
                            y: 0
                        },
                        height: this.stateController.canvasDisplayHeight,
                        width: secondCursorPosition - firstCursorPosition
                    });
                    this.addChild(this.selectionRange);
                }
                else {
                    this.selectionRange.update({
                        position: {
                            x: firstCursorPosition,
                            y: 0
                        },
                        height: this.stateController.canvasDisplayHeight,
                        width: secondCursorPosition - firstCursorPosition
                    });
                }
            }
            else {
                this.removeSelectionRange();
            }
        }
        else {
            this.removeSelectionRange();
        }
    };
    TimeGraphChartSelectionRange.prototype.destroy = function () {
        if (this.unitController) {
            this.unitController.removeViewRangeChangedHandler(this._viewRangeUpdateHandler);
            this.unitController.removeSelectionRangeChangedHandler(this._updateHandler);
        }
        _super.prototype.destroy.call(this);
    };
    return TimeGraphChartSelectionRange;
}(time_graph_layer_1.TimeGraphLayer));
exports.TimeGraphChartSelectionRange = TimeGraphChartSelectionRange;
//# sourceMappingURL=time-graph-chart-selection-range.js.map