"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TracePreferences = exports.ServerSchema = exports.TRACE_ARGS = exports.TRACE_PORT = exports.TRACE_PATH = void 0;
const browser_1 = require("@theia/core/lib/browser");
const trace_server_url_provider_1 = require("../common/trace-server-url-provider");
exports.TRACE_PATH = 'trace Viewer.trace Server.path';
exports.TRACE_PORT = 'trace Viewer.trace Viewer.port';
exports.TRACE_ARGS = 'trace Viewer.trace Server.arguments';
exports.ServerSchema = {
    scope: browser_1.PreferenceScope.Folder,
    type: 'object',
    properties: {
        [exports.TRACE_PATH]: {
            type: 'string',
            description: 'The path to trace-server executable, e.g.: /usr/bin/tracecompass-server'
        },
        [exports.TRACE_PORT]: {
            type: 'integer',
            default: trace_server_url_provider_1.TRACE_VIEWER_DEFAULT_PORT,
            description: 'Specify the port the Trace Viewer would use to connect to the trace server'
        },
        [exports.TRACE_ARGS]: {
            type: 'string',
            default: '',
            description: 'Specify trace-server command line arguments. This change will take effect the next time the trace server starts.' +
                '\n' +
                'E.g. for Trace Compass server: -data /home/user/server-workspace -vmargs -Dtraceserver.port=8080'
        }
    }
};
exports.TracePreferences = Symbol('TracePreferences');
//# sourceMappingURL=trace-server-preference.js.map