"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var time_graph_performance_test_1 = require("../unitTest/time-graph-performance-test");
var settings_1 = require("../unitTest/data/withLabels/settings");
describe('TImeGraphChart performance test with labels', function () {
    var timeGraph;
    beforeEach(function () {
        // Initiating the test
        timeGraph = new time_graph_performance_test_1.TimeGraphPerformanceTest(settings_1.WithLabelTestData.data, settings_1.WithLabelTestData.viewRange);
    });
    it('onScaleFactorChanged test', function () {
        // Making sure that the set up is good
        expect(timeGraph.getAbsoluteStart()).toEqual(settings_1.WithLabelTestData.traceStart);
        expect(timeGraph.getTotalLength()).toEqual(settings_1.WithLabelTestData.totalLength);
        // Set the zoom range so that we don't have to call adjustZoom()
        var start = performance.now();
        timeGraph.scaleChart(1.2);
        var end = performance.now();
        var time = end - start;
        console.log("onScaleFactorChanged - with labels running time", time, "ms");
        expect(time).toBeGreaterThan(0);
    });
    it('addOrUpdateRow() test', function () {
        var timeGraphChart = timeGraph.getTimeGraphChart();
        var data = timeGraph.getData();
        var start = performance.now();
        // We don't need to fetch any new data at all, the function should wipe out all existing rows
        // and rerender them.
        // @ts-ignore
        timeGraphChart.addOrUpdateRows(data);
        var end = performance.now();
        var time = end - start;
        console.log("addOrUpdateRow() - with labels running time", time, "ms");
        expect(time).toBeGreaterThan(0);
    });
});
//# sourceMappingURL=time-graph-chart-with-labels.test.js.map