"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphAxisCursors = void 0;
var time_graph_axis_cursor_1 = require("../components/time-graph-axis-cursor");
var time_graph_layer_1 = require("./time-graph-layer");
var TimeGraphAxisCursors = /** @class */ (function (_super) {
    __extends(TimeGraphAxisCursors, _super);
    function TimeGraphAxisCursors(id, style) {
        var _this = _super.call(this, id) || this;
        _this.color = 0x0000ff;
        if (style && style.color) {
            _this.color = style.color;
        }
        return _this;
    }
    TimeGraphAxisCursors.prototype.afterAddToContainer = function () {
        var _this = this;
        this._updateHandler = function () { return _this.update(); };
        this.unitController.onViewRangeChanged(this._updateHandler);
        this.unitController.onSelectionRangeChange(this._updateHandler);
        this.update();
    };
    TimeGraphAxisCursors.prototype.update = function () {
        if (this.unitController.selectionRange) {
            var firstCursorPosition = this.getPixel(this.unitController.selectionRange.start - this.unitController.viewRange.start);
            var secondCursorPosition = this.getPixel(this.unitController.selectionRange.end - this.unitController.viewRange.start);
            var firstOpts = {
                color: this.color,
                position: {
                    x: firstCursorPosition,
                    y: this.stateController.canvasDisplayHeight
                }
            };
            if (!this.firstCursor) {
                this.firstCursor = new time_graph_axis_cursor_1.TimeGraphAxisCursor(firstOpts);
                this.addChild(this.firstCursor);
            }
            else {
                this.firstCursor.update(firstOpts);
            }
            if (secondCursorPosition !== firstCursorPosition) {
                var secondOpts = {
                    color: this.color,
                    position: {
                        x: secondCursorPosition,
                        y: this.stateController.canvasDisplayHeight
                    }
                };
                if (!this.secondCursor) {
                    this.secondCursor = new time_graph_axis_cursor_1.TimeGraphAxisCursor(secondOpts);
                    this.addChild(this.secondCursor);
                }
                else {
                    this.secondCursor.update(secondOpts);
                }
            }
            else if (this.secondCursor) {
                this.secondCursor.clear();
            }
        }
        else {
            this.removeChildren();
            delete this.firstCursor;
            delete this.secondCursor;
        }
    };
    TimeGraphAxisCursors.prototype.destroy = function () {
        if (this.unitController) {
            this.unitController.removeViewRangeChangedHandler(this._updateHandler);
            this.unitController.removeSelectionRangeChangedHandler(this._updateHandler);
        }
        _super.prototype.destroy.call(this);
    };
    return TimeGraphAxisCursors;
}(time_graph_layer_1.TimeGraphLayer));
exports.TimeGraphAxisCursors = TimeGraphAxisCursors;
//# sourceMappingURL=time-graph-axis-cursors.js.map