"use strict";
/* eslint-disable @typescript-eslint/no-explicit-any */
Object.defineProperty(exports, "__esModule", { value: true });
exports.LazyTspClientFactory = void 0;
const tsp_typescript_client_1 = require("tsp-typescript-client");
function LazyTspClientFactory(url) {
    // All methods from the `TspClient` are asynchronous. The `LazyTspClient`
    // will just delay each call to its methods by first awaiting for the
    // asynchronous `baseUrl` resolution to then get a valid `TspClient`.
    const tspClientPromise = url.then(baseUrl => new tsp_typescript_client_1.TspClient(baseUrl));
    // eslint-disable-next-line no-null/no-null
    return new Proxy(Object.create(null), {
        get(target, property, _receiver) {
            let method = target[property];
            if (!method) {
                target[property] = method = async (...args) => {
                    const tspClient = (await tspClientPromise);
                    return tspClient[property](...args);
                };
            }
            return method;
        }
    });
}
exports.LazyTspClientFactory = LazyTspClientFactory;
//# sourceMappingURL=lazy-tsp-client.js.map