"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactItemPropertiesWidget = void 0;
const React = __importStar(require("react"));
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
class ReactItemPropertiesWidget extends React.Component {
    constructor(props) {
        super(props);
        /** Tooltip Signal and Signal Handlers */
        this._onItemProperties = (tooltip) => this.doHandleItemPropertiesSignal(tooltip);
        this.state = {
            itemProperties: {}
        };
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.ITEM_PROPERTIES_UPDATED, this._onItemProperties);
    }
    componentWillUnmount() {
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.ITEM_PROPERTIES_UPDATED, this._onItemProperties);
    }
    render() {
        return (React.createElement("div", { className: "trace-explorer-item-properties" },
            React.createElement("div", { className: "trace-explorer-panel-content" }, this.renderTooltip())));
    }
    renderTooltip() {
        const tooltipArray = [];
        if (this.state.itemProperties) {
            Object.entries(this.state.itemProperties).forEach(([key, value]) => {
                if (key === 'Source') {
                    const sourceCodeInfo = value;
                    const matches = sourceCodeInfo.match('(.*):(\\d+)');
                    let fileLocation;
                    let line;
                    if (matches && matches.length === 3) {
                        fileLocation = matches[1];
                        line = matches[2];
                    }
                    tooltipArray.push(React.createElement("p", { className: "source-code-tooltip", key: key, onClick: this.props.handleSourcecodeLookup, "data-id": JSON.stringify({ fileLocation, line }) }, key + ': ' + sourceCodeInfo));
                }
                else {
                    tooltipArray.push(React.createElement("p", { key: key }, key + ': ' + value));
                }
            });
        }
        else {
            tooltipArray.push(React.createElement("p", { key: "-1" },
                React.createElement("i", null, "Select item to view properties")));
        }
        return React.createElement(React.Fragment, null, tooltipArray.map(element => element));
    }
    doHandleItemPropertiesSignal(tooltipProps) {
        this.setState({ itemProperties: tooltipProps });
    }
}
exports.ReactItemPropertiesWidget = ReactItemPropertiesWidget;
//# sourceMappingURL=trace-explorer-properties-widget.js.map