"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataType = void 0;
var DataType;
(function (DataType) {
    /** Data represent a decimal number */
    DataType["NUMBER"] = "NUMBER";
    /** Binary data, where the size orders are powers of 2 */
    DataType["BINARY_NUMBER"] = "NUMBER";
    /** Data represent a timestamp in nanoseconds, can be negative */
    DataType["TIMESTAMP"] = "TIMESTAMP";
    /** Data represents a duration in nanoseconds */
    DataType["DURATION"] = "DURATION";
    /** Data is textual data */
    DataType["STRING"] = "STRING";
    /**
     * Data representing a time range of string: [start,end],
     * where `start` and `end` are timestamps in nanoseconds
     */
    DataType["TIME_RANGE"] = "TIME_RANGE";
})(DataType = exports.DataType || (exports.DataType = {}));
//# sourceMappingURL=data-type.js.map