"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("./utils");
const chai_1 = require("chai");
const path = require("path");
describe('continues', function () {
    return __awaiter(this, void 0, void 0, function* () {
        let dc;
        beforeEach(function () {
            return __awaiter(this, void 0, void 0, function* () {
                dc = yield (0, utils_1.standardBeforeEach)();
                yield dc.launchRequest((0, utils_1.fillDefaults)(this.currentTest, {
                    program: path.join(utils_1.testProgramsDir, 'count'),
                }));
            });
        });
        afterEach(function () {
            return __awaiter(this, void 0, void 0, function* () {
                yield dc.stop();
            });
        });
        it('handles continues single-thread', function () {
            return __awaiter(this, void 0, void 0, function* () {
                yield dc.setBreakpointsRequest({
                    source: {
                        name: 'count.c',
                        path: path.join(utils_1.testProgramsDir, 'count.c'),
                    },
                    breakpoints: [
                        {
                            column: 1,
                            line: 4,
                        },
                    ],
                });
                yield dc.configurationDoneRequest();
                yield dc.waitForEvent('stopped');
                const scope = yield (0, utils_1.getScopes)(dc);
                const continueResponse = yield dc.continueRequest({ threadId: scope.thread.id });
                (0, chai_1.expect)(continueResponse.body.allThreadsContinued).to.eq(!utils_1.gdbNonStop);
            });
        });
    });
});
//# sourceMappingURL=continues.spec.js.map