import { DebugSession } from '@vscode/debugadapter';
import { LaunchRequestArguments, AttachRequestArguments } from '../types/session';
import { GDBDebugSessionBase } from '../gdb/GDBDebugSessionBase';
import { IGDBBackendFactory } from '../types/gdb';
export declare class GDBDebugSession extends GDBDebugSessionBase {
    /**
     * Initial (aka default) configuration for launch/attach request
     * typically supplied with the --config command line argument.
     */
    protected static defaultRequestArguments?: any;
    /**
     * Frozen configuration for launch/attach request
     * typically supplied with the --config-frozen command line argument.
     */
    protected static frozenRequestArguments?: {
        request?: string;
    };
    constructor(backendFactory?: IGDBBackendFactory);
    /**
     * Main entry point
     */
    static run(debugSession: typeof DebugSession): void;
    /**
     * Parse an optional config file which is a JSON string of launch/attach request arguments.
     * The config can be a response file by starting with an @.
     */
    static processArgv(args: string[]): void;
    /**
     * Apply the initial and frozen launch/attach request arguments.
     * @param request the default request type to return if request type is not frozen
     * @param args the arguments from the user to apply initial and frozen arguments to.
     * @returns resolved request type and the resolved arguments
     */
    protected applyRequestArguments(request: 'launch' | 'attach', args: LaunchRequestArguments | AttachRequestArguments): ['launch' | 'attach', LaunchRequestArguments | AttachRequestArguments];
}
