"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-core_lib_browser_ai-command-handler-factory_js-node_modules_the-45a138"],{

/***/ "../../node_modules/@theia/ai-core/lib/browser/ai-command-handler-factory.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/browser/ai-command-handler-factory.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AICommandHandlerFactory = void 0;
exports.AICommandHandlerFactory = Symbol('AICommandHandlerFactory');


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/agent-service.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/agent-service.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgentServiceImpl = exports.AgentService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const settings_service_1 = __webpack_require__(/*! ./settings-service */ "../../node_modules/@theia/ai-core/lib/common/settings-service.js");
const prompt_service_1 = __webpack_require__(/*! ./prompt-service */ "../../node_modules/@theia/ai-core/lib/common/prompt-service.js");
exports.AgentService = Symbol('AgentService');
let AgentServiceImpl = class AgentServiceImpl {
    constructor() {
        this.disabledAgents = new Set();
        this._agents = [];
        this.onDidChangeAgentsEmitter = new core_1.Emitter();
        this.onDidChangeAgents = this.onDidChangeAgentsEmitter.event;
    }
    init() {
        var _a;
        (_a = this.aiSettingsService) === null || _a === void 0 ? void 0 : _a.getSettings().then(settings => {
            Object.entries(settings).forEach(([agentId, agentSettings]) => {
                if (agentSettings.enable === false) {
                    this.disabledAgents.add(agentId);
                }
            });
        });
    }
    registerAgent(agent) {
        this._agents.push(agent);
        agent.promptTemplates.forEach(template => this.promptService.storePromptTemplate(template));
        this.onDidChangeAgentsEmitter.fire();
    }
    unregisterAgent(agentId) {
        const agent = this._agents.find(a => a.id === agentId);
        this._agents = this._agents.filter(a => a.id !== agentId);
        this.onDidChangeAgentsEmitter.fire();
        agent === null || agent === void 0 ? void 0 : agent.promptTemplates.forEach(template => this.promptService.removePrompt(template.id));
    }
    getAgents() {
        return this._agents.filter(agent => this.isEnabled(agent.id));
    }
    getAllAgents() {
        return this._agents;
    }
    enableAgent(agentId) {
        var _a;
        this.disabledAgents.delete(agentId);
        (_a = this.aiSettingsService) === null || _a === void 0 ? void 0 : _a.updateAgentSettings(agentId, { enable: true });
    }
    disableAgent(agentId) {
        var _a;
        this.disabledAgents.add(agentId);
        (_a = this.aiSettingsService) === null || _a === void 0 ? void 0 : _a.updateAgentSettings(agentId, { enable: false });
    }
    isEnabled(agentId) {
        return !this.disabledAgents.has(agentId);
    }
};
exports.AgentServiceImpl = AgentServiceImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(settings_service_1.AISettingsService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], AgentServiceImpl.prototype, "aiSettingsService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(prompt_service_1.PromptService),
    tslib_1.__metadata("design:type", Object)
], AgentServiceImpl.prototype, "promptService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AgentServiceImpl.prototype, "init", null);
exports.AgentServiceImpl = AgentServiceImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AgentServiceImpl);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/agent.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/agent.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Agent = void 0;
exports.Agent = Symbol('Agent');


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/agents-variable-contribution.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/agents-variable-contribution.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgentsVariableContribution = exports.AGENTS_VARIABLE = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const agent_service_1 = __webpack_require__(/*! ./agent-service */ "../../node_modules/@theia/ai-core/lib/common/agent-service.js");
exports.AGENTS_VARIABLE = {
    id: 'agents',
    name: 'agents',
    description: core_1.nls.localize('theia/ai/core/agentsVariable/description', 'Returns the list of agents available in the system')
};
let AgentsVariableContribution = class AgentsVariableContribution {
    registerVariables(service) {
        service.registerResolver(exports.AGENTS_VARIABLE, this);
    }
    canResolve(request, _context) {
        if (request.variable.name === exports.AGENTS_VARIABLE.name) {
            return 1;
        }
        return -1;
    }
    async resolve(request, context) {
        if (request.variable.name === exports.AGENTS_VARIABLE.name) {
            const agents = this.agentService.getAgents().map(agent => ({
                id: agent.id,
                name: agent.name,
                description: agent.description
            }));
            return { variable: exports.AGENTS_VARIABLE, agents, value: JSON.stringify(agents) };
        }
    }
};
exports.AgentsVariableContribution = AgentsVariableContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(agent_service_1.AgentService),
    tslib_1.__metadata("design:type", Object)
], AgentsVariableContribution.prototype, "agentService", void 0);
exports.AgentsVariableContribution = AgentsVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AgentsVariableContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/ai-variable-resource.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/ai-variable-resource.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIVariableResourceResolver = exports.NO_CONTEXT_AUTHORITY = exports.AI_VARIABLE_RESOURCE_SCHEME = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const deepEqual = __webpack_require__(/*! fast-deep-equal */ "../../node_modules/fast-deep-equal/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const stableJsonStringify = __webpack_require__(/*! fast-json-stable-stringify */ "../../node_modules/fast-json-stable-stringify/index.js");
const configurable_in_memory_resources_1 = __webpack_require__(/*! ./configurable-in-memory-resources */ "../../node_modules/@theia/ai-core/lib/common/configurable-in-memory-resources.js");
exports.AI_VARIABLE_RESOURCE_SCHEME = 'ai-variable';
exports.NO_CONTEXT_AUTHORITY = 'context-free';
let AIVariableResourceResolver = class AIVariableResourceResolver {
    constructor() {
        this.cache = new Map();
    }
    init() {
        this.inMemoryResources.onWillDispose(resource => this.cache.delete(resource.uri.toString()));
    }
    getOrCreate(request, context, value) {
        const uri = this.toUri(request, context);
        try {
            const existing = this.inMemoryResources.resolve(uri);
            existing.update({ contents: value });
            return existing;
        }
        catch { /* No-op */ }
        const fresh = this.inMemoryResources.add(uri, { contents: value, readOnly: true, initiallyDirty: false });
        const key = uri.toString();
        this.cache.set(key, [fresh, context]);
        return fresh;
    }
    toUri(request, context) {
        return core_1.URI.fromComponents({
            scheme: exports.AI_VARIABLE_RESOURCE_SCHEME,
            query: stableJsonStringify({ arg: request.arg, name: request.variable.name }),
            path: '/',
            authority: this.toAuthority(context),
            fragment: ''
        });
    }
    toAuthority(context) {
        try {
            if (deepEqual(context, {})) {
                return exports.NO_CONTEXT_AUTHORITY;
            }
            for (const [resource, cachedContext] of this.cache.values()) {
                if (deepEqual(context, cachedContext)) {
                    return resource.uri.authority;
                }
            }
        }
        catch (err) {
            // Mostly that deep equal could overflow the stack, but it should run into === or inequality before that.
            console.warn('Problem evaluating context in AIVariableResourceResolver', err);
        }
        return (0, core_1.generateUuid)();
    }
    fromUri(uri) {
        if (uri.scheme !== exports.AI_VARIABLE_RESOURCE_SCHEME) {
            return undefined;
        }
        try {
            const { name: variableName, arg } = JSON.parse(uri.query);
            return variableName ? {
                variableName,
                arg,
            } : undefined;
        }
        catch {
            return undefined;
        }
    }
};
exports.AIVariableResourceResolver = AIVariableResourceResolver;
tslib_1.__decorate([
    (0, inversify_1.inject)(configurable_in_memory_resources_1.ConfigurableInMemoryResources),
    tslib_1.__metadata("design:type", configurable_in_memory_resources_1.ConfigurableInMemoryResources)
], AIVariableResourceResolver.prototype, "inMemoryResources", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AIVariableResourceResolver.prototype, "init", null);
exports.AIVariableResourceResolver = AIVariableResourceResolver = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIVariableResourceResolver);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/communication-recording-service.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/communication-recording-service.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommunicationRecordingService = void 0;
exports.CommunicationRecordingService = Symbol('CommunicationRecordingService');


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/configurable-in-memory-resources.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/configurable-in-memory-resources.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclispeSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConfigurableMutableReferenceResource = exports.ConfigurableMutableResource = exports.ConfigurableInMemoryResources = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let ConfigurableInMemoryResources = class ConfigurableInMemoryResources {
    constructor() {
        this.resources = new core_1.SyncReferenceCollection(uri => new ConfigurableMutableResource(new core_1.URI(uri)));
    }
    get onWillDispose() {
        return this.resources.onWillDispose;
    }
    add(uri, options) {
        const resourceUri = uri.toString();
        if (this.resources.has(resourceUri)) {
            throw new Error(`Cannot add already existing in-memory resource '${resourceUri}'`);
        }
        const resource = this.acquire(resourceUri);
        resource.update(options);
        return resource;
    }
    update(uri, options) {
        const resourceUri = uri.toString();
        const resource = this.resources.get(resourceUri);
        if (!resource) {
            throw new Error(`Cannot update non-existent in-memory resource '${resourceUri}'`);
        }
        resource.update(options);
        return resource;
    }
    resolve(uri) {
        const uriString = uri.toString();
        if (!this.resources.has(uriString)) {
            throw new Error(`In memory '${uriString}' resource does not exist.`);
        }
        return this.acquire(uriString);
    }
    acquire(uri) {
        const reference = this.resources.acquire(uri);
        return new ConfigurableMutableReferenceResource(reference);
    }
};
exports.ConfigurableInMemoryResources = ConfigurableInMemoryResources;
exports.ConfigurableInMemoryResources = ConfigurableInMemoryResources = tslib_1.__decorate([
    (0, inversify_1.injectable)()
    /** For creating highly configurable in-memory resources */
], ConfigurableInMemoryResources);
class ConfigurableMutableResource {
    fireDidChangeContents() {
        this.onDidChangeContentsEmitter.fire();
    }
    constructor(uri, options) {
        this.uri = uri;
        this.options = options;
        this.onDidChangeContentsEmitter = new core_1.Emitter();
        this.onDidChangeContents = this.onDidChangeContentsEmitter.event;
        this.onDidChangeReadonlyEmitter = new core_1.Emitter();
        this.onDidChangeReadOnly = this.onDidChangeReadonlyEmitter.event;
    }
    get readOnly() {
        var _a;
        return (_a = this.options) === null || _a === void 0 ? void 0 : _a.readOnly;
    }
    get autosaveable() {
        var _a;
        return ((_a = this.options) === null || _a === void 0 ? void 0 : _a.autosaveable) !== false;
    }
    get initiallyDirty() {
        var _a;
        return !!((_a = this.options) === null || _a === void 0 ? void 0 : _a.initiallyDirty);
    }
    readContents() {
        var _a, _b;
        return Promise.resolve((_b = (_a = this.options) === null || _a === void 0 ? void 0 : _a.contents) !== null && _b !== void 0 ? _b : '');
    }
    async saveContents(contents) {
        var _a, _b;
        await ((_b = (_a = this.options) === null || _a === void 0 ? void 0 : _a.onSave) === null || _b === void 0 ? void 0 : _b.call(_a, contents));
        this.update({ contents });
    }
    update(options) {
        var _a, _b, _c;
        const didContentsChange = 'contents' in options && options.contents !== ((_a = this.options) === null || _a === void 0 ? void 0 : _a.contents);
        const didReadOnlyChange = 'readOnly' in options && options.readOnly !== ((_b = this.options) === null || _b === void 0 ? void 0 : _b.readOnly);
        this.options = { ...this.options, ...options };
        if (didContentsChange) {
            this.onDidChangeContentsEmitter.fire();
        }
        if (didReadOnlyChange) {
            this.onDidChangeReadonlyEmitter.fire((_c = this.readOnly) !== null && _c !== void 0 ? _c : false);
        }
    }
    dispose() {
        this.onDidChangeContentsEmitter.dispose();
    }
}
exports.ConfigurableMutableResource = ConfigurableMutableResource;
class ConfigurableMutableReferenceResource {
    constructor(reference) {
        this.reference = reference;
    }
    get uri() {
        return this.reference.object.uri;
    }
    get onDidChangeContents() {
        return this.reference.object.onDidChangeContents;
    }
    dispose() {
        this.reference.dispose();
    }
    readContents() {
        return this.reference.object.readContents();
    }
    saveContents(contents) {
        return this.reference.object.saveContents(contents);
    }
    update(options) {
        this.reference.object.update(options);
    }
    get readOnly() {
        return this.reference.object.readOnly;
    }
    get initiallyDirty() {
        return this.reference.object.initiallyDirty;
    }
    get autosaveable() {
        return this.reference.object.autosaveable;
    }
}
exports.ConfigurableMutableReferenceResource = ConfigurableMutableReferenceResource;


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/index.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
tslib_1.__exportStar(__webpack_require__(/*! ./agent-service */ "../../node_modules/@theia/ai-core/lib/common/agent-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./agent */ "../../node_modules/@theia/ai-core/lib/common/agent.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./agents-variable-contribution */ "../../node_modules/@theia/ai-core/lib/common/agents-variable-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./communication-recording-service */ "../../node_modules/@theia/ai-core/lib/common/communication-recording-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./tool-invocation-registry */ "../../node_modules/@theia/ai-core/lib/common/tool-invocation-registry.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./language-model-delegate */ "../../node_modules/@theia/ai-core/lib/common/language-model-delegate.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./language-model-util */ "../../node_modules/@theia/ai-core/lib/common/language-model-util.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./language-model */ "../../node_modules/@theia/ai-core/lib/common/language-model.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./prompt-service */ "../../node_modules/@theia/ai-core/lib/common/prompt-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./prompt-service-util */ "../../node_modules/@theia/ai-core/lib/common/prompt-service-util.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./prompt-text */ "../../node_modules/@theia/ai-core/lib/common/prompt-text.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./protocol */ "../../node_modules/@theia/ai-core/lib/common/protocol.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./today-variable-contribution */ "../../node_modules/@theia/ai-core/lib/common/today-variable-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./variable-service */ "../../node_modules/@theia/ai-core/lib/common/variable-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./settings-service */ "../../node_modules/@theia/ai-core/lib/common/settings-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./language-model-service */ "../../node_modules/@theia/ai-core/lib/common/language-model-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./token-usage-service */ "../../node_modules/@theia/ai-core/lib/common/token-usage-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-variable-resource */ "../../node_modules/@theia/ai-core/lib/common/ai-variable-resource.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./configurable-in-memory-resources */ "../../node_modules/@theia/ai-core/lib/common/configurable-in-memory-resources.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/language-model-delegate.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/language-model-delegate.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.languageModelDelegatePath = exports.languageModelRegistryDelegatePath = exports.LanguageModelFrontendDelegate = exports.isLanguageModelStreamResponseDelegate = exports.LanguageModelRegistryFrontendDelegate = exports.LanguageModelDelegateClient = void 0;
exports.LanguageModelDelegateClient = Symbol('LanguageModelDelegateClient');
exports.LanguageModelRegistryFrontendDelegate = Symbol('LanguageModelRegistryFrontendDelegate');
const isLanguageModelStreamResponseDelegate = (obj) => !!(obj && typeof obj === 'object' && 'streamId' in obj && typeof obj.streamId === 'string');
exports.isLanguageModelStreamResponseDelegate = isLanguageModelStreamResponseDelegate;
exports.LanguageModelFrontendDelegate = Symbol('LanguageModelFrontendDelegate');
exports.languageModelRegistryDelegatePath = '/services/languageModelRegistryDelegatePath';
exports.languageModelDelegatePath = '/services/languageModelDelegatePath';


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/language-model-service.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/language-model-service.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LanguageModelServiceImpl = exports.LanguageModelService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const language_model_1 = __webpack_require__(/*! ./language-model */ "../../node_modules/@theia/ai-core/lib/common/language-model.js");
const communication_recording_service_1 = __webpack_require__(/*! ./communication-recording-service */ "../../node_modules/@theia/ai-core/lib/common/communication-recording-service.js");
exports.LanguageModelService = Symbol('LanguageModelService');
class LanguageModelServiceImpl {
    async sendRequest(languageModel, languageModelRequest) {
        // Filter messages based on client settings
        languageModelRequest.messages = languageModelRequest.messages.filter(message => {
            var _a, _b;
            if (message.type === 'thinking' && ((_a = languageModelRequest.clientSettings) === null || _a === void 0 ? void 0 : _a.keepThinking) === false) {
                return false;
            }
            if ((message.type === 'tool_result' || message.type === 'tool_use') &&
                ((_b = languageModelRequest.clientSettings) === null || _b === void 0 ? void 0 : _b.keepToolCalls) === false) {
                return false;
            }
            // Keep all other messages
            return true;
        });
        return languageModel.request(languageModelRequest, languageModelRequest.cancellationToken);
    }
}
exports.LanguageModelServiceImpl = LanguageModelServiceImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(language_model_1.LanguageModelRegistry),
    tslib_1.__metadata("design:type", Object)
], LanguageModelServiceImpl.prototype, "languageModelRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(communication_recording_service_1.CommunicationRecordingService),
    tslib_1.__metadata("design:type", Object)
], LanguageModelServiceImpl.prototype, "recordingService", void 0);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/language-model-util.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/language-model-util.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.toolRequestToPromptText = exports.getJsonOfText = exports.getJsonOfResponse = exports.getTextOfResponse = void 0;
const language_model_1 = __webpack_require__(/*! ./language-model */ "../../node_modules/@theia/ai-core/lib/common/language-model.js");
/**
 * Retrieves the text content from a `LanguageModelResponse` object.
 *
 * **Important:** For stream responses, the stream can only be consumed once. Calling this function multiple times on the same stream response will return an empty string (`''`)
 * on subsequent calls, as the stream will have already been consumed.
 *
 * @param {LanguageModelResponse} response - The response object, which may contain a text, stream, or parsed response.
 * @returns {Promise<string>} - A promise that resolves to the text content of the response.
 * @throws {Error} - Throws an error if the response type is not supported or does not contain valid text content.
 */
const getTextOfResponse = async (response) => {
    if ((0, language_model_1.isLanguageModelTextResponse)(response)) {
        return response.text;
    }
    else if ((0, language_model_1.isLanguageModelStreamResponse)(response)) {
        let result = '';
        for await (const chunk of response.stream) {
            result += ((0, language_model_1.isTextResponsePart)(chunk) && chunk.content) ? chunk.content : '';
        }
        return result;
    }
    else if ((0, language_model_1.isLanguageModelParsedResponse)(response)) {
        return response.content;
    }
    throw new Error(`Invalid response type ${response}`);
};
exports.getTextOfResponse = getTextOfResponse;
const getJsonOfResponse = async (response) => {
    const text = await (0, exports.getTextOfResponse)(response);
    return (0, exports.getJsonOfText)(text);
};
exports.getJsonOfResponse = getJsonOfResponse;
const getJsonOfText = (text) => {
    if (text.startsWith('```json')) {
        const regex = /```json\s*([\s\S]*?)\s*```/g;
        let match;
        // eslint-disable-next-line no-null/no-null
        while ((match = regex.exec(text)) !== null) {
            try {
                return JSON.parse(match[1]);
            }
            catch (error) {
                console.error('Failed to parse JSON:', error);
            }
        }
    }
    else if (text.startsWith('{') || text.startsWith('[')) {
        return JSON.parse(text);
    }
    throw new Error('Invalid response format');
};
exports.getJsonOfText = getJsonOfText;
const toolRequestToPromptText = (toolRequest) => `${toolRequest.id}`;
exports.toolRequestToPromptText = toolRequestToPromptText;


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/language-model.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/language-model.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024-2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isModelMatching = exports.DefaultLanguageModelRegistryImpl = exports.LanguageModelRegistry = exports.LanguageModel = exports.LanguageModelMetaData = exports.LanguageModelProvider = exports.isLanguageModelParsedResponse = exports.isLanguageModelStreamResponse = exports.isThinkingResponsePart = exports.isToolCallResponsePart = exports.isTextResponsePart = exports.isUsageResponsePart = exports.isLanguageModelTextResponse = exports.ToolRequest = exports.isLanguageModelRequestMessage = exports.LanguageModelMessage = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
var LanguageModelMessage;
(function (LanguageModelMessage) {
    function isTextMessage(obj) {
        return obj.type === 'text';
    }
    LanguageModelMessage.isTextMessage = isTextMessage;
    function isThinkingMessage(obj) {
        return obj.type === 'thinking';
    }
    LanguageModelMessage.isThinkingMessage = isThinkingMessage;
    function isToolUseMessage(obj) {
        return obj.type === 'tool_use';
    }
    LanguageModelMessage.isToolUseMessage = isToolUseMessage;
    function isToolResultMessage(obj) {
        return obj.type === 'tool_result';
    }
    LanguageModelMessage.isToolResultMessage = isToolResultMessage;
})(LanguageModelMessage || (exports.LanguageModelMessage = LanguageModelMessage = {}));
const isLanguageModelRequestMessage = (obj) => !!(obj && typeof obj === 'object' &&
    'type' in obj &&
    typeof obj.type === 'string' &&
    obj.type === 'text' &&
    'query' in obj &&
    typeof obj.query === 'string');
exports.isLanguageModelRequestMessage = isLanguageModelRequestMessage;
var ToolRequest;
(function (ToolRequest) {
    function isToolRequestParameterProperty(obj) {
        if (!obj || typeof obj !== 'object') {
            return false;
        }
        const record = obj;
        // Check that at least one of "type" or "anyOf" exists
        if (!('type' in record) && !('anyOf' in record)) {
            return false;
        }
        // If an "anyOf" field is present, it must be an array where each item is also a valid property.
        if ('anyOf' in record) {
            if (!Array.isArray(record.anyOf)) {
                return false;
            }
            for (const item of record.anyOf) {
                if (!isToolRequestParameterProperty(item)) {
                    return false;
                }
            }
        }
        if ('type' in record && typeof record.type !== 'string') {
            return false;
        }
        // No further checks required for additional properties.
        return true;
    }
    function isToolRequestParametersProperties(obj) {
        if (!obj || typeof obj !== 'object') {
            return false;
        }
        return Object.entries(obj).every(([key, value]) => {
            if (typeof key !== 'string') {
                return false;
            }
            return isToolRequestParameterProperty(value);
        });
    }
    ToolRequest.isToolRequestParametersProperties = isToolRequestParametersProperties;
    function isToolRequestParameters(obj) {
        return !!obj && typeof obj === 'object' &&
            (!('type' in obj) || obj.type === 'object') &&
            'properties' in obj && isToolRequestParametersProperties(obj.properties) &&
            (!('required' in obj) || (Array.isArray(obj.required) && obj.required.every(prop => typeof prop === 'string')));
    }
    ToolRequest.isToolRequestParameters = isToolRequestParameters;
})(ToolRequest || (exports.ToolRequest = ToolRequest = {}));
const isLanguageModelTextResponse = (obj) => !!(obj && typeof obj === 'object' && 'text' in obj && typeof obj.text === 'string');
exports.isLanguageModelTextResponse = isLanguageModelTextResponse;
const isUsageResponsePart = (part) => !!(part && typeof part === 'object' &&
    'input_tokens' in part && typeof part.input_tokens === 'number' &&
    'output_tokens' in part && typeof part.output_tokens === 'number');
exports.isUsageResponsePart = isUsageResponsePart;
const isTextResponsePart = (part) => !!(part && typeof part === 'object' && 'content' in part && typeof part.content === 'string');
exports.isTextResponsePart = isTextResponsePart;
const isToolCallResponsePart = (part) => !!(part && typeof part === 'object' && 'tool_calls' in part && Array.isArray(part.tool_calls));
exports.isToolCallResponsePart = isToolCallResponsePart;
const isThinkingResponsePart = (part) => !!(part && typeof part === 'object' && 'thought' in part && typeof part.thought === 'string');
exports.isThinkingResponsePart = isThinkingResponsePart;
const isLanguageModelStreamResponse = (obj) => !!(obj && typeof obj === 'object' && 'stream' in obj);
exports.isLanguageModelStreamResponse = isLanguageModelStreamResponse;
const isLanguageModelParsedResponse = (obj) => !!(obj && typeof obj === 'object' && 'parsed' in obj && 'content' in obj);
exports.isLanguageModelParsedResponse = isLanguageModelParsedResponse;
///////////////////////////////////////////
// Language Model Provider
///////////////////////////////////////////
exports.LanguageModelProvider = Symbol('LanguageModelProvider');
var LanguageModelMetaData;
(function (LanguageModelMetaData) {
    function is(arg) {
        return (0, core_1.isObject)(arg) && 'id' in arg;
    }
    LanguageModelMetaData.is = is;
})(LanguageModelMetaData || (exports.LanguageModelMetaData = LanguageModelMetaData = {}));
var LanguageModel;
(function (LanguageModel) {
    function is(arg) {
        return (0, core_1.isObject)(arg) && 'id' in arg && (0, core_1.isFunction)(arg.request);
    }
    LanguageModel.is = is;
})(LanguageModel || (exports.LanguageModel = LanguageModel = {}));
exports.LanguageModelRegistry = Symbol('LanguageModelRegistry');
let DefaultLanguageModelRegistryImpl = class DefaultLanguageModelRegistryImpl {
    constructor() {
        this.languageModels = [];
        this.initialized = new Promise(resolve => { this.markInitialized = resolve; });
        this.changeEmitter = new core_1.Emitter();
        this.onChange = this.changeEmitter.event;
    }
    init() {
        const contributions = this.languageModelContributions.getContributions();
        const promises = contributions.map(provider => provider());
        Promise.allSettled(promises).then(results => {
            for (const result of results) {
                if (result.status === 'fulfilled') {
                    this.languageModels.push(...result.value);
                }
                else {
                    this.logger.error('Failed to add some language models:', result.reason);
                }
            }
            this.markInitialized();
        });
    }
    addLanguageModels(models) {
        models.forEach(model => {
            if (this.languageModels.find(lm => lm.id === model.id)) {
                console.warn(`Tried to add already existing language model with id ${model.id}. The new model will be ignored.`);
                return;
            }
            this.languageModels.push(model);
            this.changeEmitter.fire({ models: this.languageModels });
        });
    }
    async getLanguageModels() {
        await this.initialized;
        return this.languageModels;
    }
    async getLanguageModel(id) {
        await this.initialized;
        return this.languageModels.find(model => model.id === id);
    }
    removeLanguageModels(ids) {
        ids.forEach(id => {
            const index = this.languageModels.findIndex(model => model.id === id);
            if (index !== -1) {
                this.languageModels.splice(index, 1);
                this.changeEmitter.fire({ models: this.languageModels });
            }
            else {
                console.warn(`Language model with id ${id} was requested to be removed, however it does not exist`);
            }
        });
    }
    async selectLanguageModels(request) {
        await this.initialized;
        // TODO check for actor and purpose against settings
        return this.languageModels.filter(model => isModelMatching(request, model));
    }
    async selectLanguageModel(request) {
        return (await this.selectLanguageModels(request))[0];
    }
};
exports.DefaultLanguageModelRegistryImpl = DefaultLanguageModelRegistryImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    tslib_1.__metadata("design:type", Object)
], DefaultLanguageModelRegistryImpl.prototype, "logger", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(exports.LanguageModelProvider),
    tslib_1.__metadata("design:type", Object)
], DefaultLanguageModelRegistryImpl.prototype, "languageModelContributions", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DefaultLanguageModelRegistryImpl.prototype, "init", null);
exports.DefaultLanguageModelRegistryImpl = DefaultLanguageModelRegistryImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DefaultLanguageModelRegistryImpl);
function isModelMatching(request, model) {
    return (!request.identifier || model.id === request.identifier) &&
        (!request.name || model.name === request.name) &&
        (!request.vendor || model.vendor === request.vendor) &&
        (!request.version || model.version === request.version) &&
        (!request.family || model.family === request.family);
}
exports.isModelMatching = isModelMatching;


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/prompt-service-util.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/prompt-service-util.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.matchFunctionsRegEx = exports.PROMPT_FUNCTION_REGEX = exports.matchVariablesRegEx = exports.PROMPT_VARIABLE_THREE_BRACES_REGEX = exports.PROMPT_VARIABLE_TWO_BRACES_REGEX = void 0;
/** Should match the one from VariableResolverService. The format is `{{variableName:arg}}`. We allow {{}} and {{{}}} but no mixtures */
exports.PROMPT_VARIABLE_TWO_BRACES_REGEX = /(?<!\{)\{\{\s*([^{}]+?)\s*\}\}(?!\})/g;
exports.PROMPT_VARIABLE_THREE_BRACES_REGEX = /(?<!\{)\{\{\{\s*([^{}]+?)\s*\}\}\}(?!\})/g;
function matchVariablesRegEx(template) {
    const twoBraceMatches = [...template.matchAll(exports.PROMPT_VARIABLE_TWO_BRACES_REGEX)];
    const threeBraceMatches = [...template.matchAll(exports.PROMPT_VARIABLE_THREE_BRACES_REGEX)];
    return twoBraceMatches.concat(threeBraceMatches);
}
exports.matchVariablesRegEx = matchVariablesRegEx;
/** Match function/tool references in the prompt. The format is `~{functionId}`. */
exports.PROMPT_FUNCTION_REGEX = /\~\{\s*(.*?)\s*\}/g;
function matchFunctionsRegEx(template) {
    return [...template.matchAll(exports.PROMPT_FUNCTION_REGEX)];
}
exports.matchFunctionsRegEx = matchFunctionsRegEx;


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/prompt-service.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/prompt-service.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PromptServiceImpl = exports.PromptCustomizationService = exports.CustomAgentDescription = exports.PromptService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const variable_service_1 = __webpack_require__(/*! ./variable-service */ "../../node_modules/@theia/ai-core/lib/common/variable-service.js");
const tool_invocation_registry_1 = __webpack_require__(/*! ./tool-invocation-registry */ "../../node_modules/@theia/ai-core/lib/common/tool-invocation-registry.js");
const language_model_util_1 = __webpack_require__(/*! ./language-model-util */ "../../node_modules/@theia/ai-core/lib/common/language-model-util.js");
const prompt_service_util_1 = __webpack_require__(/*! ./prompt-service-util */ "../../node_modules/@theia/ai-core/lib/common/prompt-service-util.js");
const settings_service_1 = __webpack_require__(/*! ./settings-service */ "../../node_modules/@theia/ai-core/lib/common/settings-service.js");
exports.PromptService = Symbol('PromptService');
var CustomAgentDescription;
(function (CustomAgentDescription) {
    function is(entry) {
        // eslint-disable-next-line no-null/no-null
        return typeof entry === 'object' && entry !== null
            && 'id' in entry && typeof entry.id === 'string'
            && 'name' in entry && typeof entry.name === 'string'
            && 'description' in entry && typeof entry.description === 'string'
            && 'prompt' in entry
            && typeof entry.prompt === 'string'
            && 'defaultLLM' in entry
            && typeof entry.defaultLLM === 'string';
    }
    CustomAgentDescription.is = is;
    function equals(a, b) {
        return a.id === b.id && a.name === b.name && a.description === b.description && a.prompt === b.prompt && a.defaultLLM === b.defaultLLM;
    }
    CustomAgentDescription.equals = equals;
})(CustomAgentDescription || (exports.CustomAgentDescription = CustomAgentDescription = {}));
exports.PromptCustomizationService = Symbol('PromptCustomizationService');
let PromptServiceImpl = class PromptServiceImpl {
    constructor() {
        this._prompts = {};
    }
    getRawPrompt(id) {
        if (this.customizationService !== undefined && this.customizationService.isPromptTemplateCustomized(id)) {
            const template = this.customizationService.getCustomizedPromptTemplate(id);
            if (template !== undefined) {
                return { id, template };
            }
        }
        return this.getDefaultRawPrompt(id);
    }
    getDefaultRawPrompt(id) {
        return this._prompts[id];
    }
    getUnresolvedPrompt(id) {
        const rawPrompt = this.getRawPrompt(id);
        if (!rawPrompt) {
            return undefined;
        }
        return {
            id: rawPrompt.id,
            template: this.stripComments(rawPrompt.template)
        };
    }
    stripComments(template) {
        const commentRegex = /^\s*{{!--[\s\S]*?--}}\s*\n?/;
        return commentRegex.test(template) ? template.replace(commentRegex, '').trimStart() : template;
    }
    async getVariantId(id) {
        if (this.settingsService !== undefined) {
            const agentSettingsMap = await this.settingsService.getSettings();
            for (const agentSettings of Object.values(agentSettingsMap)) {
                if (agentSettings.selectedVariants && agentSettings.selectedVariants[id]) {
                    return agentSettings.selectedVariants[id];
                }
            }
        }
        return id;
    }
    async getPrompt(id, args, context) {
        const variantId = await this.getVariantId(id);
        const prompt = this.getUnresolvedPrompt(variantId);
        if (prompt === undefined) {
            return undefined;
        }
        // First resolve variables and arguments
        let resolvedTemplate = prompt.template;
        const variableAndArgReplacements = await this.getVariableAndArgReplacements(prompt.template, args, context);
        variableAndArgReplacements.replacements.forEach(replacement => resolvedTemplate = resolvedTemplate.replace(replacement.placeholder, replacement.value));
        // Then resolve function references with already resolved variables and arguments
        // This allows to resolve function references contained in resolved variables (e.g. prompt fragments)
        const functionMatches = (0, prompt_service_util_1.matchFunctionsRegEx)(resolvedTemplate);
        const functions = new Map();
        const functionReplacements = functionMatches.map(match => {
            var _a;
            const completeText = match[0];
            const functionId = match[1];
            const toolRequest = (_a = this.toolInvocationRegistry) === null || _a === void 0 ? void 0 : _a.getFunction(functionId);
            if (toolRequest) {
                functions.set(toolRequest.id, toolRequest);
            }
            return {
                placeholder: completeText,
                value: toolRequest ? (0, language_model_util_1.toolRequestToPromptText)(toolRequest) : completeText
            };
        });
        functionReplacements.forEach(replacement => resolvedTemplate = resolvedTemplate.replace(replacement.placeholder, replacement.value));
        return {
            id,
            text: resolvedTemplate,
            functionDescriptions: functions.size > 0 ? functions : undefined,
            variables: variableAndArgReplacements.resolvedVariables
        };
    }
    async getPromptFragment(id, args, context, resolveVariable) {
        const variantId = await this.getVariantId(id);
        const prompt = this.getUnresolvedPrompt(variantId);
        if (prompt === undefined) {
            return undefined;
        }
        const replacements = await this.getVariableAndArgReplacements(prompt.template, args, context, resolveVariable);
        let resolvedTemplate = prompt.template;
        replacements.replacements.forEach(replacement => resolvedTemplate = resolvedTemplate.replace(replacement.placeholder, replacement.value));
        return {
            id,
            text: resolvedTemplate,
            variables: replacements.resolvedVariables
        };
    }
    /**
     * Calculates all variable and argument replacements for an unresolved template.
     *
     * @param template the unresolved template text
     * @param args the object with placeholders, mapping the placeholder key to the value
     * @param context the {@link AIVariableContext} to use during variable resolution
     * @param resolveVariable the variable resolving method. Fall back to using the {@link AIVariableService} if not given.
     */
    async getVariableAndArgReplacements(template, args, context, resolveVariable) {
        var _a, _b, _c;
        const matches = (0, prompt_service_util_1.matchVariablesRegEx)(template);
        const variableCache = (0, variable_service_1.createAIResolveVariableCache)();
        const variableAndArgReplacements = [];
        const resolvedVariables = new Set();
        for (const match of matches) {
            const completeText = match[0];
            const variableAndArg = match[1];
            let variableName = variableAndArg;
            let argument;
            const parts = variableAndArg.split(':', 2);
            if (parts.length > 1) {
                variableName = parts[0];
                argument = parts[1];
            }
            let value;
            if (args && args[variableAndArg] !== undefined) {
                value = String(args[variableAndArg]);
            }
            else {
                const toResolve = { variable: variableName, arg: argument };
                const resolved = resolveVariable
                    ? await resolveVariable(toResolve)
                    : await ((_a = this.variableService) === null || _a === void 0 ? void 0 : _a.resolveVariable(toResolve, context !== null && context !== void 0 ? context : {}, variableCache));
                // Track resolved variable and its dependencies in all resolved variables
                if (resolved) {
                    resolvedVariables.add(resolved);
                    (_b = resolved.allResolvedDependencies) === null || _b === void 0 ? void 0 : _b.forEach(v => resolvedVariables.add(v));
                }
                value = String((_c = resolved === null || resolved === void 0 ? void 0 : resolved.value) !== null && _c !== void 0 ? _c : completeText);
            }
            variableAndArgReplacements.push({ placeholder: completeText, value });
        }
        return { replacements: variableAndArgReplacements, resolvedVariables: Array.from(resolvedVariables) };
    }
    getAllPrompts() {
        if (this.customizationService !== undefined) {
            const myCustomization = this.customizationService;
            const result = {};
            Object.keys(this._prompts).forEach(id => {
                if (myCustomization.isPromptTemplateCustomized(id)) {
                    const template = myCustomization.getCustomizedPromptTemplate(id);
                    if (template !== undefined) {
                        result[id] = { id, template };
                    }
                    else {
                        result[id] = { ...this._prompts[id] };
                    }
                }
                else {
                    result[id] = { ...this._prompts[id] };
                }
            });
            return result;
        }
        else {
            return { ...this._prompts };
        }
    }
    removePrompt(id) {
        delete this._prompts[id];
    }
    getVariantIds(id) {
        var _a;
        const allCustomPromptTemplateIds = ((_a = this.customizationService) === null || _a === void 0 ? void 0 : _a.getCustomPromptTemplateIDs()) || [];
        const knownPromptIds = Object.keys(this._prompts);
        // We filter out known IDs from the custom prompt template IDs, these are no variants, but customizations. Then we retain IDs that start with the main ID
        const customVariantIds = allCustomPromptTemplateIds.filter(customId => !knownPromptIds.includes(customId) && customId.startsWith(id));
        const variantIds = Object.values(this._prompts)
            .filter(prompt => prompt.variantOf === id)
            .map(variant => variant.id);
        return [...variantIds, ...customVariantIds];
    }
    storePromptTemplate(promptTemplate) {
        this._prompts[promptTemplate.id] = promptTemplate;
    }
};
exports.PromptServiceImpl = PromptServiceImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(settings_service_1.AISettingsService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], PromptServiceImpl.prototype, "settingsService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.PromptCustomizationService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], PromptServiceImpl.prototype, "customizationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(variable_service_1.AIVariableService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], PromptServiceImpl.prototype, "variableService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(tool_invocation_registry_1.ToolInvocationRegistry),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], PromptServiceImpl.prototype, "toolInvocationRegistry", void 0);
exports.PromptServiceImpl = PromptServiceImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PromptServiceImpl);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/prompt-text.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/prompt-text.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PromptText = void 0;
var PromptText;
(function (PromptText) {
    PromptText.AGENT_CHAR = '@';
    PromptText.VARIABLE_CHAR = '#';
    PromptText.FUNCTION_CHAR = '~';
    PromptText.VARIABLE_SEPARATOR_CHAR = ':';
})(PromptText || (exports.PromptText = PromptText = {}));


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/protocol.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/protocol.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenUsageServiceClient = exports.TOKEN_USAGE_SERVICE_PATH = exports.LanguageModelRegistryClient = void 0;
exports.LanguageModelRegistryClient = Symbol('LanguageModelRegistryClient');
exports.TOKEN_USAGE_SERVICE_PATH = '/services/token-usage';
exports.TokenUsageServiceClient = Symbol('TokenUsageServiceClient');


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/settings-service.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/settings-service.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AISettingsService = void 0;
exports.AISettingsService = Symbol('AISettingsService');


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/today-variable-contribution.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/today-variable-contribution.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TodayVariableContribution = exports.TODAY_VARIABLE = exports.TodayVariableArgs = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
var TodayVariableArgs;
(function (TodayVariableArgs) {
    TodayVariableArgs.IN_UNIX_SECONDS = 'inUnixSeconds';
    TodayVariableArgs.IN_ISO_8601 = 'inIso8601';
})(TodayVariableArgs || (exports.TodayVariableArgs = TodayVariableArgs = {}));
exports.TODAY_VARIABLE = {
    id: 'today-provider',
    description: core_1.nls.localize('theia/ai/core/todayVariable/description', 'Does something for today'),
    name: 'today',
    args: [
        {
            name: 'Format',
            description: core_1.nls.localize('theia/ai/core/todayVariable/format/description', 'The format of the date'),
            enum: [TodayVariableArgs.IN_ISO_8601, TodayVariableArgs.IN_UNIX_SECONDS],
            isOptional: true
        }
    ]
};
let TodayVariableContribution = class TodayVariableContribution {
    registerVariables(service) {
        service.registerResolver(exports.TODAY_VARIABLE, this);
    }
    canResolve(request, context) {
        return 1;
    }
    async resolve(request, context) {
        if (request.variable.name === exports.TODAY_VARIABLE.name) {
            return this.resolveTodayVariable(request);
        }
        return undefined;
    }
    resolveTodayVariable(request) {
        const date = new Date();
        if (request.arg === TodayVariableArgs.IN_ISO_8601) {
            return { variable: request.variable, value: date.toISOString(), date };
        }
        if (request.arg === TodayVariableArgs.IN_UNIX_SECONDS) {
            return { variable: request.variable, value: Math.round(date.getTime() / 1000).toString(), date };
        }
        return { variable: request.variable, value: date.toDateString(), date };
    }
};
exports.TodayVariableContribution = TodayVariableContribution;
exports.TodayVariableContribution = TodayVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TodayVariableContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/token-usage-service.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/token-usage-service.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TokenUsageService = void 0;
exports.TokenUsageService = Symbol('TokenUsageService');


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/tool-invocation-registry.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/tool-invocation-registry.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolInvocationRegistryImpl = exports.bindToolProvider = exports.ToolProvider = exports.ToolInvocationRegistry = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.ToolInvocationRegistry = Symbol('ToolInvocationRegistry');
exports.ToolProvider = Symbol('ToolProvider');
/** Binds the identifier to self in singleton scope and then binds `ToolProvider` to that service. */
function bindToolProvider(identifier, bind) {
    bind(identifier).toSelf().inSingletonScope();
    bind(exports.ToolProvider).toService(identifier);
}
exports.bindToolProvider = bindToolProvider;
let ToolInvocationRegistryImpl = class ToolInvocationRegistryImpl {
    constructor() {
        this.tools = new Map();
    }
    init() {
        this.providers.getContributions().forEach(provider => {
            this.registerTool(provider.getTool());
        });
    }
    unregisterAllTools(providerName) {
        const toolsToRemove = [];
        for (const [id, tool] of this.tools.entries()) {
            if (tool.providerName === providerName) {
                toolsToRemove.push(id);
            }
        }
        toolsToRemove.forEach(id => this.tools.delete(id));
    }
    getAllFunctions() {
        return Array.from(this.tools.values());
    }
    registerTool(tool) {
        if (this.tools.has(tool.id)) {
            console.warn(`Function with id ${tool.id} is already registered.`);
        }
        else {
            this.tools.set(tool.id, tool);
        }
    }
    getFunction(toolId) {
        return this.tools.get(toolId);
    }
    getFunctions(...toolIds) {
        const tools = toolIds.map(toolId => {
            const tool = this.tools.get(toolId);
            if (tool) {
                return tool;
            }
            else {
                throw new Error(`Function with id ${toolId} does not exist.`);
            }
        });
        return tools;
    }
};
exports.ToolInvocationRegistryImpl = ToolInvocationRegistryImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(exports.ToolProvider),
    tslib_1.__metadata("design:type", Object)
], ToolInvocationRegistryImpl.prototype, "providers", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ToolInvocationRegistryImpl.prototype, "init", null);
exports.ToolInvocationRegistryImpl = ToolInvocationRegistryImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ToolInvocationRegistryImpl);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/common/variable-service.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/common/variable-service.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// Partially copied from https://github.com/microsoft/vscode/blob/a2cab7255c0df424027be05d58e1b7b941f4ea60/src/vs/workbench/contrib/chat/common/chatVariables.ts
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultAIVariableService = exports.getAllResolvedAIVariables = exports.createAIResolveVariableCache = exports.AIVariableContribution = exports.AIVariableService = exports.AIVariableResolutionRequest = exports.ResolvedAIContextVariable = exports.ResolvedAIVariable = exports.AIContextVariable = exports.AIVariable = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const prompt_text_1 = __webpack_require__(/*! ./prompt-text */ "../../node_modules/@theia/ai-core/lib/common/prompt-text.js");
var AIVariable;
(function (AIVariable) {
    function is(arg) {
        return !!arg && typeof arg === 'object' &&
            'id' in arg &&
            'name' in arg &&
            'description' in arg;
    }
    AIVariable.is = is;
})(AIVariable || (exports.AIVariable = AIVariable = {}));
var AIContextVariable;
(function (AIContextVariable) {
    function is(arg) {
        return AIVariable.is(arg) && 'isContextVariable' in arg && arg.isContextVariable === true;
    }
    AIContextVariable.is = is;
})(AIContextVariable || (exports.AIContextVariable = AIContextVariable = {}));
var ResolvedAIVariable;
(function (ResolvedAIVariable) {
    function is(arg) {
        return !!arg && typeof arg === 'object' &&
            'variable' in arg &&
            'value' in arg &&
            typeof arg.variable === 'object' &&
            typeof arg.value === 'string';
    }
    ResolvedAIVariable.is = is;
})(ResolvedAIVariable || (exports.ResolvedAIVariable = ResolvedAIVariable = {}));
var ResolvedAIContextVariable;
(function (ResolvedAIContextVariable) {
    function is(arg) {
        return ResolvedAIVariable.is(arg) &&
            'contextValue' in arg &&
            typeof arg.contextValue === 'string';
    }
    ResolvedAIContextVariable.is = is;
})(ResolvedAIContextVariable || (exports.ResolvedAIContextVariable = ResolvedAIContextVariable = {}));
var AIVariableResolutionRequest;
(function (AIVariableResolutionRequest) {
    function is(arg) {
        return !!arg && typeof arg === 'object' &&
            'variable' in arg &&
            typeof arg.variable.name === 'string';
    }
    AIVariableResolutionRequest.is = is;
    function fromResolved(arg) {
        return {
            variable: arg.variable,
            arg: arg.arg
        };
    }
    AIVariableResolutionRequest.fromResolved = fromResolved;
})(AIVariableResolutionRequest || (exports.AIVariableResolutionRequest = AIVariableResolutionRequest = {}));
function isResolverWithDependencies(resolver) {
    return resolver !== undefined && resolver.resolve.length >= 3;
}
exports.AIVariableService = Symbol('AIVariableService');
/** Contributions on the frontend can optionally implement `FrontendVariableContribution`. */
exports.AIVariableContribution = Symbol('AIVariableContribution');
/**
 * Creates a new, empty cache for AI variable resolution to hand into `AIVariableService.resolveVariable`.
 */
function createAIResolveVariableCache() {
    return new Map();
}
exports.createAIResolveVariableCache = createAIResolveVariableCache;
/** Utility function to get all resolved AI variables from a {@link ResolveAIVariableCache}  */
async function getAllResolvedAIVariables(cache) {
    const resolvedVariables = [];
    for (const cacheEntry of cache.values()) {
        if (!cacheEntry.inProgress) {
            const resolvedVariable = await cacheEntry.promise;
            if (resolvedVariable) {
                resolvedVariables.push(resolvedVariable);
            }
        }
    }
    return resolvedVariables;
}
exports.getAllResolvedAIVariables = getAllResolvedAIVariables;
let DefaultAIVariableService = class DefaultAIVariableService {
    constructor(contributionProvider, logger) {
        this.contributionProvider = contributionProvider;
        this.logger = logger;
        this.variables = new Map();
        this.resolvers = new Map();
        this.argPickers = new Map();
        this.openers = new Map();
        this.argCompletionProviders = new Map();
        this.onDidChangeVariablesEmitter = new core_1.Emitter();
        this.onDidChangeVariables = this.onDidChangeVariablesEmitter.event;
    }
    initContributions() {
        this.contributionProvider.getContributions().forEach(contribution => contribution.registerVariables(this));
    }
    getKey(name) {
        return `${name.toLowerCase()}`;
    }
    async getResolver(name, arg, context) {
        const resolvers = await this.prioritize(name, arg, context);
        return resolvers[0];
    }
    getResolvers(name) {
        var _a;
        return (_a = this.resolvers.get(this.getKey(name))) !== null && _a !== void 0 ? _a : [];
    }
    async prioritize(name, arg, context) {
        const variable = this.getVariable(name);
        if (!variable) {
            return [];
        }
        const prioritized = await core_1.Prioritizeable.prioritizeAll(this.getResolvers(name), async (resolver) => {
            try {
                return await resolver.canResolve({ variable, arg }, context);
            }
            catch {
                return 0;
            }
        });
        return prioritized.map(p => p.value);
    }
    hasVariable(name) {
        return !!this.getVariable(name);
    }
    getVariable(name) {
        return this.variables.get(this.getKey(name));
    }
    getVariables() {
        return [...this.variables.values()];
    }
    getContextVariables() {
        return this.getVariables().filter(AIContextVariable.is);
    }
    registerResolver(variable, resolver) {
        var _a;
        const key = this.getKey(variable.name);
        if (!this.variables.get(key)) {
            this.variables.set(key, variable);
            this.onDidChangeVariablesEmitter.fire();
        }
        const resolvers = (_a = this.resolvers.get(key)) !== null && _a !== void 0 ? _a : [];
        resolvers.push(resolver);
        this.resolvers.set(key, resolvers);
        return core_1.Disposable.create(() => this.unregisterResolver(variable, resolver));
    }
    unregisterResolver(variable, resolver) {
        const key = this.getKey(variable.name);
        const registeredResolvers = this.resolvers.get(key);
        registeredResolvers === null || registeredResolvers === void 0 ? void 0 : registeredResolvers.splice(registeredResolvers.indexOf(resolver), 1);
        if ((registeredResolvers === null || registeredResolvers === void 0 ? void 0 : registeredResolvers.length) === 0) {
            this.unregisterVariable(variable.name);
        }
    }
    unregisterVariable(name) {
        this.variables.delete(this.getKey(name));
        this.resolvers.delete(this.getKey(name));
        this.onDidChangeVariablesEmitter.fire();
    }
    registerArgumentPicker(variable, argPicker) {
        const key = this.getKey(variable.name);
        this.argPickers.set(key, argPicker);
        return core_1.Disposable.create(() => this.unregisterArgumentPicker(variable, argPicker));
    }
    unregisterArgumentPicker(variable, argPicker) {
        const key = this.getKey(variable.name);
        const registeredArgPicker = this.argPickers.get(key);
        if (registeredArgPicker === argPicker) {
            this.argPickers.delete(key);
        }
    }
    async getArgumentPicker(name) {
        var _a;
        return (_a = this.argPickers.get(this.getKey(name))) !== null && _a !== void 0 ? _a : undefined;
    }
    registerArgumentCompletionProvider(variable, completionProvider) {
        const key = this.getKey(variable.name);
        this.argCompletionProviders.set(key, completionProvider);
        return core_1.Disposable.create(() => this.unregisterArgumentCompletionProvider(variable, completionProvider));
    }
    unregisterArgumentCompletionProvider(variable, completionProvider) {
        const key = this.getKey(variable.name);
        const registeredCompletionProvider = this.argCompletionProviders.get(key);
        if (registeredCompletionProvider === completionProvider) {
            this.argCompletionProviders.delete(key);
        }
    }
    async getArgumentCompletionProvider(name) {
        var _a;
        return (_a = this.argCompletionProviders.get(this.getKey(name))) !== null && _a !== void 0 ? _a : undefined;
    }
    parseRequest(request) {
        const variableName = typeof request === 'string'
            ? request
            : typeof request.variable === 'string'
                ? request.variable
                : request.variable.name;
        const arg = typeof request === 'string' ? undefined : request.arg;
        return { variableName, arg };
    }
    async resolveVariable(request, context, cache = createAIResolveVariableCache()) {
        // Calculate unique variable cache key from variable name and argument
        const { variableName, arg } = this.parseRequest(request);
        const cacheKey = `${variableName}${prompt_text_1.PromptText.VARIABLE_SEPARATOR_CHAR}${arg !== null && arg !== void 0 ? arg : ''}`;
        // If the current cache key exists and is still in progress, we reached a cycle.
        // If we reach it but it has been resolved, it was part of another resolution branch and we can simply return it.
        if (cache.has(cacheKey)) {
            const existingEntry = cache.get(cacheKey);
            if (existingEntry.inProgress) {
                this.logger.warn(`Cycle detected for variable: ${variableName} with arg: ${arg}. Skipping resolution.`);
                return undefined;
            }
            return existingEntry.promise;
        }
        const entry = { promise: this.doResolve(variableName, arg, context, cache), inProgress: true };
        entry.promise.finally(() => entry.inProgress = false);
        cache.set(cacheKey, entry);
        return entry.promise;
    }
    /**
     * Asynchronously resolves a variable, handling its dependencies while preventing cyclical resolution.
     * Selects the appropriate resolver and resolution strategy based on whether nested dependency resolution is supported.
     */
    async doResolve(variableName, arg, context, cache) {
        const variable = this.getVariable(variableName);
        if (!variable) {
            return undefined;
        }
        const resolver = await this.getResolver(variableName, arg, context);
        let resolved;
        if (isResolverWithDependencies(resolver)) {
            // Explicit cast needed because Typescript does not consider the method parameter length of the type guard at compile time
            resolved = await resolver.resolve({ variable, arg }, context, async (depRequest) => this.resolveVariable(depRequest, context, cache));
        }
        else if (resolver) {
            // Explicit cast needed because Typescript does not consider the method parameter length of the type guard at compile time
            resolved = await resolver.resolve({ variable, arg }, context);
        }
        else {
            resolved = undefined;
        }
        return resolved ? { ...resolved, arg } : undefined;
    }
};
exports.DefaultAIVariableService = DefaultAIVariableService;
exports.DefaultAIVariableService = DefaultAIVariableService = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(core_1.ContributionProvider)),
    tslib_1.__param(0, (0, inversify_1.named)(exports.AIVariableContribution)),
    tslib_1.__param(1, (0, inversify_1.inject)(core_1.ILogger)),
    tslib_1.__metadata("design:paramtypes", [Object, Object])
], DefaultAIVariableService);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-core_lib_browser_ai-command-handler-factory_js-node_modules_the-45a138.js.map