/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle;

import com.github.badsyntax.gradle.GradleBuildCancellation;
import com.github.badsyntax.gradle.GradleConfig;
import com.github.badsyntax.gradle.GradleProjectConnector;
import com.github.badsyntax.gradle.exceptions.GradleBuildRunnerException;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleBuildRunner {
    private static final String JAVA_TOOL_OPTIONS_ENV = "JAVA_TOOL_OPTIONS";
    private static final Logger logger = LoggerFactory.getLogger((String)GradleBuildRunner.class.getName());
    private String projectDir;
    private List<String> args;
    private GradleConfig gradleConfig;
    private String cancellationKey;
    private Boolean colorOutput;
    private int javaDebugPort;
    private OutputStream standardOutputStream;
    private OutputStream standardErrorStream;
    private InputStream standardInputStream;
    private ProgressListener progressListener;
    private Boolean javaDebugCleanOutputCache;
    private String additionalToolOptions;

    public GradleBuildRunner(String projectDir, List<String> args, GradleConfig gradleConfig, String cancellationKey, Boolean colorOutput, int javaDebugPort, Boolean javaDebugCleanOutputCache, String additionalToolOptions) {
        this.projectDir = projectDir;
        this.args = args;
        this.gradleConfig = gradleConfig;
        this.cancellationKey = cancellationKey;
        this.colorOutput = colorOutput;
        this.javaDebugPort = javaDebugPort;
        this.javaDebugCleanOutputCache = javaDebugCleanOutputCache;
        this.additionalToolOptions = additionalToolOptions;
    }

    public GradleBuildRunner(String projectDir, List<String> args, GradleConfig gradleConfig, String cancellationKey) {
        this(projectDir, args, gradleConfig, cancellationKey, true, 0, false, "");
    }

    public GradleBuildRunner setStandardOutputStream(OutputStream standardOutputStream) {
        this.standardOutputStream = standardOutputStream;
        return this;
    }

    public GradleBuildRunner setStandardInputStream(InputStream standardInputStream) {
        this.standardInputStream = standardInputStream;
        return this;
    }

    public GradleBuildRunner setStandardErrorStream(OutputStream standardErrorStream) {
        this.standardErrorStream = standardErrorStream;
        return this;
    }

    public GradleBuildRunner setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException, GradleBuildRunnerException {
        if (Boolean.TRUE.equals(this.args.isEmpty())) {
            throw new GradleBuildRunnerException("No args supplied");
        }
        GradleConnector gradleConnector = GradleProjectConnector.build(this.projectDir, this.gradleConfig);
        try (ProjectConnection connection = gradleConnector.connect();){
            this.runBuild(connection);
        }
        finally {
            GradleBuildCancellation.clearToken(this.cancellationKey);
        }
    }

    private void runBuild(ProjectConnection connection) throws GradleBuildRunnerException, IOException {
        Map<String, String> envVars;
        HashSet<OperationType> progressEvents = new HashSet<OperationType>();
        progressEvents.add(OperationType.PROJECT_CONFIGURATION);
        progressEvents.add(OperationType.TASK);
        progressEvents.add(OperationType.TRANSFORM);
        CancellationToken cancellationToken = GradleBuildCancellation.buildToken(this.cancellationKey);
        Boolean isDebugging = this.javaDebugPort != 0;
        BuildLauncher build = (BuildLauncher)((BuildLauncher)((BuildLauncher)((BuildLauncher)((BuildLauncher)((BuildLauncher)connection.newBuild().withCancellationToken(cancellationToken)).addProgressListener(this.progressListener, progressEvents)).setStandardOutput(this.standardOutputStream)).setStandardError(this.standardErrorStream)).setColorOutput(this.colorOutput.booleanValue())).withArguments(this.buildArguments(isDebugging));
        if (this.standardInputStream != null) {
            build.setStandardInput(this.standardInputStream);
        }
        if ((envVars = GradleBuildRunner.buildJavaEnvVarsWithToolOptions(Boolean.TRUE.equals(isDebugging), this.javaDebugPort, this.additionalToolOptions)) != null) {
            build.setEnvironmentVariables(envVars);
        }
        if (!Strings.isNullOrEmpty((String)this.gradleConfig.getJvmArguments())) {
            build.setJvmArguments(new String[]{this.gradleConfig.getJvmArguments()});
        }
        if (!Strings.isNullOrEmpty((String)this.gradleConfig.getJavaHome())) {
            build.setJavaHome(new File(this.gradleConfig.getJavaHome()));
        }
        build.run();
    }

    private List<String> buildArguments(Boolean isDebugging) throws GradleBuildRunnerException {
        if (Boolean.FALSE.equals(isDebugging) || Boolean.FALSE.equals(this.javaDebugCleanOutputCache)) {
            return this.args;
        }
        int taskIndex = -1;
        for (int i = 0; i < this.args.size(); ++i) {
            if (!GradleBuildRunner.isTask(this.args.get(i))) continue;
            if (taskIndex == -1) {
                taskIndex = i;
                continue;
            }
            throw new GradleBuildRunnerException("Unexpected multiple tasks when debugging");
        }
        if (taskIndex == -1) {
            throw new GradleBuildRunnerException("No task found when debugging");
        }
        LinkedList<String> parts = new LinkedList<String>(Arrays.asList(this.args.get(taskIndex).split(":")));
        String taskName = (String)parts.get(parts.size() - 1);
        parts.remove(parts.size() - 1);
        String capitalizedTaskName = taskName.substring(0, 1).toUpperCase() + taskName.substring(1);
        parts.add("clean" + capitalizedTaskName);
        String cleanTaskName = String.join((CharSequence)":", parts);
        ArrayList<String> newArgs = new ArrayList<String>(this.args);
        newArgs.add(taskIndex, cleanTaskName);
        logger.warn("Adding {} to ensure task output is cleared before debugging", (Object)cleanTaskName);
        return newArgs;
    }

    private static boolean isTask(String argument) {
        return !argument.startsWith("-");
    }

    private static Map<String, String> buildJavaEnvVarsWithToolOptions(boolean isDebugging, int javaDebugPort, String additionalToolOptions) {
        if (!isDebugging && (additionalToolOptions == null || additionalToolOptions.isEmpty())) {
            return null;
        }
        HashMap<String, String> envVars = new HashMap<String, String>(System.getenv());
        StringBuilder toolOptions = new StringBuilder();
        if (isDebugging) {
            toolOptions.append(String.format("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=localhost:%d", javaDebugPort));
        }
        if (additionalToolOptions != null && !additionalToolOptions.isEmpty()) {
            if (!toolOptions.isEmpty()) {
                toolOptions.append(' ');
            }
            toolOptions.append(additionalToolOptions);
        }
        envVars.put(JAVA_TOOL_OPTIONS_ENV, toolOptions.toString());
        return envVars;
    }
}

