/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.params.ParameterizedTestMethodContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestNameFormatter {
    private final PartialFormatter[] partialFormatters;

    ParameterizedTestNameFormatter(String pattern, String displayName, ParameterizedTestMethodContext methodContext, int argumentMaxLength) {
        try {
            this.partialFormatters = this.parse(pattern, displayName, methodContext, argumentMaxLength);
        }
        catch (Exception ex) {
            String message = "The display name pattern defined for the parameterized test is invalid. See nested exception for further details.";
            throw new JUnitException(message, (Throwable)ex);
        }
    }

    String format(int invocationIndex, Arguments arguments, Object[] consumedArguments) {
        try {
            return this.formatSafely(invocationIndex, arguments, consumedArguments);
        }
        catch (Exception ex) {
            String message = "Failed to format display name for parameterized test. See nested exception for further details.";
            throw new JUnitException(message, (Throwable)ex);
        }
    }

    private String formatSafely(int invocationIndex, Arguments arguments, Object[] consumedArguments) {
        ArgumentsContext context = new ArgumentsContext(invocationIndex, arguments, this.extractNamedArguments(consumedArguments));
        StringBuffer result = new StringBuffer();
        for (PartialFormatter partialFormatter : this.partialFormatters) {
            partialFormatter.append(context, result);
        }
        return result.toString();
    }

    private Object[] extractNamedArguments(Object[] arguments) {
        return Arrays.stream(arguments).map(argument -> argument instanceof Named ? ((Named)argument).getName() : argument).toArray();
    }

    private PartialFormatter[] parse(String pattern, String displayName, ParameterizedTestMethodContext methodContext, int argumentMaxLength) {
        ArrayList<PartialFormatter> result = new ArrayList<PartialFormatter>();
        PartialFormatters formatters = this.createPartialFormatters(displayName, methodContext, argumentMaxLength);
        String unparsedSegment = pattern;
        while (StringUtils.isNotBlank((String)unparsedSegment)) {
            PlaceholderPosition position = ParameterizedTestNameFormatter.findFirstPlaceholder(formatters, unparsedSegment);
            if (position == null) {
                result.add(ParameterizedTestNameFormatter.determineNonPlaceholderFormatter(unparsedSegment, argumentMaxLength));
                break;
            }
            if (position.index > 0) {
                String before = unparsedSegment.substring(0, position.index);
                result.add(ParameterizedTestNameFormatter.determineNonPlaceholderFormatter(before, argumentMaxLength));
            }
            result.add(formatters.get(position.placeholder));
            unparsedSegment = unparsedSegment.substring(position.index + position.placeholder.length());
        }
        return result.toArray(new PartialFormatter[0]);
    }

    private static PlaceholderPosition findFirstPlaceholder(PartialFormatters formatters, String segment) {
        if (segment.length() < formatters.minimumPlaceholderLength) {
            return null;
        }
        PlaceholderPosition minimum = null;
        for (String placeholder : formatters.placeholders()) {
            int index = segment.indexOf(placeholder);
            if (index < 0) continue;
            if (index < formatters.minimumPlaceholderLength) {
                return new PlaceholderPosition(index, placeholder);
            }
            if (minimum != null && index >= minimum.index) continue;
            minimum = new PlaceholderPosition(index, placeholder);
        }
        return minimum;
    }

    private static PartialFormatter determineNonPlaceholderFormatter(String segment, int argumentMaxLength) {
        return segment.contains("{") ? new MessageFormatPartialFormatter(segment, argumentMaxLength) : (context, result) -> result.append(segment);
    }

    private PartialFormatters createPartialFormatters(String displayName, ParameterizedTestMethodContext methodContext, int argumentMaxLength) {
        CachingByArgumentsLengthPartialFormatter argumentsWithNamesFormatter = new CachingByArgumentsLengthPartialFormatter(length -> new MessageFormatPartialFormatter(ParameterizedTestNameFormatter.argumentsWithNamesPattern(length, methodContext), argumentMaxLength));
        PartialFormatters formatters = new PartialFormatters();
        formatters.put("{index}", PartialFormatter.INDEX);
        formatters.put("{displayName}", (context, result) -> result.append(displayName));
        formatters.put("{argumentSetName}", PartialFormatter.ARGUMENT_SET_NAME);
        formatters.put("{argumentsWithNames}", argumentsWithNamesFormatter);
        formatters.put("{arguments}", new CachingByArgumentsLengthPartialFormatter(length -> new MessageFormatPartialFormatter(ParameterizedTestNameFormatter.argumentsPattern(length), argumentMaxLength)));
        formatters.put("{argumentSetNameOrArgumentsWithNames}", (context, result) -> {
            PartialFormatter formatterToUse = context.arguments instanceof Arguments.ArgumentSet ? PartialFormatter.ARGUMENT_SET_NAME : argumentsWithNamesFormatter;
            formatterToUse.append(context, result);
        });
        return formatters;
    }

    private static String argumentsWithNamesPattern(int length, ParameterizedTestMethodContext methodContext) {
        return IntStream.range(0, length).mapToObj(index -> methodContext.getParameterName(index).map(name -> name + "=").orElse("") + "{" + index + "}").collect(Collectors.joining(", "));
    }

    private static String argumentsPattern(int length) {
        return IntStream.range(0, length).mapToObj(index -> "{" + index + "}").collect(Collectors.joining(", "));
    }

    @FunctionalInterface
    private static interface PartialFormatter {
        public static final PartialFormatter INDEX = (context, result) -> result.append(context.invocationIndex);
        public static final PartialFormatter ARGUMENT_SET_NAME = (context, result) -> {
            if (!(context.arguments instanceof Arguments.ArgumentSet)) {
                throw new ExtensionConfigurationException(String.format("When the display name pattern for a @ParameterizedTest contains %s, the arguments must be supplied as an ArgumentSet.", "{argumentSetName}"));
            }
            result.append(((Arguments.ArgumentSet)context.arguments).getName());
        };

        public void append(ArgumentsContext var1, StringBuffer var2);
    }

    private static class ArgumentsContext {
        private final int invocationIndex;
        private final Arguments arguments;
        private final Object[] consumedArguments;

        ArgumentsContext(int invocationIndex, Arguments arguments, Object[] consumedArguments) {
            this.invocationIndex = invocationIndex;
            this.arguments = arguments;
            this.consumedArguments = consumedArguments;
        }
    }

    private static class PartialFormatters {
        private final Map<String, PartialFormatter> formattersByPlaceholder = new LinkedHashMap<String, PartialFormatter>();
        private int minimumPlaceholderLength = Integer.MAX_VALUE;

        private PartialFormatters() {
        }

        void put(String placeholder, PartialFormatter formatter) {
            this.formattersByPlaceholder.put(placeholder, formatter);
            int newPlaceholderLength = placeholder.length();
            if (newPlaceholderLength < this.minimumPlaceholderLength) {
                this.minimumPlaceholderLength = newPlaceholderLength;
            }
        }

        PartialFormatter get(String placeholder) {
            return this.formattersByPlaceholder.get(placeholder);
        }

        Set<String> placeholders() {
            return this.formattersByPlaceholder.keySet();
        }
    }

    private static class PlaceholderPosition {
        final int index;
        final String placeholder;

        PlaceholderPosition(int index, String placeholder) {
            this.index = index;
            this.placeholder = placeholder;
        }
    }

    private static class MessageFormatPartialFormatter
    implements PartialFormatter {
        private static final char ELLIPSIS = '\u2026';
        private final MessageFormat messageFormat;
        private final int argumentMaxLength;

        MessageFormatPartialFormatter(String pattern, int argumentMaxLength) {
            this.messageFormat = new MessageFormat(pattern);
            this.argumentMaxLength = argumentMaxLength;
        }

        @Override
        public synchronized void append(ArgumentsContext context, StringBuffer result) {
            this.messageFormat.format(this.makeReadable(context.consumedArguments), result, new FieldPosition(0));
        }

        private Object[] makeReadable(Object[] arguments) {
            Format[] formats = this.messageFormat.getFormatsByArgumentIndex();
            Object[] result = Arrays.copyOf(arguments, Math.min(arguments.length, formats.length), Object[].class);
            for (int i = 0; i < result.length; ++i) {
                if (formats[i] != null) continue;
                result[i] = this.truncateIfExceedsMaxLength(StringUtils.nullSafeToString((Object)arguments[i]));
            }
            return result;
        }

        private String truncateIfExceedsMaxLength(String argument) {
            if (argument != null && argument.length() > this.argumentMaxLength) {
                return argument.substring(0, this.argumentMaxLength - 1) + '\u2026';
            }
            return argument;
        }
    }

    private static class CachingByArgumentsLengthPartialFormatter
    implements PartialFormatter {
        private final ConcurrentMap<Integer, PartialFormatter> cache = new ConcurrentHashMap<Integer, PartialFormatter>(1);
        private final Function<Integer, PartialFormatter> factory;

        CachingByArgumentsLengthPartialFormatter(Function<Integer, PartialFormatter> factory) {
            this.factory = factory;
        }

        @Override
        public void append(ArgumentsContext context, StringBuffer result) {
            this.cache.computeIfAbsent(context.consumedArguments.length, this.factory).append(context, result);
        }
    }
}

