/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.applications;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;

public class ClearAllProjects
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        IProject[] projects;
        Platform.getBundle((String)"org.eclipse.titan.designer").start();
        String[] projectFiles = (String[])context.getArguments().get("application.args");
        if (projectFiles != null && projectFiles.length != 0) {
            System.out.println("This application does not have parameters.");
            System.out.println("number of parameters: " + projectFiles.length);
            try {
                ResourcesPlugin.getWorkspace().save(true, null);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)"Error while closing workspace", (Throwable)e);
            }
            return -1;
        }
        if (Activator.getDefault() != null) {
            Activator.getDefault().pauseHandlingResourceChanges();
        }
        boolean result = true;
        for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            try {
                project.close(null);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("Error while deleting project " + project.getName()), (Throwable)e);
                result = false;
            }
        }
        for (IProject project : projects) {
            try {
                if (project.isLinked()) {
                    project.delete(false, false, null);
                    continue;
                }
                project.delete(true, true, null);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("Error while deleting project " + project.getName()), (Throwable)e);
                result = false;
            }
        }
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while closing workspace", (Throwable)e);
            result = false;
        }
        if (result) {
            return EXIT_OK;
        }
        return -1;
    }

    public void stop() {
    }
}

