/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers.cfg;

import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.IntervalDetector;
import org.eclipse.titan.common.parsers.cfg.CfgInterval;

public final class CfgIntervalDetector
extends IntervalDetector {
    @Override
    public void initRootInterval(int length) {
        this.rootInterval = this.actualInterval = new CfgInterval(null, Interval.interval_type.NORMAL, CfgInterval.section_type.UNKNOWN);
        this.actualInterval.setStartOffset(0);
        this.actualInterval.setStartLine(0);
        this.actualInterval.setEndOffset(length);
        this.setMaxLength(length);
    }

    public void pushInterval(int offset, int line, Interval.interval_type type, CfgInterval.section_type sectionType) {
        CfgInterval tempInterval = new CfgInterval(this.actualInterval, type, sectionType);
        this.actualInterval = tempInterval;
        if (this.rootInterval == null) {
            this.rootInterval = tempInterval;
        }
        tempInterval.setStartOffset(offset);
        tempInterval.setStartLine(line);
    }

    @Override
    public final void handleFinalCorrection() {
        if (this.rootInterval == null) {
            return;
        }
        while (this.actualInterval != null && !this.actualInterval.equals(this.rootInterval)) {
            if (!(this.actualInterval instanceof CfgInterval) || CfgInterval.section_type.UNKNOWN.equals((Object)((CfgInterval)this.actualInterval).getSectionType())) {
                this.actualInterval.setErroneous();
            }
            this.popInterval(this.getMaxLength() - 1, -1);
        }
    }
}

