/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Boolean_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class If_Clause
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String BOOLEANEXPECTED = "A value or expression of type boolean was expected";
    private static final String FULLNAMEPART1 = ".expr";
    private static final String FULLNAMEPART2 = ".block";
    private final Value expression;
    private final StatementBlock statementblock;
    private Location location = NULL_Location.INSTANCE;

    public If_Clause(Value expression, StatementBlock statementblock) {
        this.expression = expression;
        this.statementblock = statementblock;
        if (expression != null) {
            expression.setFullNameParent(this);
        }
        if (statementblock != null) {
            statementblock.setFullNameParent(this);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.expression == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.statementblock == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.expression != null) {
            this.expression.setMyScope(scope);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.expression != null) {
            this.expression.setCodeSection(codeSection);
        }
        if (this.statementblock != null) {
            this.statementblock.setCodeSection(codeSection);
        }
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        if (this.statementblock != null) {
            this.statementblock.setMyStatementBlock(statementBlock, index);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setMyDefinition(Definition definition) {
        if (this.statementblock != null) {
            this.statementblock.setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        if (this.statementblock != null) {
            this.statementblock.setMyAltguards(altGuards);
        }
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.statementblock != null) {
            return this.statementblock.hasReturn(timestamp);
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    public boolean hasReceivingStatement() {
        if (this.statementblock != null) {
            return this.statementblock.hasReceivingStatement(0);
        }
        return false;
    }

    public boolean check(CompilationTimeStamp timestamp, boolean unreachable) {
        boolean unreachable2 = unreachable;
        if (this.expression != null) {
            IValue last = this.expression.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            IType.Type_type temporalType = last.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (!last.getIsErroneous(timestamp) && !IType.Type_type.TYPE_UNDEFINED.equals((Object)temporalType)) {
                if (!IType.Type_type.TYPE_BOOL.equals((Object)temporalType)) {
                    last.getLocation().reportSemanticError(BOOLEANEXPECTED);
                    this.expression.setIsErroneous(true);
                } else if (!this.expression.isUnfoldable(timestamp) && ((Boolean_Value)last).getValue()) {
                    unreachable2 = true;
                }
                if (this.expression.getMyGovernor() == null) {
                    this.expression.setMyGovernor(new Boolean_Type());
                }
            }
        }
        if (this.statementblock != null) {
            this.statementblock.check(timestamp);
        }
        return unreachable2;
    }

    public void checkAllowedInterleave() {
        if (this.statementblock != null) {
            this.statementblock.checkAllowedInterleave();
        }
    }

    public void postCheck() {
        if (this.statementblock != null) {
            this.statementblock.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.expression != null) {
            this.expression.updateSyntax(reparser, false);
            reparser.updateLocation(this.expression.getLocation());
        }
        if (this.statementblock != null) {
            this.statementblock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementblock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.expression != null) {
            this.expression.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementblock != null) {
            this.statementblock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    public boolean isNegatedCondition() {
        return this.expression != null && IValue.Value_type.EXPRESSION_VALUE.equals((Object)this.expression.getValuetype()) && Expression_Value.Operation_type.NOT_OPERATION.equals((Object)((Expression_Value)this.expression).getOperationType());
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.expression != null && !this.expression.accept(v)) {
            return false;
        }
        return this.statementblock == null || this.statementblock.accept(v);
    }

    public Value getExpression() {
        return this.expression;
    }

    public StatementBlock getStatementBlock() {
        return this.statementblock;
    }

    public void generateCode(JavaGenData aData, StringBuilder source, AtomicInteger blockCount, AtomicBoolean unReachable, AtomicBoolean eachFalse) {
        if (unReachable.get()) {
            return;
        }
        if (!this.expression.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
            IValue last = this.expression.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            if (((Boolean_Value)last).getValue()) {
                unReachable.set(true);
            } else {
                return;
            }
        }
        if (!eachFalse.get()) {
            source.append("else ");
        }
        if (!unReachable.get()) {
            if (!eachFalse.get()) {
                source.append("{\n");
                blockCount.incrementAndGet();
            }
            if (this.expression.returnsNative()) {
                this.expression.generateCodeTmp(aData, source, "if (", blockCount);
                source.append(')');
            } else {
                aData.addBuiltinTypeImport("TitanBoolean");
                this.expression.generateCodeTmp(aData, source, "if (TitanBoolean.get_native(", blockCount);
                source.append(") )");
            }
        }
        eachFalse.set(false);
        source.append("{\n");
        this.statementblock.generateCode(aData, source);
        source.append("}\n");
    }
}

