/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.IndexedTemplate;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class IndexedTemplates
extends ASTNode
implements IIncrementallyUpdateable {
    private final ArrayList<IndexedTemplate> indexed_templates = new ArrayList();

    public void addTemplate(IndexedTemplate template) {
        this.indexed_templates.add(template);
        template.setFullNameParent(this);
    }

    public int getNofTemplates() {
        return this.indexed_templates.size();
    }

    public IndexedTemplate getTemplateByIndex(int index) {
        return this.indexed_templates.get(index);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.indexed_templates.trimToSize();
        for (IndexedTemplate template : this.indexed_templates) {
            template.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (IndexedTemplate template : this.indexed_templates) {
            if (template != child) continue;
            Value index = template.getIndex().getValue();
            return builder.append("[").append(index.createStringRepresentation()).append("]");
        }
        return builder;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (IndexedTemplate template : this.indexed_templates) {
            template.updateSyntax(reparser, false);
            reparser.updateLocation(template.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.indexed_templates == null) {
            return;
        }
        for (IndexedTemplate indexedTemp : this.indexed_templates) {
            indexedTemp.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.indexed_templates != null) {
            for (IndexedTemplate it : this.indexed_templates) {
                if (it.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

