/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class NamedParameter
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private final Identifier name;
    private final TemplateInstance instance;
    private Location location;

    public NamedParameter(Identifier name, TemplateInstance instance) {
        this.name = name;
        this.instance = instance;
        this.location = NULL_Location.INSTANCE;
        if (instance != null) {
            instance.setFullNameParent(this);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.instance != null) {
            this.instance.setMyScope(scope);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public Identifier getName() {
        return this.name;
    }

    public String createStringRepresentation() {
        if (this.name == null || this.instance == null) {
            return "<unknown named parameter>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.name.getName());
        sb.append(" := ");
        sb.append(this.instance.createStringRepresentation());
        return sb.toString();
    }

    public TemplateInstance getInstance() {
        return this.instance;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.name.getLocation());
        if (this.instance != null) {
            this.instance.updateSyntax(reparser, false);
            reparser.updateLocation(this.instance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.instance != null) {
            this.instance.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.name != null && !this.name.accept(v)) {
            return false;
        }
        return this.instance == null || this.instance.accept(v);
    }
}

