/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Default_Type
extends Type {
    private static final String DEFAULTVALUEEXPECTED = "Default value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `default''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `default''";

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_DEFAULT;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_DEFAULT.equals((Object)temp.getTypetype());
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return "default";
    }

    @Override
    public String getOutlineIcon() {
        return "default.gif";
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        return true;
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        this.location.reportSemanticError(MessageFormat.format("Default type cannot be {0}", operation));
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case TTCN3_NULL_VALUE: {
                value.setValuetype(timestamp, IValue.Value_type.DEFAULT_NULL_VALUE);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(DEFAULTVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public void checkEmbedded(CompilationTimeStamp timestamp, Location errorLocation, boolean defaultAllowed, String errorMessage) {
        if (!defaultAllowed) {
            errorLocation.reportSemanticError(MessageFormat.format("Default type `{0}'' cannot be {1}", this.getTypename(), errorMessage));
        }
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
        return false;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        errorLocation.reportSemanticError("The `map'/`unmap' parameters of a port type cannot be or contain a field/element of default type");
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("default");
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        if (this.needsAlias()) {
            String ownName = this.getGenNameOwn();
            source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{'\n", ownName, this.getGenNameValue(aData, source)));
            StringBuilder descriptor = new StringBuilder();
            this.generateCodeTypedescriptor(aData, source, descriptor, null);
            this.generateCodeDefaultCoding(aData, source, descriptor);
            this.generateCodeForCodingHandlers(aData, source, descriptor);
            source.append((CharSequence)descriptor);
            source.append("\t}\n");
            source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, this.getGenNameTemplate(aData, source)));
        } else if (this.getParentType() == null || !this.getParentType().generatesOwnClass(aData, source)) {
            this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
            this.generateCodeDefaultCoding(aData, source, null);
            this.generateCodeForCodingHandlers(aData, source, null);
        }
        if (this.hasDoneAttribute()) {
            this.generateCodeDone(aData, source);
        }
        if (this.subType != null) {
            this.subType.generateCode(aData, source);
        }
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanDefault");
        return "TitanDefault";
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanDefault_template");
        return "TitanDefault_template";
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute != null || this.jsonAttribute != null || this.hasVariantAttributes(CompilationTimeStamp.getBaseTimestamp()) || this.hasEncodeAttribute("JSON")) {
            if (this.needsAlias()) {
                String baseName = this.getGenNameOwn(aData);
                return baseName + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this.needsAlias()) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        aData.addBuiltinTypeImport("TitanDefault");
        return "TitanDefault.TitanDefault";
    }
}

