/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.Verdict_Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Verdict_Value
extends Value {
    private final Verdict_type value;

    public Verdict_Value(Verdict_type value) {
        this.value = value;
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.VERDICT_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        switch (this.value) {
            case NONE: {
                return "none";
            }
            case PASS: {
                return "pass";
            }
            case INCONC: {
                return "inconc";
            }
            case FAIL: {
                return "fail";
            }
            case ERROR: {
                return "ERROR";
            }
        }
        return "unknown verdict value";
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_VERDICT;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        return new Verdict_Type();
    }

    public Verdict_type getValue() {
        return this.value;
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return IValue.Value_type.VERDICT_VALUE.equals((Object)last.getValuetype()) && this.value.equals((Object)((Verdict_Value)last).getValue());
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        aData.addBuiltinTypeImport("TitanVerdictType.VerdictTypeEnum");
        StringBuilder result = new StringBuilder();
        switch (this.value) {
            case NONE: {
                result.append("VerdictTypeEnum.NONE");
                break;
            }
            case PASS: {
                result.append("VerdictTypeEnum.PASS");
                break;
            }
            case INCONC: {
                result.append("VerdictTypeEnum.INCONC");
                break;
            }
            case FAIL: {
                result.append("VerdictTypeEnum.FAIL");
                break;
            }
            case ERROR: {
                result.append("VerdictTypeEnum.ERROR");
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for value `" + this.getFullName() + "''"));
                result.append("FATAL ERROR: unknown verdict value");
            }
        }
        return result;
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        source.append(MessageFormat.format("{0}.operator_assign({1});\n", name, this.generateSingleExpression(aData)));
        this.lastTimeGenerated = aData.getBuildTimstamp();
        return source;
    }

    public static enum Verdict_type {
        NONE,
        PASS,
        INCONC,
        FAIL,
        ERROR;

    }
}

