/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.GeneralConstants;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.core.CompilerVersionInformationCollector;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.core.TITANJob;
import org.eclipse.titan.designer.decorators.TITANDecorator;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.properties.data.BuildLocation;
import org.eclipse.titan.designer.properties.data.ProjectRemoteBuildPropertyData;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public final class RemoteBuilder
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        this.doRemoteBuilde();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doRemoteBuilde();
        return null;
    }

    private void doRemoteBuilde() {
        if (!LicenseValidator.check()) {
            return;
        }
        IWorkbenchPage iwPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.selection = iwPage.getSelection();
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)this.selection;
            for (Object selected : structSelection.toList()) {
                if (!(selected instanceof IProject) || !TITANBuilder.isBuilderEnabled((IProject)selected)) continue;
                IProject tempProject = (IProject)selected;
                BuildLocation[] locations = ProjectRemoteBuildPropertyData.getBuildLocations(tempProject);
                String parallelExecutionRequested = "false";
                try {
                    parallelExecutionRequested = tempProject.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.parallelCommandExecution"));
                }
                catch (CoreException ce) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
                    parallelExecutionRequested = "false";
                }
                ArrayList<String> hostNames = new ArrayList<String>();
                ArrayList<String> commands = new ArrayList<String>();
                ArrayList<String> descriptions = new ArrayList<String>();
                for (BuildLocation location : locations) {
                    if (!location.getActive()) continue;
                    hostNames.add(location.getName());
                    commands.add(location.getCommand());
                    descriptions.add("Building remotely on host: " + location.getName());
                }
                MarkerHandler.markAllMarkersForRemoval((IResource)tempProject);
                if ("true".equals(parallelExecutionRequested)) {
                    for (int i = 0; i < commands.size(); ++i) {
                        RemoteBuilderJob job = new RemoteBuilderJob("Build remotely", tempProject, (String)hostNames.get(i), (String)commands.get(i), (String)descriptions.get(i));
                        job.setPriority(30);
                        job.setUser(true);
                        job.setProperty(IProgressConstants.ICON_PROPERTY, ImageCache.getImageDescriptor("titan.gif"));
                        job.schedule();
                    }
                    continue;
                }
                RemoteBuilderJob job = new RemoteBuilderJob("Build remotely", tempProject, hostNames, commands, descriptions);
                job.setPriority(30);
                job.setUser(true);
                job.setRule((ISchedulingRule)tempProject);
                job.setProperty(IProgressConstants.ICON_PROPERTY, ImageCache.getImageDescriptor("titan.gif"));
                job.schedule();
            }
        }
    }

    private static final class RemoteBuilderJob
    extends Job {
        static final String TTCN3_LICENSE_FILE = "TTCN3_LICENSE_FILE";
        static final String TTCN3_DIR = "TTCN3_DIR";
        private final IProject project;
        private final List<String> hostnames;
        private final List<String> commands;
        private final List<String> descriptions;
        private final JobChangeAdapter decoratorUpdater = new JobChangeAdapter(this){
            final /* synthetic */ RemoteBuilderJob this$0;
            {
                this.this$0 = this$0;
            }

            public void done(IJobChangeEvent event) {
                try {
                    if (event.getResult().isOK()) {
                        this.this$0.project.setSessionProperty(GeneralConstants.PROJECT_UP_TO_DATE, (Object)true);
                    } else {
                        this.this$0.project.setSessionProperty(GeneralConstants.PROJECT_UP_TO_DATE, (Object)false);
                    }
                    TITANDecorator.refreshSelectively((IResource)this.this$0.project);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
        };

        public RemoteBuilderJob(String name, IProject project, String hostName, String command, String description) {
            super(name);
            this.project = project;
            this.hostnames = new ArrayList<String>();
            this.hostnames.add(hostName);
            this.commands = new ArrayList<String>();
            this.commands.add(command);
            this.descriptions = new ArrayList<String>();
            this.descriptions.add(description);
            this.addJobChangeListener((IJobChangeListener)this.decoratorUpdater);
        }

        public RemoteBuilderJob(String name, IProject project, List<String> hostnames, List<String> commands, List<String> descriptions) {
            super(name);
            this.project = project;
            this.hostnames = hostnames;
            this.commands = commands;
            this.descriptions = descriptions;
            this.addJobChangeListener((IJobChangeListener)this.decoratorUpdater);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IProgressMonitor internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
            internalMonitor.beginTask(this.getName(), this.commands.size());
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            Map<String, String> env = pb.environment();
            env.put(TTCN3_LICENSE_FILE, LicenseValidator.getResolvedLicenseFilePath(false));
            env.put(TTCN3_DIR, CompilerVersionInformationCollector.getResolvedInstallationPath(false));
            pb.redirectErrorStream(true);
            Process proc = null;
            for (int i = 0; i < this.commands.size(); ++i) {
                block42: {
                    String actualCommand = this.commands.get(i);
                    this.setName(this.descriptions.get(i));
                    internalMonitor.subTask("on " + this.hostnames.get(i));
                    ArrayList<String> finalCommand = new ArrayList<String>();
                    finalCommand.add("sh");
                    finalCommand.add("-c");
                    finalCommand.add(actualCommand);
                    StringBuilder builder = new StringBuilder();
                    for (String c : finalCommand) {
                        builder.append(c + ' ');
                    }
                    TITANConsole.println(builder.toString());
                    pb.command(finalCommand);
                    try {
                        proc = pb.start();
                    }
                    catch (IOException e) {
                        TITANConsole.println("execution failed");
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                        TITANJob.reportExecutionProblem(this.project, Platform.getPreferencesService(), this.getName(), finalCommand, null, false);
                        internalMonitor.done();
                        MarkerHandler.removeAllMarkedMarkers((IResource)this.project);
                        return Status.CANCEL_STATUS;
                    }
                    BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    BufferedReader stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    try {
                        String line = stdout.readLine();
                        while (line != null) {
                            if (internalMonitor.isCanceled()) {
                                internalMonitor.done();
                                MarkerHandler.removeAllMarkedMarkers((IResource)this.project);
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            TITANConsole.println(this.hostnames.get(i) + ": " + line);
                            line = stdout.readLine();
                        }
                        int exitval = proc.waitFor();
                        if (exitval == 0) {
                            TITANConsole.println("The process on " + this.hostnames.get(i) + " finished without indicating an error.");
                            break block42;
                        }
                        TITANConsole.println(this.hostnames.get(i) + " finished with return value: " + exitval);
                        if (stderr.ready()) {
                            StringBuilder builder2 = new StringBuilder();
                            line = stdout.readLine();
                            while (line != null) {
                                builder2.append(line);
                                line = stdout.readLine();
                            }
                            TITANJob.reportExecutionProblem(this.project, Platform.getPreferencesService(), this.getName(), finalCommand, builder2.toString(), false);
                        } else {
                            TITANJob.reportExecutionProblem(this.project, Platform.getPreferencesService(), this.getName(), finalCommand, null, false);
                        }
                        internalMonitor.done();
                        MarkerHandler.removeAllMarkedMarkers((IResource)this.project);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (IOException e) {
                        TITANConsole.println("execution failed");
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                    }
                    catch (InterruptedException e) {
                        TITANConsole.println("execution failed because of interruption");
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                    }
                    finally {
                        try {
                            stdout.close();
                        }
                        catch (IOException e) {
                            ErrorReporter.logExceptionStackTrace((Exception)e);
                        }
                        try {
                            stderr.close();
                        }
                        catch (IOException e) {
                            ErrorReporter.logExceptionStackTrace((Exception)e);
                        }
                    }
                }
                internalMonitor.worked(1);
            }
            internalMonitor.done();
            MarkerHandler.removeAllMarkedMarkers((IResource)this.project);
            return Status.OK_STATUS;
        }
    }
}

