/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.viewers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.BackReferenceProvider;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.BackReferenceResolver;
import org.eclipse.ui.PlatformUI;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYAnnotationBoundsInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.panel.AbstractOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.util.Args;
import org.jfree.data.Range;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class ChartPanelSelectionHandler {
    private final MouseSelectionListener mouseSelectionListener = new MouseSelectionListener();
    private final SelectionOverlay selectionOverlay = new SelectionOverlay();
    private final ChartPanel chartPanel;
    private final ISelectionProvider selectionProvider;
    private BackReferenceResolver backReferenceResolver = BackReferenceResolver.DEFAULT;
    private double zoomToSelectionMargin = 0.0;
    private SelectionType selectionType;

    public static ChartPanelSelectionHandler connectSelection(ChartPanel chartPanel, ISelectionProvider selectionProvider, SelectionType selectionType) {
        return new ChartPanelSelectionHandler(chartPanel, selectionProvider, selectionType);
    }

    public ChartPanelSelectionHandler(ChartPanel chartPanel, ISelectionProvider selectionProvider, SelectionType selectionType) {
        Args.nullNotPermitted((Object)chartPanel, (String)"chartPanel");
        Args.nullNotPermitted((Object)selectionProvider, (String)"selectionProvider");
        this.chartPanel = chartPanel;
        this.selectionProvider = selectionProvider;
        this.setSelectionType(selectionType);
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(SelectionType selectionType) {
        Args.nullNotPermitted((Object)((Object)selectionType), (String)"selectionType");
        this.chartPanel.removeOverlay((Overlay)this.selectionOverlay);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.selectionOverlay);
        this.chartPanel.removeChartMouseListener((ChartMouseListener)this.mouseSelectionListener);
        this.selectionType = selectionType;
        switch (selectionType) {
            case Single: 
            case Multi: {
                this.chartPanel.addChartMouseListener((ChartMouseListener)this.mouseSelectionListener);
            }
            case ReadOnly: {
                this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.selectionOverlay);
                this.chartPanel.addOverlay((Overlay)this.selectionOverlay);
            }
        }
    }

    public Paint getSelectionPaint() {
        return this.selectionOverlay.selectionPaint;
    }

    public void setSelectionPaint(Paint selectionPaint) {
        this.selectionOverlay.selectionPaint = selectionPaint;
    }

    public Stroke getSelectionStroke() {
        return this.selectionOverlay.selectionStroke;
    }

    public void setSelectionStroke(Stroke selectionStroke) {
        this.selectionOverlay.selectionStroke = selectionStroke;
    }

    public double getZoomToSelectionMargin() {
        return this.zoomToSelectionMargin;
    }

    public void setZoomToSelectionMargin(double zoomToSelectionMargin) {
        this.zoomToSelectionMargin = zoomToSelectionMargin;
    }

    public BackReferenceResolver getBackReferenceResolver() {
        return this.backReferenceResolver;
    }

    public void setBackReferenceResolver(BackReferenceResolver backReferenceResolver) {
        this.backReferenceResolver = backReferenceResolver;
    }

    public void zoomToSelection() {
        this.zoomToSelection(Axis.BOTH);
    }

    public void zoomToSelection(Axis zoomType) {
        Map<Object, Rectangle2D> selectionBounds = this.getSelectionBounds();
        if (selectionBounds.isEmpty()) {
            return;
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Rectangle2D bounds : selectionBounds.values()) {
            minX = Math.min(minX, bounds.getMinX());
            minY = Math.min(minY, bounds.getMinY());
            maxX = Math.max(maxX, bounds.getMaxX());
            maxY = Math.max(maxY, bounds.getMaxY());
        }
        double marginX = this.zoomToSelectionMargin * (maxX - minX);
        double marginY = this.zoomToSelectionMargin * (maxY - minY);
        minX -= marginX;
        minY -= marginY;
        maxX += marginX;
        maxY += marginY;
        Rectangle2D dataArea = this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        switch (zoomType) {
            case X: {
                minY = dataArea.getMinY();
                maxY = dataArea.getMaxY();
                break;
            }
            case Y: {
                minX = dataArea.getMinX();
                maxX = dataArea.getMaxX();
                break;
            }
        }
        double width = Math.max(maxX - minX, Double.MIN_VALUE);
        double height = Math.max(maxY - minY, Double.MIN_VALUE);
        this.chartPanel.zoom((Rectangle2D)new Rectangle2D.Double(minX, minY, width, height));
    }

    protected Map<Object, Rectangle2D> getSelectionBounds() {
        ISelection selection = this.selectionProvider.getSelection();
        Plot plot = this.chartPanel.getChart().getPlot();
        if (!(plot instanceof XYPlot) || !(selection instanceof StructuredSelection) || selection.isEmpty()) {
            return Collections.emptyMap();
        }
        List selectionItems = ((StructuredSelection)selection).toList();
        XYPlot xyPlot = (XYPlot)plot;
        Rectangle2D dataArea = this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        HashMap<Object, Rectangle2D> selectionBounds = new HashMap<Object, Rectangle2D>(selectionItems.size());
        int d = 0;
        while (d < xyPlot.getDatasetCount()) {
            XYDataset ds = xyPlot.getDataset(d);
            if (ds instanceof IntervalXYDataset) {
                IntervalXYDataset dataset = (IntervalXYDataset)ds;
                ValueAxis domainAxis = xyPlot.getDomainAxisForDataset(d);
                ValueAxis rangeAxis = xyPlot.getRangeAxisForDataset(d);
                XYItemRenderer renderer = xyPlot.getRendererForDataset(ds);
                if (renderer != null) {
                    for (XYAnnotation xyAnnotation : (List)renderer.getAnnotations()) {
                        Object selectionItem = this.getSelectionItem(xyAnnotation);
                        if (selectionItem == null || !selectionItems.contains(selectionItem) || !(xyAnnotation instanceof XYAnnotationBoundsInfo)) continue;
                        Range xRange = ((XYAnnotationBoundsInfo)xyAnnotation).getXRange();
                        Range yRange = ((XYAnnotationBoundsInfo)xyAnnotation).getYRange();
                        Rectangle2D j2DBounds = this.valueToJava2D(xRange.getLowerBound(), yRange.getLowerBound(), xRange.getUpperBound(), yRange.getUpperBound(), xyPlot, dataArea, domainAxis, rangeAxis);
                        this.addBounds(selectionBounds, selectionItem, j2DBounds);
                    }
                }
                int s = 0;
                while (s < dataset.getSeriesCount()) {
                    int itemCount = dataset.getItemCount(s);
                    int i = 0;
                    while (i < itemCount) {
                        Object selectionItem = this.getSelectionItem((XYDataset)dataset, s, i);
                        if (selectionItem != null && selectionItems.contains(selectionItem)) {
                            double xStart = dataset.getStartXValue(s, i);
                            double yStart = dataset.getStartYValue(s, i);
                            double xEnd = dataset.getEndXValue(s, i);
                            double yEnd = dataset.getEndYValue(s, i);
                            Rectangle2D j2DBounds = this.valueToJava2D(xStart, yStart, xEnd, yEnd, xyPlot, dataArea, domainAxis, rangeAxis);
                            this.addBounds(selectionBounds, selectionItem, j2DBounds);
                        }
                        ++i;
                    }
                    ++s;
                }
            }
            ++d;
        }
        for (XYAnnotation xyAnnotation : xyPlot.getAnnotations()) {
            Object selectionItem = this.getSelectionItem(xyAnnotation);
            if (selectionItem == null || !selectionItems.contains(selectionItem) || !(xyAnnotation instanceof XYAnnotationBoundsInfo)) continue;
            Range xRange = ((XYAnnotationBoundsInfo)xyAnnotation).getXRange();
            Range yRange = ((XYAnnotationBoundsInfo)xyAnnotation).getYRange();
            Rectangle2D j2DBounds = this.valueToJava2D(xRange.getLowerBound(), yRange.getLowerBound(), xRange.getUpperBound(), yRange.getUpperBound(), xyPlot, dataArea, xyPlot.getDomainAxis(), xyPlot.getRangeAxis());
            this.addBounds(selectionBounds, selectionItem, j2DBounds);
        }
        return selectionBounds;
    }

    protected Rectangle2D valueToJava2D(double x1, double y1, double x2, double y2, XYPlot xyPlot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis) {
        RectangleEdge domainAxisEdge = xyPlot.getDomainAxisEdge(xyPlot.getDomainAxisIndex(domainAxis));
        RectangleEdge rangeAxisEdge = xyPlot.getRangeAxisEdge(xyPlot.getRangeAxisIndex(rangeAxis));
        boolean isVerticalOrientation = xyPlot.getOrientation() == PlotOrientation.VERTICAL;
        ValueAxis xAxis = isVerticalOrientation ? domainAxis : rangeAxis;
        RectangleEdge xAxisEdge = isVerticalOrientation ? domainAxisEdge : rangeAxisEdge;
        ValueAxis yAxis = isVerticalOrientation ? rangeAxis : domainAxis;
        RectangleEdge yAxisEdge = isVerticalOrientation ? rangeAxisEdge : domainAxisEdge;
        double j2DX1 = xAxis.valueToJava2D(x1, dataArea, xAxisEdge);
        double j2DY1 = yAxis.valueToJava2D(y1, dataArea, yAxisEdge);
        double j2DX2 = xAxis.valueToJava2D(x2, dataArea, xAxisEdge);
        double j2DY2 = yAxis.valueToJava2D(y2, dataArea, yAxisEdge);
        return new Rectangle2D.Double(Math.min(j2DX1, j2DX2), Math.min(j2DY1, j2DY2), Math.abs(j2DX2 - j2DX1), Math.abs(j2DY2 - j2DY1));
    }

    private void addBounds(Map<Object, Rectangle2D> map, Object o, Rectangle2D bounds) {
        map.compute(o, (k, v) -> v == null ? bounds : bounds.createUnion((Rectangle2D)v));
    }

    protected Object getSelectionItem(ChartEntity chartEntity) {
        BackReferenceProvider<?> backReferenceProvider = this.backReferenceResolver.resolveBackReferenceProvider(chartEntity);
        return backReferenceProvider == null ? null : backReferenceProvider.getBackReference();
    }

    protected Object getSelectionItem(XYDataset dataset, int seriesIndex, int item) {
        BackReferenceProvider<?> backReferenceProvider = this.backReferenceResolver.resolveBackReferenceProvider(dataset, seriesIndex, item);
        return backReferenceProvider == null ? null : backReferenceProvider.getBackReference();
    }

    protected Object getSelectionItem(XYAnnotation annotation) {
        BackReferenceProvider<?> backReferenceProvider = this.backReferenceResolver.resolveBackReferenceProvider((Annotation)annotation);
        return backReferenceProvider == null ? null : backReferenceProvider.getBackReference();
    }

    public static enum Axis {
        X,
        Y,
        BOTH;

    }

    private class MouseSelectionListener
    implements ChartMouseListener {
        private MouseSelectionListener() {
        }

        public void chartMouseMoved(ChartMouseEvent event) {
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            StructuredSelection selection;
            if (event.getTrigger().isAltDown() || event.getTrigger().isAltGraphDown() || event.getTrigger().isMetaDown()) {
                return;
            }
            Object selectionItem = ChartPanelSelectionHandler.this.getSelectionItem(event.getEntity());
            if (selectionItem == null) {
                return;
            }
            if (ChartPanelSelectionHandler.this.selectionType == SelectionType.Multi && event.getTrigger().isControlDown() && !ChartPanelSelectionHandler.this.selectionProvider.getSelection().isEmpty()) {
                ArrayList<Object> newSelection = new ArrayList<Object>(((StructuredSelection)ChartPanelSelectionHandler.this.selectionProvider.getSelection()).toList());
                if (!newSelection.remove(selectionItem)) {
                    newSelection.add(selectionItem);
                }
                selection = new StructuredSelection(newSelection);
            } else {
                selection = new StructuredSelection(selectionItem);
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> ChartPanelSelectionHandler.this.selectionProvider.setSelection((ISelection)selection));
        }
    }

    private class SelectionOverlay
    extends AbstractOverlay
    implements Overlay,
    ISelectionChangedListener {
        private Paint selectionPaint = new Color(255, 255, 0, 200);
        private Stroke selectionStroke = new BasicStroke(2.0f);

        private SelectionOverlay() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.fireOverlayChanged();
        }

        public void paintOverlay(Graphics2D g2, ChartPanel chartPanel) {
            ISelection selection = ChartPanelSelectionHandler.this.selectionProvider.getSelection();
            if (selection == null || selection.isEmpty()) {
                return;
            }
            Graphics2D g = (Graphics2D)g2.create();
            g.clip(chartPanel.getScreenDataArea());
            g.setStroke(this.selectionStroke);
            g.setPaint(this.selectionPaint);
            for (ChartEntity chartEntity : this.getSelectedChartEntities(selection)) {
                AffineTransform transform = new AffineTransform();
                transform.scale(chartPanel.getScaleX(), chartPanel.getScaleY());
                Shape selectionShape = transform.createTransformedShape(chartEntity.getArea());
                g.draw(this.selectionStroke.createStrokedShape(selectionShape));
            }
        }

        private Collection<ChartEntity> getSelectedChartEntities(ISelection selection) {
            if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
                return Collections.emptyList();
            }
            List selectionItems = ((StructuredSelection)selection).toList();
            ArrayList<ChartEntity> result = new ArrayList<ChartEntity>(selectionItems.size());
            for (Object chartEntity : ChartPanelSelectionHandler.this.chartPanel.getChartRenderingInfo().getEntityCollection().getEntities()) {
                Object selectionItem = ChartPanelSelectionHandler.this.getSelectionItem((ChartEntity)chartEntity);
                if (!selectionItems.contains(selectionItem)) continue;
                result.add((ChartEntity)chartEntity);
            }
            return result;
        }
    }

    public static enum SelectionType {
        Single,
        Multi,
        ReadOnly,
        None;

    }
}

