/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis.ondemand;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysis;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public final class OnDemandAnalysisManager {
    private static @Nullable OnDemandAnalysisManager INSTANCE;
    private static final String EXTENSION_POINT_ID = "org.eclipse.tracecompass.tmf.core.analysis.ondemand";
    private static final String ELEM_NAME_ANALYSIS = "analysis";
    private static final String ATTR_CLASS = "class";
    private final LoadingCache<ITmfTrace, Set<IOnDemandAnalysis>> analysisCache = (LoadingCache)NonNullUtils.checkNotNull((Object)CacheBuilder.newBuilder().weakKeys().softValues().build((CacheLoader)new CacheLoader<ITmfTrace, Set<IOnDemandAnalysis>>(){

        public Set<IOnDemandAnalysis> load(ITmfTrace trace) {
            return (Set)OnDemandAnalysisManager.this.fAnalysisWrappers.stream().map(wrapper -> wrapper.analysis).filter(analysis -> analysis.appliesTo(trace)).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
        }
    }));
    private final Set<OndemandAnalysisWrapper> fAnalysisWrappers = new HashSet<OndemandAnalysisWrapper>();

    public static synchronized OnDemandAnalysisManager getInstance() {
        OnDemandAnalysisManager inst = INSTANCE;
        if (inst == null) {
            INSTANCE = inst = new OnDemandAnalysisManager();
        }
        return inst;
    }

    private OnDemandAnalysisManager() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ELEM_NAME_ANALYSIS.equals(element.getName())) {
                try {
                    Object extension = element.createExecutableExtension(ATTR_CLASS);
                    if (extension != null) {
                        this.fAnalysisWrappers.add(new OndemandAnalysisWrapper((IOnDemandAnalysis)extension));
                    }
                }
                catch (ClassCastException | CoreException e) {
                    Activator.logError("Exception while loading extension point", e);
                }
            }
            ++n2;
        }
    }

    public Set<IOnDemandAnalysis> getOndemandAnalyses(ITmfTrace trace) {
        return (Set)NonNullUtils.checkNotNull((Object)((Set)this.analysisCache.getUnchecked((Object)trace)));
    }

    public void registerAnalysis(IOnDemandAnalysis analysis) {
        if (this.fAnalysisWrappers.stream().anyMatch(wrapper -> wrapper.analysis.getName().equals(analysis.getName()))) {
            Activator.logWarning(String.format("Ignoring external analysis with existing name \"%s\"", analysis.getName()));
            return;
        }
        this.fAnalysisWrappers.add(new OndemandAnalysisWrapper(analysis));
        this.analysisCache.invalidateAll();
    }

    public void unregisterAnalysis(IOnDemandAnalysis analysis) {
        if (!analysis.isUserDefined()) {
            Activator.logWarning(String.format("Not unregistering built-in on-demand analysis \"%s\"", analysis.getName()));
            return;
        }
        this.fAnalysisWrappers.remove(new OndemandAnalysisWrapper(analysis));
        this.analysisCache.invalidateAll();
    }

    private static class OndemandAnalysisWrapper {
        public final IOnDemandAnalysis analysis;

        public OndemandAnalysisWrapper(IOnDemandAnalysis analysis) {
            this.analysis = analysis;
        }

        public int hashCode() {
            return this.analysis.hashCode();
        }

        public boolean equals(@Nullable Object o) {
            if (!(o instanceof OndemandAnalysisWrapper)) {
                return false;
            }
            OndemandAnalysisWrapper other = (OndemandAnalysisWrapper)o;
            return this.analysis.getName().equals(other.analysis.getName());
        }
    }
}

