/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;

public class ASTCache {
    private static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/ASTCache"));
    private static final String DEBUG_PREFIX = "[ASTCache] ";
    public static int PARSE_MODE = 230;
    private final int fParseMode;
    private final Object fCacheMutex = new Object();
    private ITranslationUnit fActiveTU;
    private IASTTranslationUnit fAST;
    private long fLastWriteOnIndex;
    private boolean fIsReconciling;

    public ASTCache() {
        this.fParseMode = PARSE_MODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private IASTTranslationUnit getAST(ITranslationUnit tUnit, IIndex index, boolean wait, IProgressMonitor progressMonitor) {
        if (tUnit == null) {
            return null;
        }
        while (true) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                return null;
            }
            var6_6 = this.fCacheMutex;
            synchronized (var6_6) {
                block31: {
                    isActiveElement = tUnit.equals(this.fActiveTU);
                    if (!isActiveElement) break block31;
                    if (this.fAST != null) {
                        if (this.fLastWriteOnIndex < index.getLastWriteAccess()) {
                            this.disposeAST();
                        } else {
                            if (ASTCache.DEBUG) {
                                System.out.println("[ASTCache] " + ASTCache.getThreadName() + "returning cached AST:" + ASTCache.toString(this.fAST) + " for: " + tUnit.getElementName());
                            }
                            return this.fAST;
                        }
                    }
                    if (wait) break block31;
                    if (ASTCache.DEBUG) {
                        System.out.println("[ASTCache] " + ASTCache.getThreadName() + "returning null (WAIT_NO) for: " + tUnit.getElementName());
                    }
                    return null;
                }
                if (!isActiveElement || !this.isReconciling(tUnit)) break;
                try {
                    if (ASTCache.DEBUG) {
                        System.out.println("[ASTCache] " + ASTCache.getThreadName() + "waiting for AST for: " + tUnit.getElementName());
                    }
                    this.fCacheMutex.wait();
                    if (this.fAST != null) {
                        if (ASTCache.DEBUG) {
                            System.out.println("[ASTCache] " + ASTCache.getThreadName() + "...got AST for: " + tUnit.getElementName());
                        }
                        return this.fAST;
                    }
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
        }
        {
            block32: {
                if (wait) break block32;
                return null;
            }
            ** try [egrp 4[TRYBLOCK] [7 : 339->345)] { 
            {
            }
        }
lbl45:
        // 1 sources

        if (isActiveElement) {
            this.aboutToBeReconciled(tUnit);
        }
        if (ASTCache.DEBUG) {
            System.err.println("[ASTCache] " + ASTCache.getThreadName() + "creating AST for " + tUnit.getElementName());
        }
        ast = null;
        try {
            ast = this.createAST(tUnit, index, progressMonitor);
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                ast = null;
            } else if (ASTCache.DEBUG && ast != null) {
                System.err.println("[ASTCache] " + ASTCache.getThreadName() + "created AST for: " + tUnit.getElementName());
            }
        }
        finally {
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (ASTCache.DEBUG) {
                        System.out.println("[ASTCache] " + ASTCache.getThreadName() + "Ignore created AST for " + tUnit.getElementName() + "- AST from reconciler is newer");
                    }
                    this.reconciled(this.fAST, tUnit);
                } else {
                    this.reconciled(ast, tUnit);
                }
            }
        }
        return ast;
    }

    public IStatus runOnAST(ITranslationUnit tUnit, boolean wait, IProgressMonitor monitor, ASTRunnable astRunnable) {
        IIndex index;
        try {
            index = CCorePlugin.getIndexManager().getIndex(tUnit.getCProject(), 1024);
            index.acquireReadLock();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        try {
            IStatus iStatus;
            ILanguage lang;
            IASTTranslationUnit ast = this.acquireSharedAST(tUnit, index, wait, monitor);
            ILanguage iLanguage = lang = tUnit instanceof TranslationUnit ? ((TranslationUnit)tUnit).getLanguageOfContext() : tUnit.getLanguage();
            if (ast == null) {
                IStatus iStatus2 = astRunnable.runOnAST(lang, ast);
                return iStatus2;
            }
            try {
                CPPSemantics.pushLookupPoint(ast);
                iStatus = astRunnable.runOnAST(lang, ast);
            }
            catch (Throwable throwable) {
                try {
                    CPPSemantics.popLookupPoint();
                    this.releaseSharedAST(ast);
                    throw throwable;
                }
                catch (CoreException e) {
                    IStatus iStatus3 = e.getStatus();
                    return iStatus3;
                }
            }
            CPPSemantics.popLookupPoint();
            this.releaseSharedAST(ast);
            return iStatus;
        }
        finally {
            index.releaseReadLock();
        }
    }

    public final IASTTranslationUnit acquireSharedAST(ITranslationUnit tUnit, IIndex index, boolean wait, IProgressMonitor progressMonitor) {
        IASTTranslationUnit ast = this.getAST(tUnit, index, wait, progressMonitor);
        if (ast != null) {
            try {
                if (wait) {
                    ((ASTTranslationUnit)ast).beginExclusiveAccess();
                } else if (!((ASTTranslationUnit)ast).tryBeginExclusiveAccess(0L)) {
                    return null;
                }
            }
            catch (InterruptedException e) {
                throw new OperationCanceledException();
            }
        }
        return ast;
    }

    public final void releaseSharedAST(IASTTranslationUnit ast) {
        ((ASTTranslationUnit)ast).endExclusiveAccess();
    }

    private void cache(IASTTranslationUnit ast, ITranslationUnit tUnit) {
        assert (Thread.holdsLock(this.fCacheMutex));
        if (this.fActiveTU != null && !this.fActiveTU.equals(tUnit)) {
            if (DEBUG && tUnit != null) {
                System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "don't cache AST for inactive: " + ASTCache.toString(tUnit));
            }
            return;
        }
        if (DEBUG && (tUnit != null || ast != null)) {
            System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "caching AST: " + ASTCache.toString(ast) + " for: " + ASTCache.toString(tUnit));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = ast;
        this.fLastWriteOnIndex = this.fAST == null ? 0L : this.fAST.getIndex().getLastWriteAccess();
        this.fCacheMutex.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAST() {
        Object object = this.fCacheMutex;
        synchronized (object) {
            if (this.fAST == null) {
                return;
            }
            if (DEBUG) {
                System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "disposing AST: " + ASTCache.toString(this.fAST) + " for: " + ASTCache.toString(this.fActiveTU));
            }
            this.fAST = null;
            this.cache(null, null);
        }
    }

    public IASTTranslationUnit createAST(final ITranslationUnit tUnit, final IIndex index, final IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final IASTTranslationUnit[] root = new IASTTranslationUnit[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws CoreException {
                try {
                    root[0] = progressMonitor != null && progressMonitor.isCanceled() ? null : tUnit.getAST(index, ASTCache.this.fParseMode);
                }
                catch (OperationCanceledException ex) {
                    root[0] = null;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.cdt.core", 0, "Error in CDT Core during AST creation", ex);
                CCorePlugin.getDefault().getLog().log((IStatus)status);
            }
        });
        return root[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveElement(ITranslationUnit tUnit) {
        if (tUnit == this.fActiveTU) {
            return;
        }
        Object object = this.fCacheMutex;
        synchronized (object) {
            this.fIsReconciling = false;
            this.fActiveTU = tUnit;
            this.cache(null, tUnit);
        }
        if (DEBUG) {
            System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "active element is: " + ASTCache.toString(tUnit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveElement(ITranslationUnit tUnit) {
        Object object = this.fCacheMutex;
        synchronized (object) {
            return this.fActiveTU != null && this.fActiveTU.equals(tUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aboutToBeReconciled(ITranslationUnit tUnit) {
        if (tUnit == null) {
            return;
        }
        Object object = this.fCacheMutex;
        synchronized (object) {
            if (this.fActiveTU == null || !this.fActiveTU.equals(tUnit)) {
                return;
            }
            if (DEBUG) {
                System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "about to reconcile: " + ASTCache.toString(tUnit));
            }
            this.fIsReconciling = true;
            this.cache(null, tUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconciled(IASTTranslationUnit ast, ITranslationUnit tUnit) {
        Object object = this.fCacheMutex;
        synchronized (object) {
            if (tUnit == null || !tUnit.equals(this.fActiveTU)) {
                if (DEBUG) {
                    System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "ignoring AST of out-dated element");
                }
                return;
            }
            if (DEBUG) {
                System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "reconciled: " + ASTCache.toString(tUnit) + ", AST: " + ASTCache.toString(ast));
            }
            this.fIsReconciling = false;
            this.cache(ast, tUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReconciling(ITranslationUnit tUnit) {
        Object object = this.fCacheMutex;
        synchronized (object) {
            block4: {
                if (this.fActiveTU != null && tUnit != null) break block4;
                return false;
            }
            return this.fIsReconciling && this.fActiveTU.equals(tUnit);
        }
    }

    private static String getThreadName() {
        String name = Thread.currentThread().getName();
        if (name != null) {
            return String.valueOf(name) + ": ";
        }
        return String.valueOf(Thread.currentThread().toString()) + ": ";
    }

    private static String toString(ITranslationUnit tUnit) {
        if (tUnit == null) {
            return "null";
        }
        return tUnit.getElementName();
    }

    private static String toString(IASTTranslationUnit ast) {
        if (ast == null) {
            return "null";
        }
        return ast.getFilePath();
    }

    public static interface ASTRunnable {
        public IStatus runOnAST(ILanguage var1, IASTTranslationUnit var2) throws CoreException;
    }
}

