/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.ui;

import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.ui.scripts.Messages;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.scripts.ui.ScriptComposite;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class ScriptSelectionDialog
extends Dialog {
    private final IWorkbenchPartSite dialogSite;
    private IScript fSelectedScript = null;

    public ScriptSelectionDialog(Shell parentShell, IWorkbenchPartSite iWorkbenchPartSite) {
        super(parentShell);
        this.dialogSite = iWorkbenchPartSite;
        this.setShellStyle(parentShell.getStyle() | 0x40 | 0x20 | 0x800 | 0x10000);
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        ScriptComposite mComposite = new ScriptComposite(new IScriptEngineProvider(){

            public IScriptEngine getScriptEngine() {
                return null;
            }
        }, this.dialogSite, composite, 0);
        mComposite.setLayoutData(new GridData(4, 4, true, true));
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ScriptSelectionDialog_scriptBrowser);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setText(Messages.ScriptSelectionDialog_open);
        this.setButtonLayoutData(ok);
        Button cancel = this.getButton(1);
        cancel.setText(Messages.ScriptSelectionDialog_cancel);
        this.setButtonLayoutData(cancel);
    }

    public void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.dialogSite.getSelectionProvider().getSelection();
        if (selection.getFirstElement() instanceof IScript) {
            this.fSelectedScript = (IScript)selection.getFirstElement();
        }
        super.okPressed();
    }

    public IScript getMacro() {
        return this.fSelectedScript;
    }
}

