/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.ease.BreakException;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.ISecurityCheck;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineCancellationException;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.ScriptExecutionException;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.debugging.EaseDebugFrame;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.security.ScriptUIAccess;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.tools.ListenerList;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.osgi.framework.Version;

public abstract class AbstractScriptEngine
extends Job
implements IScriptEngine {
    private final List<Script> fScheduledScripts = Collections.synchronizedList(new ArrayList());
    private final ListenerList<IExecutionListener> fExecutionListeners = new ListenerList();
    private PrintStream fOutputStream = null;
    private PrintStream fErrorStream = null;
    private InputStream fInputStream = null;
    private final ScriptStackTrace fStackTrace = new ScriptStackTrace();
    private EngineDescription fDescription;
    private boolean fSetupDone = false;
    private final Map<String, Object> fBufferedVariables = new HashMap<String, Object>();
    private boolean fCloseStreamsOnTerminate;
    private final Map<ISecurityCheck.ActionType, List<ISecurityCheck>> fSecurityChecks = new HashMap<ISecurityCheck.ActionType, List<ISecurityCheck>>();
    private Object fExecutionRootFile;
    private ILaunch fLaunch = null;
    private IProgressMonitor fMonitor;

    public static IScriptEngine getCurrentScriptEngine() {
        if (Job.getJobManager().currentJob() instanceof IScriptEngine) {
            return (IScriptEngine)Job.getJobManager().currentJob();
        }
        return null;
    }

    private static String getFilename(Object file) {
        if (file instanceof IFile) {
            return ResourceTools.toAbsoluteLocation(file, null);
        }
        if (file instanceof File) {
            return ResourceTools.toAbsoluteLocation(file, null);
        }
        return null;
    }

    public AbstractScriptEngine(String name) {
        super("[EASE " + name + " Engine]");
        this.setSystem(false);
    }

    @Override
    public EngineDescription getDescription() {
        return this.fDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ScriptResult execute(Object content) {
        Script script = content instanceof Script ? (Script)content : new Script(content);
        this.fScheduledScripts.add(script);
        AbstractScriptEngine abstractScriptEngine = this;
        synchronized (abstractScriptEngine) {
            this.notifyAll();
        }
        return script.getResult();
    }

    @Override
    public Object inject(Object content, boolean uiThread) throws ExecutionException {
        Script script = content instanceof Script ? (Script)content : new Script(content);
        return this.inject(script, false, uiThread).get();
    }

    private ScriptResult inject(Script script, boolean notifyListeners, boolean uiThread) {
        block22: {
            block23: {
                try {
                    Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Executing script (" + script.getTitle() + "):", script.getCode());
                    String filename = AbstractScriptEngine.getFilename(script.getFile());
                    this.fStackTrace.add(0, new EaseDebugFrame(script, 0, 1, filename));
                    this.updateJobName(filename);
                    List<ISecurityCheck> securityChecks = this.fSecurityChecks.get((Object)ISecurityCheck.ActionType.INJECT_CODE);
                    if (securityChecks != null) {
                        for (ISecurityCheck check : securityChecks) {
                            if (check.doIt(ISecurityCheck.ActionType.INJECT_CODE, script, uiThread)) continue;
                            throw new ScriptEngineException("Security check failed: " + check.toString());
                        }
                    }
                    if (notifyListeners) {
                        this.notifyExecutionListeners(script, 3);
                    } else {
                        this.notifyExecutionListeners(script, 5);
                    }
                    script.setResult(this.execute(script, script.getFile(), ((IScriptDebugFrame)this.fStackTrace.get(0)).getName(), uiThread));
                }
                catch (BreakException e) {
                    script.setResult(e.getCondition());
                    if (notifyListeners) {
                        this.notifyExecutionListeners(script, 4);
                    } else {
                        this.notifyExecutionListeners(script, 6);
                    }
                    if (!this.fStackTrace.isEmpty()) {
                        this.fStackTrace.remove(0);
                    }
                    break block22;
                }
                catch (Throwable e) {
                    try {
                        if (this.fStackTrace.size() <= 1) {
                            e.printStackTrace(this.getErrorStream());
                        }
                        if (e instanceof ScriptExecutionException) {
                            script.setException((ScriptExecutionException)e);
                        } else {
                            script.setException(new ScriptExecutionException(e));
                        }
                        break block22;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (notifyListeners) {
                            this.notifyExecutionListeners(script, 4);
                        } else {
                            this.notifyExecutionListeners(script, 6);
                        }
                        if (!this.fStackTrace.isEmpty()) {
                            this.fStackTrace.remove(0);
                        }
                    }
                }
                if (notifyListeners) {
                    this.notifyExecutionListeners(script, 4);
                    break block23;
                }
                this.notifyExecutionListeners(script, 6);
            }
            if (!this.fStackTrace.isEmpty()) {
                this.fStackTrace.remove(0);
            }
        }
        return script.getResult();
    }

    private void updateJobName(String filename) {
        if (filename != null) {
            String baseName = this.getName();
            if (baseName.contains("]")) {
                baseName = baseName.substring(0, baseName.indexOf(93) + 1);
            }
            this.setName(String.valueOf(baseName) + " " + filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        this.fMonitor = monitor;
        this.addStopButtonMonitor();
        IStatus returnStatus = this.setupRun();
        if (Status.OK_STATUS.equals(returnStatus)) {
            while (!this.shallTerminate()) {
                if (!this.fScheduledScripts.isEmpty()) {
                    Script piece = this.fScheduledScripts.remove(0);
                    this.inject(piece, true, false);
                    continue;
                }
                AbstractScriptEngine abstractScriptEngine = this;
                synchronized (abstractScriptEngine) {
                    try {
                        Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine idle: " + this.getName());
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.getMonitor().isCanceled()) {
            returnStatus = Status.CANCEL_STATUS;
        }
        return this.cleanupRun(returnStatus);
    }

    private IStatus setupRun() {
        Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine started: " + this.getName());
        this.addSecurityCheck(ISecurityCheck.ActionType.INJECT_CODE, ScriptUIAccess.getInstance());
        try {
            this.setupEngine();
            this.fSetupDone = true;
            for (Map.Entry<String, Object> entry : this.fBufferedVariables.entrySet()) {
                this.setVariable(entry.getKey(), entry.getValue());
            }
            this.fBufferedVariables.clear();
            this.fStackTrace.clear();
            this.notifyExecutionListeners(null, 1);
        }
        catch (ScriptEngineException e) {
            return new Status(4, "org.eclipse.ease", "Could not setup script engine", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus cleanupRun(IStatus returnStatus) {
        block19: {
            Object object;
            List<Script> list = this.fScheduledScripts;
            synchronized (list) {
                for (Script script : this.fScheduledScripts) {
                    script.setException(new ScriptExecutionException("Engine got terminated"));
                }
            }
            this.fScheduledScripts.clear();
            this.notifyExecutionListeners(null, 2);
            try {
                try {
                    this.teardownEngine();
                }
                catch (ScriptEngineException e) {
                    if (returnStatus.getSeverity() < 4) {
                        returnStatus = new Status(4, "org.eclipse.ease", "Could not teardown script engine", (Throwable)e);
                    }
                    object = this;
                    synchronized (object) {
                        this.notifyAll();
                    }
                    this.closeStreams();
                    Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
                    this.fMonitor.done();
                    this.fMonitor = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                object = this;
                synchronized (object) {
                    this.notifyAll();
                }
                this.closeStreams();
                Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
                this.fMonitor.done();
                this.fMonitor = null;
                throw throwable;
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            this.closeStreams();
            Logger.trace("org.eclipse.ease", TRACE_SCRIPT_ENGINE, "Engine terminated: " + this.getName());
            this.fMonitor.done();
            this.fMonitor = null;
        }
        return returnStatus;
    }

    private void addStopButtonMonitor() {
        if (this.fMonitor instanceof ProgressManager.JobMonitor) {
            Version workbenchBundleVersion = Platform.getBundle((String)"org.eclipse.ui.workbench").getVersion();
            if (workbenchBundleVersion.compareTo(Version.valueOf((String)"3.120.0")) >= 0) {
                this.addStopButtonMonitorForEclipse2020v09();
            } else if (workbenchBundleVersion.compareTo(Version.valueOf((String)"3.110.1")) >= 0) {
                this.addStopButtonMonitorForEclipseOxygenTo2020v06();
            }
        }
    }

    private void addStopButtonMonitorForEclipseOxygenTo2020v06() {
        try {
            Method addProgressListener = ProgressManager.JobMonitor.class.getDeclaredMethod("addProgressListener", IProgressMonitorWithBlocking.class);
            addProgressListener.invoke((Object)this.fMonitor, new Object[]{new ScriptEngineMonitor()});
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private void addStopButtonMonitorForEclipse2020v09() {
        ((ProgressManager.JobMonitor)this.fMonitor).addProgressListener((IProgressMonitor)new ScriptEngineMonitor());
    }

    protected boolean shallTerminate() {
        return this.getMonitor().isCanceled() || this.fScheduledScripts.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null && !monitor.isCanceled()) {
            monitor.setCanceled(true);
        }
        this.terminateCurrent();
        AbstractScriptEngine abstractScriptEngine = this;
        synchronized (abstractScriptEngine) {
            this.notify();
        }
    }

    public void checkForCancellation() {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null && monitor.isCanceled() && Thread.currentThread().equals(this.getThread())) {
            throw new ScriptEngineCancellationException();
        }
    }

    @Override
    public boolean isFinished() {
        return this.getState() == 0 && this.fSetupDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void joinEngine() throws InterruptedException {
        if (!Thread.currentThread().equals(this.getThread())) {
            AbstractScriptEngine abstractScriptEngine = this;
            synchronized (abstractScriptEngine) {
                while (!this.isFinished()) {
                    this.wait(1000L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void joinEngine(long timeout) throws InterruptedException {
        if (!Thread.currentThread().equals(this.getThread())) {
            AbstractScriptEngine abstractScriptEngine = this;
            synchronized (abstractScriptEngine) {
                if (!this.isFinished()) {
                    this.wait(timeout);
                }
            }
        }
    }

    @Override
    public IProgressMonitor getMonitor() {
        return this.fMonitor;
    }

    private void closeStreams() {
        if (this.fCloseStreamsOnTerminate) {
            try {
                if (this.getInputStream() != null && !System.in.equals(this.getInputStream())) {
                    this.getInputStream().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.getOutputStream() != null && !System.out.equals(this.getOutputStream())) {
                    this.getOutputStream().close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.getErrorStream() != null && !System.err.equals(this.getErrorStream())) {
                    this.getErrorStream().close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fOutputStream = null;
        this.fErrorStream = null;
        this.fInputStream = null;
    }

    @Override
    public void setCloseStreamsOnTerminate(boolean closeStreams) {
        this.fCloseStreamsOnTerminate = closeStreams;
    }

    @Override
    public PrintStream getOutputStream() {
        return this.fOutputStream != null ? this.fOutputStream : System.out;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream instanceof PrintStream ? (PrintStream)outputStream : (outputStream != null ? new PrintStream(outputStream) : null);
    }

    @Override
    public InputStream getInputStream() {
        return this.fInputStream != null ? this.fInputStream : System.in;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    @Override
    public PrintStream getErrorStream() {
        return this.fErrorStream != null ? this.fErrorStream : System.err;
    }

    @Override
    public void setErrorStream(OutputStream errorStream) {
        this.fErrorStream = errorStream instanceof PrintStream ? (PrintStream)errorStream : (errorStream != null ? new PrintStream(errorStream) : null);
    }

    @Override
    public void addExecutionListener(IExecutionListener listener) {
        this.fExecutionListeners.add(listener);
    }

    @Override
    public void removeExecutionListener(IExecutionListener listener) {
        this.fExecutionListeners.remove(listener);
    }

    protected void notifyExecutionListeners(Script script, int status) {
        Object[] objectArray = this.fExecutionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IExecutionListener)listener).notify(this, script, status);
            ++n2;
        }
    }

    public ScriptStackTrace getStackTrace() {
        return this.fStackTrace;
    }

    @Override
    public Object getExecutedFile() {
        for (IScriptDebugFrame trace : this.getStackTrace()) {
            Object file;
            if (trace.getType() != 1 || trace.getScript() == null || (file = trace.getScript().getFile()) == null) continue;
            return file;
        }
        return this.fExecutionRootFile;
    }

    public void setExecutionRootFile(Object executionRootFile) {
        this.fExecutionRootFile = executionRootFile;
    }

    public void setEngineDescription(EngineDescription description) {
        this.fDescription = description;
    }

    @Override
    public void setVariable(String name, Object content) {
        if (this.fSetupDone) {
            this.internalSetVariable(name, content);
        } else {
            this.fBufferedVariables.put(name, content);
        }
    }

    @Override
    public Object getVariable(String name) {
        if (this.fSetupDone) {
            return this.internalGetVariable(name);
        }
        return this.fBufferedVariables.get(name);
    }

    @Override
    public boolean hasVariable(String name) {
        if (this.fSetupDone) {
            return this.internalHasVariable(name);
        }
        return this.fBufferedVariables.containsKey(name);
    }

    @Override
    public Map<String, Object> getVariables() {
        if (this.fSetupDone) {
            return this.internalGetVariables();
        }
        return Collections.unmodifiableMap(this.fBufferedVariables);
    }

    public static final String[] extractArguments(String arguments) {
        ArrayList<String> args = new ArrayList<String>();
        if (arguments != null) {
            String[] tokens;
            String[] stringArray = tokens = arguments.split(",");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (!token.trim().isEmpty()) {
                    args.add(token.trim());
                }
                ++n2;
            }
        }
        return args.toArray(new String[args.size()]);
    }

    @Override
    public void addSecurityCheck(ISecurityCheck.ActionType type, ISecurityCheck check) {
        if (!this.fSecurityChecks.containsKey((Object)type)) {
            this.fSecurityChecks.put(type, new ArrayList());
        }
        if (!this.fSecurityChecks.get((Object)type).contains(check)) {
            this.fSecurityChecks.get((Object)type).add(check);
        }
    }

    @Override
    public void removeSecurityCheck(ISecurityCheck check) {
        for (List<ISecurityCheck> entry : this.fSecurityChecks.values()) {
            entry.remove(check);
        }
    }

    protected List<Script> getScheduledScripts() {
        return this.fScheduledScripts;
    }

    public void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    protected abstract Object internalGetVariable(String var1);

    protected abstract Map<String, Object> internalGetVariables();

    protected abstract boolean internalHasVariable(String var1);

    protected abstract void internalSetVariable(String var1, Object var2);

    protected abstract void setupEngine() throws ScriptEngineException;

    protected abstract void teardownEngine() throws ScriptEngineException;

    protected abstract Object execute(Script var1, Object var2, String var3, boolean var4) throws Throwable;

    private class ScriptEngineMonitor
    extends NullProgressMonitor
    implements IProgressMonitorWithBlocking {
        private ScriptEngineMonitor() {
        }

        public void setCanceled(boolean cancelled) {
            super.setCanceled(cancelled);
            if (this.isCanceled()) {
                AbstractScriptEngine.this.terminate();
            }
        }

        public void setBlocked(IStatus reason) {
        }

        public void clearBlocked() {
        }
    }
}

