/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.trace;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapNgBlock;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapNgInterface;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapNgPacket;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapTimestampScale;

public class PcapNgFile
extends PcapFile {
    private static final int MICRO = 6;
    private static final long MICRO_TO_NANO = 1000L;
    private static final long SEC_TO_NANO = 1000000000L;
    private List<PcapNgInterface> fInterfaceList = new ArrayList<PcapNgInterface>();

    public PcapNgFile(Path filePath) throws BadPcapFileException, IOException {
        super(filePath);
        ByteBuffer header = ByteBuffer.allocate(24);
        this.getFileChannel().read(header);
        header.flip();
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        header.order(byteOrder);
        int blockType = header.getInt();
        if (blockType != 0xA0D0D0A) {
            this.close();
            throw new BadPcapFileException(String.valueOf(String.format("0x%08x", blockType)) + " Missing Section Header Block.");
        }
        int blockLength = header.getInt();
        int magicNumber = header.getInt();
        if (magicNumber == Integer.reverseBytes(439041101)) {
            byteOrder = ByteOrder.BIG_ENDIAN;
            header.order(byteOrder);
            blockLength = Integer.reverseBytes(blockLength);
        } else if (magicNumber != 439041101) {
            this.close();
            throw new BadPcapFileException(String.valueOf(String.format("%08x", magicNumber)) + " is not a valid Byte-Order Magic value.");
        }
        int majorVersion = ConversionHelper.unsignedShortToInt(header.getShort());
        int minorVersion = ConversionHelper.unsignedShortToInt(header.getShort());
        this.getFileChannel().position(blockLength);
        this.getFileIndex().put(0L, this.getFileChannel().position());
        this.init(byteOrder, majorVersion, minorVersion);
    }

    @Override
    public synchronized @Nullable PcapNgPacket parseNextPacket() throws IOException, BadPcapFileException, BadPacketException {
        PcapPacket packet = null;
        long position = 0L;
        while (packet == null) {
            PcapNgBlock block = this.parseBlock();
            if (block == null) {
                this.setCurrentRank(this.getCurrentRank() + 1L);
                return null;
            }
            position = block.getPosition();
            switch (block.getBlockType()) {
                case 0xA0D0D0A: {
                    return null;
                }
                case 1: {
                    this.parseIDB(block);
                    break;
                }
                case 2: 
                case 6: {
                    packet = this.parseEPB(block);
                    break;
                }
                case 3: {
                    packet = this.parseSPB(block);
                    break;
                }
            }
        }
        packet.setIndex(this.getCurrentRank());
        this.getFileIndex().put(this.getCurrentRank(), position);
        this.setCurrentRank(this.getCurrentRank() + 1L);
        return packet;
    }

    private void parseIDB(PcapNgBlock block) {
        long position = block.getPosition();
        for (PcapNgInterface id : this.fInterfaceList) {
            if (id.getPosition() != position) continue;
            return;
        }
        ByteBuffer body = block.getBlockBody();
        short linkType = body.getShort();
        body.getShort();
        int snapLen = body.getInt();
        ByteBuffer options = Objects.requireNonNull(body.slice());
        options.order(body.order());
        ByteBuffer tsResolValue = PcapNgFile.getOptionValue(options, 9);
        byte tsResol = tsResolValue == null ? (byte)6 : (byte)tsResolValue.get();
        ByteBuffer tsOffsetValue = PcapNgFile.getOptionValue(options, 14);
        long tsOffset = tsOffsetValue == null ? 0L : tsOffsetValue.getLong();
        PcapNgInterface id = new PcapNgInterface(position, linkType, snapLen, tsResol, tsOffset);
        this.fInterfaceList.add(id);
        this.fInterfaceList.sort(Comparator.comparingLong(i -> i.getPosition()));
    }

    private PcapNgPacket parseEPB(PcapNgBlock block) throws BadPacketException {
        int interfaceID;
        ByteBuffer body = block.getBlockBody();
        if (block.getBlockType() == 6) {
            interfaceID = body.getInt();
        } else {
            interfaceID = ConversionHelper.unsignedShortToInt(body.getShort());
            body.getShort();
        }
        if (interfaceID >= this.fInterfaceList.size()) {
            throw new BadPacketException("Undefined Interface ID: " + interfaceID);
        }
        PcapNgInterface interfaceDesc = this.fInterfaceList.get(interfaceID);
        long timestampHigh = ConversionHelper.unsignedIntToLong(body.getInt());
        long timestampLow = ConversionHelper.unsignedIntToLong(body.getInt());
        long timestamp = (timestampHigh << 32) + timestampLow;
        long timestampNs = PcapNgFile.timestampToNs(timestamp, interfaceDesc);
        int capturedLength = body.getInt();
        int originalLength = body.getInt();
        ByteBuffer packetData = body.slice();
        packetData.limit(capturedLength);
        packetData.order(ByteOrder.BIG_ENDIAN);
        return new PcapNgPacket(this, interfaceDesc, timestampNs, originalLength, packetData);
    }

    private PcapNgPacket parseSPB(PcapNgBlock block) throws BadPacketException {
        ByteBuffer body = block.getBlockBody();
        int interfaceID = 0;
        if (interfaceID >= this.fInterfaceList.size()) {
            throw new BadPacketException("Undefined Interface ID: " + interfaceID);
        }
        PcapNgInterface interfaceDesc = this.fInterfaceList.get(interfaceID);
        int originalLength = body.getInt();
        int capturedLength = Math.min(originalLength, interfaceDesc.getSnapLen());
        ByteBuffer packetData = body.slice();
        packetData.limit(capturedLength);
        packetData.order(ByteOrder.BIG_ENDIAN);
        return new PcapNgPacket(this, interfaceDesc, 0L, originalLength, packetData);
    }

    private static @Nullable ByteBuffer getOptionValue(ByteBuffer options, int code) {
        options.rewind();
        while (options.remaining() > 0) {
            short optionCode = options.getShort();
            if (optionCode == 0) break;
            int length = ConversionHelper.unsignedShortToInt(options.getShort());
            if (optionCode == code) {
                ByteBuffer value = options.slice();
                value.limit(length);
                value.order(options.order());
                return value;
            }
            if (length % 4 != 0) {
                length += 4 - length % 4;
            }
            options.position(options.position() + length);
        }
        return null;
    }

    private static long timestampToNs(long timestamp, PcapNgInterface interfaceDesc) {
        BigDecimal divisor;
        byte tsResol = interfaceDesc.getTsResol();
        long tsOffset = interfaceDesc.getTsOffset();
        if (tsResol == 6) {
            return timestamp * 1000L + tsOffset * 1000000000L;
        }
        if ((tsResol & 0xFFFFFF80) == 0) {
            divisor = BigDecimal.TEN.pow(tsResol);
        } else {
            tsResol = (byte)(tsResol & 0x7F);
            divisor = BigDecimal.valueOf(2L).pow(tsResol);
        }
        return BigDecimal.valueOf(timestamp).divide(divisor).add(BigDecimal.valueOf(tsOffset)).multiply(BigDecimal.valueOf(1000000000L)).longValue();
    }

    @Override
    public PcapTimestampScale getTimestampPrecision() {
        return PcapTimestampScale.NANOSECOND;
    }

    private @Nullable PcapNgBlock parseBlock() throws IOException, BadPcapFileException {
        long position = this.getFileChannel().position();
        if (this.getFileChannel().size() - position < 8L) {
            return null;
        }
        ByteOrder byteOrder = this.getByteOrder();
        ByteBuffer blockHeader = ByteBuffer.allocate(8);
        blockHeader.order(byteOrder);
        this.getFileChannel().read(blockHeader);
        blockHeader.flip();
        int blockType = blockHeader.getInt();
        int blockLength = blockHeader.getInt();
        ByteBuffer blockBody = ByteBuffer.allocate(blockLength - 8 - 4);
        blockBody.order(byteOrder);
        this.getFileChannel().read(blockBody);
        blockBody.flip();
        ByteBuffer blockFooter = ByteBuffer.allocate(4);
        blockFooter.order(byteOrder);
        this.getFileChannel().read(blockFooter);
        blockFooter.flip();
        int blockLengthFooter = blockFooter.getInt();
        if (blockLengthFooter != blockLength) {
            throw new BadPcapFileException("Inconsistent Block Total Length");
        }
        return new PcapNgBlock(position, blockType, blockLength, blockBody);
    }

    @Override
    public synchronized boolean skipNextPacket() throws IOException, BadPcapFileException {
        ByteOrder byteOrder = this.getByteOrder();
        long position = this.getFileChannel().position();
        while (this.getFileChannel().size() - position >= 8L) {
            ByteBuffer blockHeader = ByteBuffer.allocate(8);
            this.getFileChannel().read(blockHeader);
            blockHeader.flip();
            blockHeader.order(byteOrder);
            int blockType = blockHeader.getInt();
            int blockLength = blockHeader.getInt();
            if (blockType == 1) {
                this.getFileChannel().position(position);
                PcapNgBlock block = this.parseBlock();
                if (block != null) {
                    this.parseIDB(block);
                }
            }
            this.getFileChannel().position(position + (long)blockLength);
            if (blockType == 0xA0D0D0A) break;
            if (blockType == 6 || blockType == 3 || blockType == 2) {
                this.getFileIndex().put(this.getCurrentRank(), position);
                this.setCurrentRank(this.getCurrentRank() + 1L);
                return true;
            }
            position += (long)blockLength;
        }
        this.setCurrentRank(this.getCurrentRank() + 1L);
        return false;
    }
}

