/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.ILabeledStatement;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.LabelFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;

public class LabeledStatement
extends Statement
implements ILabeledStatement {
    public Statement statement;
    public char[] label;
    public int labelEnd;
    int mergedInitStateIndex = -1;

    public LabeledStatement(char[] label, Statement statement, long labelPosition, int sourceEnd) {
        this.statement = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.label = label;
        this.sourceStart = (int)(labelPosition >>> 32);
        this.labelEnd = (int)labelPosition;
        this.sourceEnd = sourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statement == null) {
            return flowInfo;
        }
        LabelFlowContext labelContext = new LabelFlowContext(flowContext, this, this.label, currentScope);
        FlowInfo statementInfo = this.statement.analyseCode(currentScope, labelContext, flowInfo);
        FlowInfo mergedInfo = (statementInfo.tagBits & 1) != 0 ? ((labelContext.initsOnBreak.tagBits & 1) == 0 ? flowInfo.unconditionalCopy().addInitializationsFrom(labelContext.initsOnBreak) : labelContext.initsOnBreak) : statementInfo.mergedWith(labelContext.initsOnBreak);
        if ((this.bits & 0x40) == 0) {
            currentScope.problemReporter().unusedLabel(this);
        }
        return mergedInfo;
    }

    @Override
    public ASTNode concreteStatement() {
        return this.statement;
    }

    @Override
    public StringBuffer printStatement(int tab, StringBuffer output) {
        LabeledStatement.printIndent(tab, output).append(this.label).append(": ");
        if (this.statement == null) {
            output.append(';');
        } else {
            this.statement.printStatement(0, output);
        }
        return output;
    }

    @Override
    public void resolve(BlockScope scope) {
        if (this.statement != null) {
            this.statement.resolve(scope);
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.statement != null) {
            this.statement.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 63;
    }
}

