/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMoveStarter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

public class SelectionTransferDropAdapter
extends JdtViewerDropAdapter
implements TransferDropTargetListener {
    private List fElements;
    private JavaMoveProcessor fMoveProcessor;
    private int fCanMoveElements;
    private JavaCopyProcessor fCopyProcessor;
    private int fCanCopyElements;
    private ISelection fSelection;
    private static final long DROP_TIME_DIFF_TRESHOLD = 150L;

    public SelectionTransferDropAdapter(StructuredViewer viewer) {
        super(viewer, 24);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof IJavaScriptElement || target instanceof IResource;
    }

    @Override
    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    @Override
    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.fElements = null;
        this.fSelection = null;
        this.fMoveProcessor = null;
        this.fCanMoveElements = 0;
        this.fCopyProcessor = null;
        this.fCanCopyElements = 0;
    }

    @Override
    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        if (this.tooFast(event)) {
            return;
        }
        this.initializeSelection();
        try {
            switch (operation) {
                case 16: {
                    event.detail = this.handleValidateDefault(target, event);
                    break;
                }
                case 1: {
                    event.detail = this.handleValidateCopy(target, event);
                    break;
                }
                case 2: {
                    event.detail = this.handleValidateMove(target, event);
                }
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
            event.detail = 0;
        }
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        this.fSelection = s;
        this.fElements = ((IStructuredSelection)s).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    private boolean tooFast(DropTargetEvent event) {
        return Math.abs(LocalSelectionTransfer.getInstance().getSelectionSetTime() - ((long)event.time & 0xFFFFFFFFL)) < 150L;
    }

    /*
     * Loose catch block
     */
    @Override
    public void drop(Object target, DropTargetEvent event) {
        block13: {
            try {
                try {
                    switch (event.detail) {
                        case 2: {
                            this.handleDropMove(target, event);
                            break;
                        }
                        case 1: {
                            this.handleDropCopy(target, event);
                        }
                    }
                }
                catch (JavaScriptModelException e) {
                    ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
                    event.detail = 0;
                }
                catch (InvocationTargetException e) {
                    ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
                    event.detail = 0;
                }
                catch (InterruptedException interruptedException) {
                    event.detail = 0;
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                event.detail = 0;
            }
        }
    }

    private int handleValidateDefault(Object target, DropTargetEvent event) throws JavaScriptModelException {
        if (target == null) {
            return 0;
        }
        if ((event.operations & 2) != 0) {
            return this.handleValidateMove(target, event);
        }
        if ((event.operations & 1) != 0) {
            return this.handleValidateCopy(target, event);
        }
        return 0;
    }

    private int handleValidateMove(Object target, DropTargetEvent event) throws JavaScriptModelException {
        IReorgPolicy.IMovePolicy policy;
        if (target == null) {
            return 0;
        }
        if (this.fMoveProcessor == null && (policy = ReorgPolicyFactory.createMovePolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getJavaElements(this.fElements))).canEnable()) {
            this.fMoveProcessor = new JavaMoveProcessor(policy);
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        if (target instanceof IResource && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IResource)target).isOK()) {
            return 2;
        }
        if (target instanceof IJavaScriptElement && this.fMoveProcessor != null && this.fMoveProcessor.setDestination((IJavaScriptElement)target).isOK()) {
            return 2;
        }
        return 0;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (this.fMoveProcessor == null) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private void handleDropMove(Object target, DropTargetEvent event) throws JavaScriptModelException, InvocationTargetException, InterruptedException {
        IJavaScriptElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
        IResource[] resources = ReorgUtils.getResources(this.fElements);
        ReorgMoveStarter starter = null;
        if (target instanceof IResource) {
            starter = ReorgMoveStarter.create(javaElements, resources, (IResource)target);
        } else if (target instanceof IJavaScriptElement) {
            starter = ReorgMoveStarter.create(javaElements, resources, (IJavaScriptElement)target);
        }
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private int handleValidateCopy(Object target, DropTargetEvent event) throws JavaScriptModelException {
        if (this.fCopyProcessor == null) {
            IReorgPolicy.ICopyPolicy policy = ReorgPolicyFactory.createCopyPolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getJavaElements(this.fElements));
            JavaCopyProcessor javaCopyProcessor = this.fCopyProcessor = policy.canEnable() ? new JavaCopyProcessor(policy) : null;
        }
        if (!this.canCopyElements()) {
            return 0;
        }
        if (target instanceof IResource && this.fCopyProcessor != null && this.fCopyProcessor.setDestination((IResource)target).isOK()) {
            return 1;
        }
        if (target instanceof IJavaScriptElement && this.fCopyProcessor != null && this.fCopyProcessor.setDestination((IJavaScriptElement)target).isOK()) {
            return 1;
        }
        return 0;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (this.fCopyProcessor == null) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private void handleDropCopy(Object target, DropTargetEvent event) throws JavaScriptModelException, InvocationTargetException, InterruptedException {
        IJavaScriptElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
        IResource[] resources = ReorgUtils.getResources(this.fElements);
        ReorgCopyStarter starter = null;
        if (target instanceof IResource) {
            starter = ReorgCopyStarter.create(javaElements, resources, (IResource)target);
        } else if (target instanceof IJavaScriptElement) {
            starter = ReorgCopyStarter.create(javaElements, resources, (IJavaScriptElement)target);
        }
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

