/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementMatch;
import org.eclipse.wst.jsdt.internal.ui.search.JavaMatchFilter;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.PatternQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

class ImportFilter
extends JavaMatchFilter {
    ImportFilter() {
    }

    @Override
    public boolean filters(JavaElementMatch match) {
        return match.getElement() instanceof IImportDeclaration;
    }

    public String getName() {
        return SearchMessages.MatchFilter_ImportFilter_name;
    }

    public String getActionLabel() {
        return SearchMessages.MatchFilter_ImportFilter_actionLabel;
    }

    public String getDescription() {
        return SearchMessages.MatchFilter_ImportFilter_description;
    }

    @Override
    public boolean isApplicable(JavaSearchQuery query) {
        QuerySpecification spec = query.getSpecification();
        if (spec instanceof ElementQuerySpecification) {
            ElementQuerySpecification elementSpec = (ElementQuerySpecification)spec;
            IJavaScriptElement element = elementSpec.getElement();
            return element instanceof IType || element instanceof IPackageFragment;
        }
        if (spec instanceof PatternQuerySpecification) {
            PatternQuerySpecification patternSpec = (PatternQuerySpecification)spec;
            int searchFor = patternSpec.getSearchFor();
            return searchFor == 0 || searchFor == 2;
        }
        return false;
    }

    public String getID() {
        return "filter_imports";
    }
}

