/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.timers;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.AbstractRosStateProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.timers.RosTimersAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RosTimersStateProvider
extends AbstractRosStateProvider {
    private static int VERSION_NUMBER = 0;

    public RosTimersStateProvider(ITmfTrace trace) {
        super(trace, RosTimersAnalysis.getFullAnalysisId());
    }

    @Override
    public int getVersion() {
        return VERSION_NUMBER;
    }

    @Override
    protected void eventHandle(@NonNull ITmfEvent event) {
        super.eventHandle(event);
        if (!RosTimersStateProvider.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        try {
            if (RosTimersStateProvider.isEvent(event, this.fLayout.eventTimerAdded())) {
                long timestamp = event.getTimestamp().toNanos();
                String nodeName = this.getNodeName(event);
                String callbackRef = RosTimersStateProvider.formatLongDecToHex((Long)RosTimersStateProvider.getField(event, this.fLayout.fieldCallbackRef()));
                int timerCallbackRefQuark = ss.getQuarkAbsoluteAndAdd(new String[]{nodeName, callbackRef});
                Long timerPeriodNs = this.getTimerPeriodInNs(event);
                ss.modifyAttribute(timestamp, (Object)timerPeriodNs, timerCallbackRefQuark);
                return;
            }
            if (RosTimersStateProvider.isEvent(event, this.fLayout.eventTimerScheduled())) {
                long timestamp = event.getTimestamp().toNanos();
                String nodeName = this.getNodeName(event);
                String callbackRef = RosTimersStateProvider.formatLongDecToHex((Long)RosTimersStateProvider.getField(event, this.fLayout.fieldCallbackRef()));
                Long callbackQueueCbRef = (Long)RosTimersStateProvider.getField(event, this.fLayout.fieldCallbackQueueCbRef());
                int timerCallbackRefQuark = ss.getQuarkAbsolute(new String[]{nodeName, callbackRef});
                int timerScheduledQuark = ss.getQuarkRelativeAndAdd(timerCallbackRefQuark, new String[]{"scheduled"});
                ss.pushAttribute(timestamp, (Object)callbackQueueCbRef, timerScheduledQuark);
                return;
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getInstance().logError("Could not get timer callback quark; there may be missing events: ", (Throwable)e);
        }
    }
}

