/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.virtual.resources;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.DefaultEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.IVirtualMachineEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.IVirtualEnvironmentModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.virtual.resources.handlers.QemuKvmEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.virtual.resources.handlers.SchedSwitchEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class VirtualResourcesStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 1;
    private final IVirtualEnvironmentModel fModel;
    private final Multimap<String, IVirtualMachineEventHandler> fEventNames = HashMultimap.create();
    private final Collection<IVirtualMachineEventHandler> fHandlers;
    private final Map<ITmfTrace, IKernelAnalysisEventLayout> fLayouts;

    public VirtualResourcesStateProvider(TmfExperiment experiment, IVirtualEnvironmentModel model) {
        super((ITmfTrace)experiment, "Virtual Machine State Provider");
        this.fModel = model;
        this.fLayouts = new HashMap<ITmfTrace, IKernelAnalysisEventLayout>();
        this.fHandlers = ImmutableSet.of((Object)new SchedSwitchEventHandler(), (Object)new QemuKvmEventHandler());
    }

    private void buildEventNames(ITmfTrace trace) {
        Object layout = trace instanceof IKernelTrace ? ((IKernelTrace)trace).getKernelEventLayout() : DefaultEventLayout.getInstance();
        this.fLayouts.put(trace, (IKernelAnalysisEventLayout)layout);
        this.fHandlers.forEach(arg_0 -> this.lambda$0((IKernelAnalysisEventLayout)layout, arg_0));
    }

    public TmfExperiment getTrace() {
        ITmfTrace trace = super.getTrace();
        if (trace instanceof TmfExperiment) {
            return (TmfExperiment)trace;
        }
        throw new IllegalStateException("VirtualMachineStateProvider: The associated trace should be an experiment");
    }

    public int getVersion() {
        return 1;
    }

    public VirtualResourcesStateProvider getNewInstance() {
        TmfExperiment trace = this.getTrace();
        return new VirtualResourcesStateProvider(trace, this.fModel);
    }

    protected void eventHandle(@Nullable ITmfEvent event) {
        if (event == null) {
            return;
        }
        String eventName = event.getName();
        IKernelAnalysisEventLayout eventLayout = this.fLayouts.get(event.getTrace());
        if (eventLayout == null) {
            this.buildEventNames(event.getTrace());
            eventLayout = this.fLayouts.get(event.getTrace());
            if (eventLayout == null) {
                return;
            }
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        Collection handlers = this.fEventNames.get((Object)eventName);
        if (handlers.isEmpty()) {
            return;
        }
        IVirtualEnvironmentModel virtEnv = this.fModel;
        for (IVirtualMachineEventHandler handler : handlers) {
            handler.handleEvent(ss, event, virtEnv, eventLayout);
        }
    }

    private /* synthetic */ void lambda$0(IKernelAnalysisEventLayout iKernelAnalysisEventLayout, IVirtualMachineEventHandler handler) {
        handler.getRequiredEvents(iKernelAnalysisEventLayout).forEach(event -> this.fEventNames.put(event, (Object)handler));
    }
}

