/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.AbstractBreakpointOrganizerDelegate;
import org.eclipse.debug.ui.BreakpointTypeCategory;

public class BreakpointEnablement
extends AbstractBreakpointOrganizerDelegate
implements IBreakpointsListener {
    private final BreakpointTypeCategory ENABLED = new BreakpointTypeCategory("Enabled", 0);
    private final BreakpointTypeCategory DISABLED = new BreakpointTypeCategory("Disabled", 1);
    private final Map<IBreakpoint, Boolean> breakpointCache;

    public BreakpointEnablement() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        this.breakpointCache = Collections.synchronizedMap(new WeakHashMap());
    }

    @Override
    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        this.breakpointCache.clear();
    }

    @Override
    public IAdaptable[] getCategories(IBreakpoint breakpoint) {
        try {
            IAdaptable[] categories = breakpoint.isEnabled() ? new IAdaptable[]{this.ENABLED} : new IAdaptable[]{this.DISABLED};
            this.breakpointCache.put(breakpoint, breakpoint.isEnabled());
            return categories;
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
            return null;
        }
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            try {
                this.breakpointCache.put(breakpoint, breakpoint.isEnabled());
            }
            catch (CoreException e) {
                DebugPlugin.log((Throwable)e);
            }
            ++n2;
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            this.breakpointCache.remove(breakpoint);
            ++n2;
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        boolean updateCategories = false;
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            try {
                boolean isEnabled = breakpoint.isEnabled();
                Boolean wasEnabled = this.breakpointCache.get(breakpoint);
                if (wasEnabled == null || wasEnabled != isEnabled) {
                    this.breakpointCache.put(breakpoint, isEnabled);
                    updateCategories = true;
                }
            }
            catch (CoreException e) {
                DebugPlugin.log((Throwable)e);
            }
            ++n2;
        }
        if (updateCategories) {
            this.fireCategoryChanged(this.ENABLED);
        }
    }
}

