/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.events.AboutToBeChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.IModelAboutToBeChangedListener;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Debug;
import org.eclipse.wst.xml.core.internal.IDebugAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class EveryNodeDebugAdapter
implements IDebugAdapter {
    private static EveryNodeDebugAdapter singletonInstance;
    InternalDocumentListener fInternalDocumentListener = new InternalDocumentListener();
    InternalModelStateListener fInternalModelStateListener;
    InternalStructuredDocumentAboutToChange fInternalStructuredDocumentAboutToChange = new InternalStructuredDocumentAboutToChange();
    InternalStructuredDocumentListener fInternalStructuredDocumentListener = new InternalStructuredDocumentListener();
    IStructuredModel fModel;

    public static EveryNodeDebugAdapter getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new EveryNodeDebugAdapter();
        }
        return singletonInstance;
    }

    public EveryNodeDebugAdapter() {
        this.fInternalModelStateListener = new InternalModelStateListener();
    }

    public EveryNodeDebugAdapter(INodeNotifier target) {
        this();
    }

    public boolean isAdapterForType(Object type) {
        return type == IDebugAdapter.class;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier instanceof IDOMNode) {
            this.setModel(((IDOMNode)notifier).getModel());
        }
        Debug.println((String)("notifier: " + String.valueOf(notifier) + " " + INodeNotifier.EVENT_TYPE_STRINGS[eventType] + " changedFeature: " + String.valueOf(changedFeature) + " oldValue: " + String.valueOf(oldValue) + " newValue: " + String.valueOf(newValue) + " pos: " + pos));
    }

    private void setModel(IStructuredModel structuredModel) {
        IStructuredDocument structuredDocument;
        if (this.fModel == structuredModel) {
            return;
        }
        if (this.fModel != null) {
            this.fModel.removeModelStateListener((IModelStateListener)this.fInternalModelStateListener);
            structuredDocument = this.fModel.getStructuredDocument();
            if (structuredDocument != null) {
                structuredDocument.removeDocumentListener((IDocumentListener)this.fInternalDocumentListener);
                structuredDocument.removeDocumentAboutToChangeListener((IModelAboutToBeChangedListener)this.fInternalStructuredDocumentAboutToChange);
                structuredDocument.removeDocumentChangedListener((IStructuredDocumentListener)this.fInternalStructuredDocumentListener);
            }
        }
        this.fModel = structuredModel;
        if (this.fModel != null) {
            this.fModel.addModelStateListener((IModelStateListener)this.fInternalModelStateListener);
            structuredDocument = this.fModel.getStructuredDocument();
            if (structuredDocument != null) {
                structuredDocument.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
                structuredDocument.addDocumentAboutToChangeListener((IModelAboutToBeChangedListener)this.fInternalStructuredDocumentAboutToChange);
                structuredDocument.addDocumentChangedListener((IStructuredDocumentListener)this.fInternalStructuredDocumentListener);
            }
        }
    }

    static class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            Debug.println((String)("IdocumentAboutToBeChanged: " + String.valueOf(event)));
        }

        public void documentChanged(DocumentEvent event) {
            Debug.println((String)("IdocumentChanged: " + String.valueOf(event)));
        }
    }

    static class InternalModelStateListener
    implements IModelStateListener {
        InternalModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
            Debug.println((String)("modelAboutToBeChanged: " + String.valueOf(model)));
        }

        public void modelChanged(IStructuredModel model) {
            Debug.println((String)("modelChanged: " + String.valueOf(model)));
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
            Debug.println((String)("modelDirtyStateChanged: " + String.valueOf(model)));
        }

        public void modelResourceDeleted(IStructuredModel model) {
            Debug.println((String)("modelResourceDeleted: " + String.valueOf(model)));
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
            Debug.println((String)("modelResourceMoved: oldModel: " + String.valueOf(oldModel) + "newModel: " + String.valueOf(newModel)));
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
            Debug.println((String)("modelAboutToBeReinitialized: structuredModel: " + String.valueOf(structuredModel)));
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
            Debug.println((String)("modelReinitialized: structuredModel: " + String.valueOf(structuredModel)));
        }
    }

    static class InternalStructuredDocumentAboutToChange
    implements IModelAboutToBeChangedListener {
        InternalStructuredDocumentAboutToChange() {
        }

        public void modelAboutToBeChanged(AboutToBeChangedEvent structuredDocumentEvent) {
            Debug.println((String)("structuredDocumentAboutToBeChanged: " + String.valueOf(structuredDocumentEvent)));
        }
    }

    static class InternalStructuredDocumentListener
    implements IStructuredDocumentListener {
        InternalStructuredDocumentListener() {
        }

        public void newModel(NewDocumentEvent structuredDocumentEvent) {
            Debug.println((String)("structuredDocumentChanged - newModel: " + String.valueOf(structuredDocumentEvent)));
        }

        public void noChange(NoChangeEvent structuredDocumentEvent) {
            Debug.println((String)("structuredDocumentChanged - noChange: " + String.valueOf(structuredDocumentEvent)));
        }

        public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
            Debug.println((String)("structuredDocumentChanged - nodesReplaced: " + String.valueOf(structuredDocumentEvent)));
        }

        public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
            Debug.println((String)("structuredDocumentChanged - regionChanged: " + String.valueOf(structuredDocumentEvent)));
        }

        public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
            Debug.println((String)("structuredDocumentChanged - regionsReplaced: " + String.valueOf(structuredDocumentEvent)));
        }
    }
}

