/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderCompactDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderLargeDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventHeaderDeclarationTest {
    private static final int ID = 2222;
    private static final int TIMESTAMP = 1000;
    private static final int VALID_LARGE = 1;
    private static final int VALID_COMPACT = 0;
    private final List<StructDeclaration> declarations = new ArrayList<StructDeclaration>();

    @Before
    public void init() {
        this.declarations.clear();
        StructDeclaration base = new StructDeclaration(8L);
        EnumDeclaration enumDec = new EnumDeclaration(IntegerDeclaration.createDeclaration((int)5, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)1L, null));
        enumDec.add(0L, 30L, "compact");
        enumDec.add(31L, 31L, "extended");
        base.addField("id", (IDeclaration)enumDec);
        VariantDeclaration variantV = new VariantDeclaration();
        StructDeclaration compact = new StructDeclaration(1L);
        compact.addField("timestamp", (IDeclaration)IntegerDeclaration.createDeclaration((int)27, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)1L, null));
        variantV.addField("compact", (IDeclaration)compact);
        StructDeclaration large = new StructDeclaration(1L);
        large.addField("id", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        large.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_64B_DECL);
        variantV.addField("extended", (IDeclaration)large);
        base.addField("v", (IDeclaration)variantV);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        enumDec = new EnumDeclaration(IntegerDeclaration.createDeclaration((int)16, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)1L, null));
        enumDec.add(0L, 65534L, "compact");
        enumDec.add(65535L, 65535L, "extended");
        base.addField("id", (IDeclaration)enumDec);
        variantV = new VariantDeclaration();
        compact = new StructDeclaration(8L);
        compact.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        variantV.addField("compact", (IDeclaration)compact);
        large = new StructDeclaration(8L);
        large.addField("id", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        large.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_64B_DECL);
        variantV.addField("extended", (IDeclaration)large);
        base.addField("v", (IDeclaration)variantV);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        enumDec = new EnumDeclaration(IntegerDeclaration.createDeclaration((int)5, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)1L, null));
        enumDec.add(0L, 30L, "compact");
        enumDec.add(31L, 31L, "large");
        base.addField("id", (IDeclaration)enumDec);
        variantV = new VariantDeclaration();
        compact = new StructDeclaration(1L);
        compact.addField("timestamp", (IDeclaration)IntegerDeclaration.createDeclaration((int)27, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)1L, null));
        variantV.addField("compact", (IDeclaration)compact);
        large = new StructDeclaration(1L);
        large.addField("id", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        large.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_64B_DECL);
        variantV.addField("extended", (IDeclaration)large);
        base.addField("v", (IDeclaration)variantV);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        enumDec = new EnumDeclaration(IntegerDeclaration.createDeclaration((int)5, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)1L, null));
        enumDec.add(0L, 30L, "compact");
        base.addField("id", (IDeclaration)enumDec);
        variantV = new VariantDeclaration();
        compact = new StructDeclaration(1L);
        compact.addField("timestamp", (IDeclaration)IntegerDeclaration.createDeclaration((int)27, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)1L, null));
        variantV.addField("compact", (IDeclaration)compact);
        large = new StructDeclaration(1L);
        large.addField("id", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        large.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_64B_DECL);
        variantV.addField("extended", (IDeclaration)large);
        base.addField("v", (IDeclaration)variantV);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        enumDec = new EnumDeclaration(IntegerDeclaration.createDeclaration((int)5, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)8L, null));
        enumDec.add(0L, 30L, "compact");
        enumDec.add(31L, 31L, "extended");
        base.addField("id", (IDeclaration)enumDec);
        variantV = new VariantDeclaration();
        compact = new StructDeclaration(1L);
        compact.addField("timestamp", (IDeclaration)IntegerDeclaration.createDeclaration((int)27, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)1L, null));
        variantV.addField("compact", (IDeclaration)compact);
        large = new StructDeclaration(1L);
        large.addField("id", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        large.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_64B_DECL);
        variantV.addField("extended", (IDeclaration)large);
        base.addField("v", (IDeclaration)variantV);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("potato salad", (IDeclaration)new FloatDeclaration(8, 8, ByteOrder.BIG_ENDIAN, 8L));
        base.addField("bbq ribs", (IDeclaration)new FloatDeclaration(8, 8, ByteOrder.BIG_ENDIAN, 8L));
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("id", (IDeclaration)new EnumDeclaration(IntegerDeclaration.UINT_16B_DECL));
        base.addField("v", (IDeclaration)new FloatDeclaration(8, 8, ByteOrder.BIG_ENDIAN, 8L));
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("id", (IDeclaration)new EnumDeclaration(IntegerDeclaration.UINT_5B_DECL));
        base.addField("v", (IDeclaration)new FloatDeclaration(8, 8, ByteOrder.BIG_ENDIAN, 8L));
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("id", (IDeclaration)new EnumDeclaration(IntegerDeclaration.UINT_5B_DECL));
        variantV = new VariantDeclaration();
        compact = new StructDeclaration(8L);
        compact.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_27B_DECL);
        variantV.addField("compact1", (IDeclaration)compact);
        large = new StructDeclaration(8L);
        large.addField("id", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        large.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_64B_DECL);
        variantV.addField("extended", (IDeclaration)large);
        base.addField("v", (IDeclaration)variantV);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("id", (IDeclaration)new EnumDeclaration(IntegerDeclaration.UINT_5B_DECL));
        variantV = new VariantDeclaration();
        compact = new StructDeclaration(8L);
        compact.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_27B_DECL);
        variantV.addField("compact", (IDeclaration)compact);
        large = new StructDeclaration(8L);
        large.addField("id", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        large.addField("timestamp1", (IDeclaration)IntegerDeclaration.UINT_64B_DECL);
        variantV.addField("extended", (IDeclaration)large);
        base.addField("v", (IDeclaration)variantV);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("id", (IDeclaration)new EnumDeclaration(IntegerDeclaration.UINT_5B_DECL));
        variantV = new VariantDeclaration();
        compact = new StructDeclaration(8L);
        compact.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_27B_DECL);
        variantV.addField("compact", (IDeclaration)compact);
        large = new StructDeclaration(8L);
        large.addField("id", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        large.addField("timestamp", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        variantV.addField("extended", (IDeclaration)large);
        base.addField("v", (IDeclaration)variantV);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("id", (IDeclaration)new EnumDeclaration(IntegerDeclaration.UINT_5B_DECL));
        variantV = new VariantDeclaration();
        compact = new StructDeclaration(8L);
        compact.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_27B_DECL);
        variantV.addField("compact", (IDeclaration)compact);
        variantV.addField("surprise!", (IDeclaration)compact);
        large = new StructDeclaration(8L);
        large.addField("id", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        large.addField("timestamp", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        variantV.addField("extended", (IDeclaration)large);
        base.addField("v", (IDeclaration)variantV);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("id", (IDeclaration)new EnumDeclaration(IntegerDeclaration.UINT_16B_DECL));
        variantV = new VariantDeclaration();
        compact = new StructDeclaration(8L);
        compact.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_27B_DECL);
        variantV.addField("compact", (IDeclaration)compact);
        variantV.addField("surprise!", (IDeclaration)compact);
        large = new StructDeclaration(8L);
        large.addField("id", (IDeclaration)IntegerDeclaration.UINT_32B_DECL);
        large.addField("timestamp", (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        variantV.addField("extended", (IDeclaration)large);
        base.addField("v", (IDeclaration)variantV);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("id", (IDeclaration)new FloatDeclaration(8, 8, ByteOrder.BIG_ENDIAN, 8L));
        base.addField("v", (IDeclaration)new FloatDeclaration(8, 8, ByteOrder.BIG_ENDIAN, 8L));
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("id", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        base.addField("timestamp", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        this.declarations.add(base);
        base = new StructDeclaration(8L);
        base.addField("id", (IDeclaration)new EnumDeclaration(IntegerDeclaration.INT_8_DECL));
        base.addField("timestamp", (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        this.declarations.add(base);
    }

    @Test
    public void validateCompact() {
        Assert.assertEquals((Object)true, (Object)EventHeaderCompactDeclaration.getEventHeader((ByteOrder)ByteOrder.BIG_ENDIAN).isCompactEventHeader(this.declarations.get(0)));
    }

    @Test
    public void validateCompactFail() {
        int i = 0;
        while (i < this.declarations.size()) {
            if (i != 0) {
                Assert.assertEquals((Object)false, (Object)EventHeaderCompactDeclaration.getEventHeader((ByteOrder)ByteOrder.BIG_ENDIAN).isCompactEventHeader(this.declarations.get(i)));
            }
            ++i;
        }
    }

    @Test
    public void validateLarge() {
        Assert.assertEquals((Object)true, (Object)EventHeaderLargeDeclaration.getEventHeader((ByteOrder)ByteOrder.BIG_ENDIAN).isLargeEventHeader(this.declarations.get(1)));
    }

    @Test
    public void validateLargeFail() {
        int i = 0;
        while (i < this.declarations.size()) {
            if (i != 1) {
                Assert.assertEquals((Object)false, (Object)EventHeaderLargeDeclaration.getEventHeader((ByteOrder)ByteOrder.BIG_ENDIAN).isLargeEventHeader(this.declarations.get(i)));
            }
            ++i;
        }
    }

    @Test
    public void testCompactCompact() throws CTFException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putInt(-2147483582);
        byte[] validCompact1 = buffer.array();
        EventHeaderCompactDeclaration decl = EventHeaderCompactDeclaration.getEventHeader((ByteOrder)ByteOrder.BIG_ENDIAN);
        ByteBuffer input = ByteBuffer.wrap(validCompact1);
        Assert.assertNotNull((Object)input);
        EventHeaderDefinition def = decl.createDefinition(null, "bla", new BitBuffer(input));
        Assert.assertNotNull((Object)def);
        Assert.assertEquals((long)16L, (long)def.getId());
        Assert.assertEquals((long)66L, (long)def.getTimestamp());
    }

    @Test
    public void testCompactExtended() throws CTFException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.put((byte)-1);
        buffer.putInt(2222);
        buffer.putLong(1000L);
        byte[] validCompact2 = buffer.array();
        EventHeaderCompactDeclaration decl = EventHeaderCompactDeclaration.getEventHeader((ByteOrder)ByteOrder.BIG_ENDIAN);
        ByteBuffer input = ByteBuffer.wrap(validCompact2);
        Assert.assertNotNull((Object)input);
        EventHeaderDefinition def = decl.createDefinition(null, "bla", new BitBuffer(input));
        Assert.assertNotNull((Object)def);
        Assert.assertEquals((long)2222L, (long)def.getId());
        Assert.assertEquals((long)1000L, (long)def.getTimestamp());
    }

    @Test
    public void testLargeCompact() throws CTFException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putShort((short)2222);
        buffer.putInt(1000);
        byte[] validLarge1 = buffer.array();
        EventHeaderLargeDeclaration decl = EventHeaderLargeDeclaration.getEventHeader((ByteOrder)ByteOrder.BIG_ENDIAN);
        ByteBuffer input = ByteBuffer.wrap(validLarge1);
        Assert.assertNotNull((Object)input);
        EventHeaderDefinition def = decl.createDefinition(null, "bla", new BitBuffer(input));
        Assert.assertNotNull((Object)def);
        Assert.assertEquals((long)2222L, (long)def.getId());
        Assert.assertEquals((long)1000L, (long)def.getTimestamp());
        Assert.assertEquals((long)2222L, (long)((IntegerDefinition)def.getDefinition("id")).getValue());
        Assert.assertEquals((long)1000L, (long)((IntegerDefinition)def.getDefinition("timestamp")).getValue());
    }

    @Test
    public void testLargeExtended() throws CTFException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putShort((short)-1);
        buffer.putInt(2222);
        buffer.putLong(1000L);
        byte[] validLarge2 = buffer.array();
        EventHeaderLargeDeclaration decl = EventHeaderLargeDeclaration.getEventHeader((ByteOrder)ByteOrder.BIG_ENDIAN);
        ByteBuffer input = ByteBuffer.wrap(validLarge2);
        Assert.assertNotNull((Object)input);
        EventHeaderDefinition def = decl.createDefinition(null, "bla", new BitBuffer(input));
        Assert.assertNotNull((Object)def);
        Assert.assertEquals((long)2222L, (long)def.getId());
        Assert.assertEquals((long)1000L, (long)def.getTimestamp());
        Assert.assertEquals((long)2222L, (long)((IntegerDefinition)def.getDefinition("id")).getValue());
        Assert.assertEquals((long)1000L, (long)((IntegerDefinition)def.getDefinition("timestamp")).getValue());
    }

    @Test
    public void testMaxSizes() {
        Assert.assertEquals((long)112L, (long)EventHeaderLargeDeclaration.getEventHeader((ByteOrder)ByteOrder.BIG_ENDIAN).getMaximumSize());
        Assert.assertEquals((long)104L, (long)EventHeaderCompactDeclaration.getEventHeader((ByteOrder)ByteOrder.BIG_ENDIAN).getMaximumSize());
    }
}

