/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.event;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ArrayDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.SequenceDeclaration;
import org.junit.Assert;
import org.junit.Test;

public class CTFEventFieldTest {
    private static final @NonNull String FIELD_NAME = "id";

    @Test
    public void testParseField_complex() throws CTFException {
        int len = 32;
        IntegerDeclaration id = IntegerDeclaration.createDeclaration((int)len, (boolean)false, (int)len, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)len, null);
        String lengthName = "LengthName";
        StructDeclaration structDec = new StructDeclaration(0L);
        structDec.addField(lengthName, (IDeclaration)id);
        StructDefinition structDef = new StructDefinition(structDec, null, lengthName, new Definition[]{new IntegerDefinition(id, null, lengthName, 32L)});
        SequenceDeclaration sd = new SequenceDeclaration(lengthName, (IDeclaration)id);
        ByteBuffer byb = CTFEventFieldTest.testMemory(ByteBuffer.allocate(1024));
        int i = 0;
        while (i < 1024) {
            byb.put((byte)i);
            ++i;
        }
        BitBuffer bb = new BitBuffer(byb);
        AbstractArrayDefinition fieldDef = sd.createDefinition((IDefinitionScope)structDef, "fff-fffield", bb);
        Assert.assertNotNull((Object)fieldDef);
    }

    private static @NonNull ByteBuffer testMemory(ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Failed to allocate memory");
        }
        return buffer;
    }

    @Test
    public void testParseField_simple() throws CTFException {
        StringDeclaration elemType = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        byte[] byArray = new byte[5];
        byArray[0] = 84;
        byArray[1] = 101;
        byArray[2] = 115;
        byArray[3] = 116;
        byte[] bytes = byArray;
        ByteBuffer bb = CTFEventFieldTest.testMemory(ByteBuffer.wrap(bytes));
        StringDefinition fieldDef = elemType.createDefinition(null, FIELD_NAME, new BitBuffer(bb));
        Assert.assertNotNull((Object)fieldDef);
        Assert.assertEquals((Object)"\"Test\"", (Object)fieldDef.toString());
    }

    @Test
    public void testParseField_fixedLengthString() throws CTFException {
        IntegerDeclaration charDeclaration = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)16, (ByteOrder)ByteOrder.nativeOrder(), (Encoding)Encoding.ASCII, (String)"inner", (long)8L, null);
        int length = 128;
        ArrayDeclaration elemType = new ArrayDeclaration(length, (IDeclaration)charDeclaration);
        byte[] bytes = new byte[length];
        bytes[0] = 84;
        bytes[1] = 101;
        bytes[2] = 115;
        bytes[3] = 116;
        ByteBuffer bb = CTFEventFieldTest.testMemory(ByteBuffer.wrap(bytes));
        AbstractArrayDefinition fieldDef = elemType.createDefinition(null, FIELD_NAME, new BitBuffer(bb));
        Assert.assertNotNull((Object)fieldDef);
        Assert.assertEquals((Object)"Test", (Object)fieldDef.toString());
    }

    @Test
    public void testParseField_fixedLengthArray() throws CTFException {
        IntegerDeclaration charDeclaration = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)10, (ByteOrder)ByteOrder.nativeOrder(), (Encoding)Encoding.NONE, (String)"inner", (long)8L, null);
        int length = 128;
        ArrayDeclaration elemType = new ArrayDeclaration(length, (IDeclaration)charDeclaration);
        byte[] bytes = new byte[length];
        bytes[0] = 84;
        bytes[1] = 101;
        bytes[2] = 115;
        bytes[3] = 116;
        ByteBuffer bb = CTFEventFieldTest.testMemory(ByteBuffer.wrap(bytes));
        AbstractArrayDefinition fieldDef = elemType.createDefinition(null, FIELD_NAME, new BitBuffer(bb));
        Assert.assertNotNull((Object)fieldDef);
        String eventString = fieldDef.toString();
        Assert.assertNotEquals((String)"Non string array read as a string", (Object)"Test", (Object)eventString);
        Assert.assertTrue((String)("String should start with \"[84, 101, 115, 116,\" " + eventString), (boolean)eventString.startsWith("[84, 101, 115, 116,"));
    }

    @Test
    public void testParseField_fixedLengthNotNullTerminatedArray() throws CTFException {
        IntegerDeclaration charDeclaration = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)10, (ByteOrder)ByteOrder.nativeOrder(), (Encoding)Encoding.ASCII, (String)"inner", (long)1L, null);
        int length = 6;
        ArrayDeclaration elemType = new ArrayDeclaration(length, (IDeclaration)charDeclaration);
        byte[] bytes = new byte[length];
        bytes[0] = 84;
        bytes[1] = 101;
        bytes[2] = 115;
        bytes[3] = 116;
        bytes[4] = 68;
        bytes[5] = 101;
        ByteBuffer bb = CTFEventFieldTest.testMemory(ByteBuffer.wrap(bytes));
        AbstractArrayDefinition fieldDef = elemType.createDefinition(null, FIELD_NAME, new BitBuffer(bb));
        Assert.assertNotNull((Object)fieldDef);
        String eventString = fieldDef.toString();
        Assert.assertNotEquals((String)"Non string array read as a string", (Object)"Test", (Object)eventString);
        Assert.assertTrue((String)("String should start with \"Test\" " + eventString), (boolean)eventString.startsWith("Test"));
    }

    @Test
    public void testParseField_fixedHexLengthArray() throws CTFException {
        IntegerDeclaration charDeclaration = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)16, (ByteOrder)ByteOrder.nativeOrder(), (Encoding)Encoding.NONE, (String)"inner", (long)8L, null);
        int length = 128;
        ArrayDeclaration elemType = new ArrayDeclaration(length, (IDeclaration)charDeclaration);
        byte[] bytes = new byte[length];
        bytes[0] = 84;
        bytes[1] = 101;
        bytes[2] = 115;
        bytes[3] = 116;
        ByteBuffer bb = CTFEventFieldTest.testMemory(ByteBuffer.wrap(bytes));
        AbstractArrayDefinition fieldDef = elemType.createDefinition(null, FIELD_NAME, new BitBuffer(bb));
        Assert.assertNotNull((Object)fieldDef);
        String eventString = fieldDef.toString();
        Assert.assertNotEquals((String)"Non string array read as a string", (Object)"Test", (Object)eventString);
        Assert.assertTrue((String)("String should start with \"[0x54, 0x65, 0x73, 0x74,\" " + eventString), (boolean)eventString.startsWith("[0x54, 0x65, 0x73, 0x74,"));
    }

    @Test
    public void testParseField_simple2() {
        IntegerDefinition fieldDef = new IntegerDefinition(IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L, null), null, FIELD_NAME, 1L);
        Assert.assertNotNull((Object)fieldDef);
    }

    @Test
    public void testParseField_simple3() {
        StringDefinition fieldDef = new StringDefinition(StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8), null, FIELD_NAME, "Hello World");
        String other = "\"Hello World\"";
        Assert.assertNotNull((Object)fieldDef);
        Assert.assertEquals((Object)fieldDef.toString(), (Object)other);
    }
}

