/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.tracecompass.internal.datastore.core.condition.ArrayIntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.junit.Assert;
import org.junit.Test;

public class DiscreteIntegerRangeConditionTest {
    private static final int LOW = 0;
    private static final int HIGH = 10;
    private static final List<Integer> VALUES = Arrays.asList(0, 5, 10);
    private static final IntegerRangeCondition CONDITION = new ArrayIntegerRangeCondition(VALUES);

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor() {
        new ArrayIntegerRangeCondition(Collections.emptyList());
    }

    @Test
    public void testBounds() {
        Assert.assertEquals((long)0L, (long)CONDITION.min());
        Assert.assertEquals((long)10L, (long)CONDITION.max());
    }

    @Test
    public void testPredicate() {
        Assert.assertFalse((boolean)CONDITION.test(-5));
        for (Integer v : VALUES) {
            Assert.assertTrue((boolean)CONDITION.test(v.intValue()));
            Assert.assertFalse((boolean)CONDITION.test(v + 1));
        }
        Assert.assertFalse((boolean)CONDITION.test(15));
    }

    @Test
    public void testPredicateAndAdd() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(1);
        values.add(5);
        ArrayIntegerRangeCondition condition = new ArrayIntegerRangeCondition(values);
        Assert.assertFalse((boolean)condition.test(-5));
        for (Integer v : values) {
            Assert.assertTrue((boolean)condition.test(v.intValue()));
            Assert.assertFalse((boolean)condition.test(v + 1));
        }
        Assert.assertFalse((boolean)condition.test(15));
        values.add(15);
        Assert.assertFalse((boolean)condition.test(15));
    }

    @Test
    public void testIntersects() {
        Assert.assertFalse((boolean)CONDITION.intersects(Integer.MIN_VALUE, -1));
        Assert.assertTrue((boolean)CONDITION.intersects(0, 4));
        Assert.assertFalse((boolean)CONDITION.intersects(1, 4));
        Assert.assertTrue((boolean)CONDITION.intersects(2, 8));
        Assert.assertFalse((boolean)CONDITION.intersects(6, 9));
        Assert.assertTrue((boolean)CONDITION.intersects(5, 15));
        Assert.assertFalse((boolean)CONDITION.intersects(11, Integer.MAX_VALUE));
    }

    @Test
    public void testSubCondition() {
        IntegerRangeCondition sub = CONDITION.subCondition(-5, 8);
        Assert.assertNotNull((Object)sub);
        Assert.assertEquals(ArrayIntegerRangeCondition.class, sub.getClass());
        int low = sub.min();
        int high = sub.max();
        Assert.assertEquals((long)0L, (long)low);
        Assert.assertEquals((long)5L, (long)high);
        sub = CONDITION.subCondition(1, 4);
        Assert.assertNull((Object)sub);
        sub = CONDITION.subCondition(0, 5);
        Assert.assertNotNull((Object)sub);
        low = sub.min();
        high = sub.max();
        Assert.assertEquals((long)0L, (long)low);
        Assert.assertEquals((long)5L, (long)high);
    }
}

