/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.parser.IBuiltinBindingsProvider;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.c.CArrayType;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.c.CBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.c.CImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.c.CPointerType;
import org.eclipse.cdt.internal.core.dom.parser.c.CQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArrayType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecBuiltin;
import org.eclipse.core.runtime.PlatformObject;

public class GCCBuiltinSymbolProvider
implements IBuiltinBindingsProvider {
    public static final ASTNodeProperty BUILTIN_GCC_SYMBOL = new ASTNodeProperty("GCCBuiltinSymbolProvider.BUILTIN_GCC_SYMBOL - built-in GCC symbol");
    private static final Map<String, char[]> CHAR_ARRAYS = new HashMap<String, char[]>();
    private IBinding[] fBindings;
    private IScope fScope;
    private final boolean fCpp;
    private final boolean fGnu;
    private Map<String, IType> fTypeMap;
    private List<IBinding> fBindingList;
    private CharArraySet fKnownBuiltins = new CharArraySet(50);

    public GCCBuiltinSymbolProvider(ParserLanguage lang, boolean supportGnuSymbols) {
        this.fCpp = lang == ParserLanguage.CPP;
        this.fGnu = supportGnuSymbols;
    }

    @Override
    public IBinding[] getBuiltinBindings(IScope scope) {
        this.fScope = scope;
        this.initialize();
        return this.fBindings;
    }

    private void initialize() {
        this.fTypeMap = new HashMap<String, IType>();
        this.fBindingList = new ArrayList<IBinding>();
        this.addStdBuiltins();
        if (this.fGnu) {
            this.addGnuBuiltins();
        }
        IBinding[] iBindingArray = this.fBindings = this.fBindingList.toArray(new IBinding[this.fBindingList.size()]);
        int n = this.fBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            this.fKnownBuiltins.put(binding.getNameCharArray());
            ++n2;
        }
        this.fTypeMap = null;
        this.fBindingList = null;
    }

    private void addStdBuiltins() {
        this.variable("const char[1]", "__func__");
        this.variable("const char[1]", "__FUNCTION__");
        this.variable("const char[1]", "__PRETTY_FUNCTION__");
    }

    private void addGnuBuiltins() {
        String typePtr;
        String type;
        String[] types;
        this.typedef("__int128", "__int128_t");
        this.typedef("unsigned __int128", "__uint128_t");
        this.typedef("va_list", "__builtin_va_list");
        this.function("void*", "__builtin_va_start", "va_list", "...");
        this.function("void", "__builtin_va_end", "va_list");
        this.function("void", "__builtin_va_copy", "va_list", "va_list");
        this.function("void*", "__builtin_return_address", "unsigned int");
        this.function("void*", "__builtin_extract_return_address", "void*");
        this.function("void*", "__builtin_frob_return_address", "void*");
        this.function("void*", "__builtin_frame_address", "unsigned int");
        String[] stringArray = types = new String[]{"int", "long", "long long", "unsigned int", "unsigned long", "unsigned long long", "void*"};
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            typePtr = String.valueOf(type) + " volatile *";
            this.function(type, "__sync_fetch_and_add", typePtr, type, "...");
            this.function(type, "__sync_fetch_and_sub", typePtr, type, "...");
            this.function(type, "__sync_fetch_and_or", typePtr, type, "...");
            this.function(type, "__sync_fetch_and_and", typePtr, type, "...");
            this.function(type, "__sync_fetch_and_xor", typePtr, type, "...");
            this.function(type, "__sync_fetch_and_nand", typePtr, type, "...");
            this.function(type, "__sync_add_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_sub_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_or_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_and_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_xor_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_nand_and_fetch", typePtr, type, "...");
            this.function(type, "__sync_lock_test_and_set", typePtr, type, "...");
            this.function(type, "__sync_val_compare_and_swap", typePtr, type, type, "...");
            this.function("bool", "__sync_bool_compare_and_swap", typePtr, type, type, "...");
            this.function("void", "__sync_lock_release", typePtr, "...");
            ++n2;
        }
        this.function("void", "__sync_synchronize", new String[0]);
        stringArray = types;
        n = types.length;
        n2 = 0;
        while (n2 < n) {
            type = stringArray[n2];
            typePtr = String.valueOf(type) + " volatile *";
            this.function(type, "__atomic_load_n", typePtr, "int");
            this.function("void", "__atomic_load", typePtr, typePtr, "int");
            this.function("void", "__atomic_store_n", typePtr, type, "int");
            this.function("void", "__atomic_store", typePtr, typePtr, "int");
            this.function(type, "__atomic_exchange_n", typePtr, type, "int");
            this.function("void", "__atomic_exchange", typePtr, typePtr, typePtr, "int");
            this.function("bool", "__atomic_compare_exchange_n", typePtr, typePtr, type, "int", "int", "int");
            this.function("bool", "__atomic_compare_exchange", typePtr, typePtr, typePtr, "int", "int", "int");
            this.function(type, "__atomic_add_fetch", typePtr, type, "int");
            this.function(type, "__atomic_sub_fetch", typePtr, type, "int");
            this.function(type, "__atomic_and_fetch", typePtr, type, "int");
            this.function(type, "__atomic_xor_fetch", typePtr, type, "int");
            this.function(type, "__atomic_or_fetch", typePtr, type, "int");
            this.function(type, "__atomic_nadd_fetch", typePtr, type, "int");
            this.function(type, "__atomic_fetch_add", typePtr, type, "int");
            this.function(type, "__atomic_fetch_sub", typePtr, type, "int");
            this.function(type, "__atomic_fetch_and", typePtr, type, "int");
            this.function(type, "__atomic_fetch_xor", typePtr, type, "int");
            this.function(type, "__atomic_fetch_or", typePtr, type, "int");
            this.function(type, "__atomic_fetch_nadd", typePtr, type, "int");
            ++n2;
        }
        this.function("bool", "__atomic_test_and_set", "void*", "int");
        this.function("bool", "__atomic_test_and_set", "volatile void*", "int");
        this.function("void", "__atomic_clear", "bool*", "int");
        this.function("void", "__atomic_clear", "volatile bool*", "int");
        this.function("void", "__atomic_thread_fence", "int");
        this.function("void", "__atomic_signal_fence", "int");
        this.function("bool", "__atomic_always_lock_free", "size_t", "void*");
        this.function("bool", "__atomic_is_lock_free", "size_t", "void*");
        stringArray = new String[]{"add", "sub", "mul"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            this.function("bool", "__builtin_" + op + "_overflow", "", "", "void*");
            this.function("bool", "__builtin_" + op + "_overflow_p", "", "", "");
            this.function("bool", "__builtin_s" + op + "_overflow", "int", "int", "int*");
            this.function("bool", "__builtin_s" + op + "l_overflow", "long int", "long int", "long int*");
            this.function("bool", "__builtin_s" + op + "ll_overflow", "long long int", "long long int", "long long int*");
            this.function("bool", "__builtin_u" + op + "_overflow", "unsigned int", "unsigned int", "unsigned int*");
            this.function("bool", "__builtin_u" + op + "l_overflow", "unsigned long int", "unsigned long int", "unsigned long int*");
            this.function("bool", "__builtin_u" + op + "ll_overflow", "unsigned long long int", "unsigned long long int", "unsigned long long int*");
            ++n2;
        }
        ExecBuiltin builtinFfs = new ExecBuiltin(0);
        ExecBuiltin builtinFfsl = new ExecBuiltin(1);
        ExecBuiltin builtinFfsll = new ExecBuiltin(2);
        ExecBuiltin builtinCtz = new ExecBuiltin(3);
        ExecBuiltin builtinCtzl = new ExecBuiltin(4);
        ExecBuiltin builtinCtzll = new ExecBuiltin(5);
        ExecBuiltin builtinPopcount = new ExecBuiltin(6);
        ExecBuiltin builtinPopcountl = new ExecBuiltin(7);
        ExecBuiltin builtinPopcountll = new ExecBuiltin(8);
        ExecBuiltin builtinParity = new ExecBuiltin(9);
        ExecBuiltin builtinParityl = new ExecBuiltin(10);
        ExecBuiltin builtinParityll = new ExecBuiltin(11);
        ExecBuiltin builtinAbs = new ExecBuiltin(12);
        ExecBuiltin builtinLabs = new ExecBuiltin(13);
        ExecBuiltin builtinLlabs = new ExecBuiltin(14);
        ExecBuiltin builtinClrsb = new ExecBuiltin(15);
        ExecBuiltin builtinClrsbl = new ExecBuiltin(16);
        ExecBuiltin builtinClrsbll = new ExecBuiltin(17);
        ExecBuiltin builtinClz = new ExecBuiltin(18);
        ExecBuiltin builtinClzl = new ExecBuiltin(19);
        ExecBuiltin builtinClzll = new ExecBuiltin(20);
        this.function("void", "__builtin_abort", new String[0]);
        this.function("int", "__builtin_abs", builtinAbs, "int");
        this.function("double", "__builtin_acos", "double");
        this.function("float", "__builtin_acosf", "float");
        this.function("long double", "__builtin_acosl", "long double");
        this.function("double", "__builtin_acosh", "double");
        this.function("float", "__builtin_acoshf", "float");
        this.function("long double", "__builtin_acoshl", "long double");
        this.function("double", "__builtin_asin", "double");
        this.function("float", "__builtin_asinf", "float");
        this.function("long double", "__builtin_asinl", "long double");
        this.function("double", "__builtin_asinh", "double");
        this.function("float", "__builtin_asinhf", "float");
        this.function("long double", "__builtin_asinhl", "long double");
        this.function("void*", "__builtin_assume_aligned", "const void*", "size_t", "...");
        this.function("double", "__builtin_atan", "double");
        this.function("float", "__builtin_atanf", "float");
        this.function("long double", "__builtin_atanl", "long double");
        this.function("double", "__builtin_atanh", "double");
        this.function("float", "__builtin_atanhf", "float");
        this.function("long double", "__builtin_atanhl", "long double");
        this.function("double", "__builtin_atan2", "double", "double");
        this.function("float", "__builtin_atan2f", "float", "float");
        this.function("long double", "__builtin_atan2l", "long double", "long double");
        this.function("void*", "__builtin_alloca", "size_t");
        this.cfunction("", "__builtin_choose_expr", "", "", "");
        this.function("double", "__builtin_cbrt", "double");
        this.function("float", "__builtin_cbrtf", "float");
        this.function("long double", "__builtin_cbrtl", "long double");
        this.function("double", "__builtin_ceil", "double");
        this.function("float", "__builtin_ceilf", "float");
        this.function("long double", "__builtin_ceill", "long double");
        this.function("double", "__builtin_cimag", "complex double");
        this.function("float", "__builtin_cimagf", "complex float");
        this.function("long double", "__builtin_cimagl", "complex long double");
        this.function("void", "__builtin___clear_cache", "void*", "void*");
        this.function("int", "__builtin_clrsb", builtinClrsb, "int");
        this.function("int", "__builtin_clrsbl", builtinClrsbl, "long");
        this.function("int", "__builtin_clrsbll", builtinClrsbll, "long long");
        this.function("int", "__builtin_clz", builtinClz, "unsigned int");
        this.function("int", "__builtin_clzl", builtinClzl, "unsigned long");
        this.function("int", "__builtin_clzll", builtinClzll, "unsigned long long");
        this.function("complex double", "__builtin_conj", "complex double");
        this.function("complex float", "__builtin_conjf", "complex float");
        this.function("complex long double", "__builtin_conjl", "complex long double");
        this.function("int", "__builtin_constant_p", "...");
        this.function("double", "__builtin_copysign", "double", "double");
        this.function("float", "__builtin_copysignf", "float", "float");
        this.function("long double", "__builtin_copysignl", "long double", "long double");
        this.function("double", "__builtin_cos", "double");
        this.function("float", "__builtin_cosf", "float");
        this.function("long double", "__builtin_cosl", "long double");
        this.function("double", "__builtin_cosh", "double");
        this.function("float", "__builtin_coshf", "float");
        this.function("long double", "__builtin_coshl", "long double");
        this.function("double", "__builtin_creal", "complex double");
        this.function("float", "__builtin_crealf", "complex float");
        this.function("long double", "__builtin_creall", "complex long double");
        this.function("int", "__builtin_ctz", builtinCtz, "unsigned int");
        this.function("int", "__builtin_ctzl", builtinCtzl, "unsigned long");
        this.function("int", "__builtin_ctzll", builtinCtzll, "unsigned long long");
        this.function("double", "__builtin_erf", "double");
        this.function("float", "__builtin_erff", "float");
        this.function("long double", "__builtin_erfl", "long double");
        this.function("double", "__builtin_ercf", "double");
        this.function("float", "__builtin_erfcf", "float");
        this.function("long double", "__builtin_erfcl", "long double");
        this.function("void", "__builtin__Exit", "int");
        this.function("void", "__builtin__exit", "int");
        this.function("void", "__builtin_exit", "int");
        this.function("double", "__builtin_exp", "double");
        this.function("float", "__builtin_expf", "float");
        this.function("long double", "__builtin_expl", "long double");
        this.function("double", "__builtin_exp2", "double");
        this.function("float", "__builtin_exp2f", "float");
        this.function("long double", "__builtin_exp2l", "long double");
        this.function("double", "__builtin_expm1", "double");
        this.function("float", "__builtin_expm1f", "float");
        this.function("long double", "__builtin_expm1l", "long double");
        this.function("long", "__builtin_expect", "long", "long");
        this.function("long", "__builtin_expect_with_probability", "long", "long", "double");
        this.function("unsigned long long int", "__builtin_extend_pointer", "void*");
        this.function("double", "__builtin_fabs", "double");
        this.function("float", "__builtin_fabsf", "float");
        this.function("long double", "__builtin_fabsl", "long double");
        this.function("double", "__builtin_fdim", "double", "double");
        this.function("float", "__builtin_fdimf", "float", "float");
        this.function("long double", "__builtin_fdiml", "long double", "long double");
        this.function("int", "__builtin_ffs", builtinFfs, "unsigned int");
        this.function("int", "__builtin_ffsl", builtinFfsl, "unsigned long");
        this.function("int", "__builtin_ffsll", builtinFfsll, "unsigned long long");
        this.function("double", "__builtin_floor", "double");
        this.function("float", "__builtin_floorf", "float");
        this.function("long double", "__builtin_floorl", "long double");
        this.function("double", "__builtin_fma", "double", "double", "double");
        this.function("float", "__builtin_fmaf", "float", "float", "float");
        this.function("long double", "__builtin_fmal", "long double", "long double", "long double");
        this.function("double", "__builtin_fmax", "double", "double");
        this.function("float", "__builtin_fmaxf", "float", "float");
        this.function("long double", "__builtin_fmaxl", "long double", "long double");
        this.function("double", "__builtin_fmin", "double", "double");
        this.function("float", "__builtin_fminf", "float", "float");
        this.function("long double", "__builtin_fminl", "long double", "long double");
        this.function("double", "__builtin_fmod", "double", "double");
        this.function("float", "__builtin_fmodf", "float", "float");
        this.function("long double", "__builtin_fmodl", "long double", "long double");
        this.function("int", "__builtin_fpclassify", "int", "int", "int", "int", "int", "double");
        this.function("int", "__builtin_fprintf", "FILE*", "const char*");
        this.function("int", "__builtin_fputs", "const char*", "FILE*");
        this.function("double", "__builtin_frexp", "double", "int*");
        this.function("float", "__builtin_frexpf", "float", "int*");
        this.function("long double", "__builtin_frexpl", "long double", "int*");
        this.function("int", "__builtin_goacc_parlevel_id", "int");
        this.function("int", "__builtin_goacc_parlevel_size", "int");
        this.function("double", "__builtin_huge_val", new String[0]);
        this.function("float", "__builtin_huge_valf", new String[0]);
        this.function("long double", "__builtin_huge_vall", new String[0]);
        this.function("double", "__builtin_fhypot", "double");
        this.function("float", "__builtin_fhypotf", "float");
        this.function("long double", "__builtin_fhypotl", "long double");
        this.function("int", "__builtin_ilogb", "double");
        this.function("int", "__builtin_ilogbf", "float");
        this.function("int", "__builtin_ilogbl", "long double");
        this.function("long long", "__builtin_imaxabs", builtinLlabs, "long long");
        this.function("double", "__builtin_inf", new String[0]);
        this.function("_Decimal32", "__builtin_infd32", new String[0]);
        this.function("_Decimal64", "__builtin_infd64", new String[0]);
        this.function("_Decimal128", "__builtin_infd128", new String[0]);
        this.function("float", "__builtin_inff", new String[0]);
        this.function("long double", "__builtin_infl", new String[0]);
        this.function("int", "__builtin_isinf_sign", "...");
        this.function("bool", "__builtin_isfinite", "double");
        this.function("bool", "__builtin_isgreater", "float", "float");
        this.function("bool", "__builtin_isgreaterequal", "float", "float");
        this.function("bool", "__builtin_isinf", "double");
        this.function("bool", "__builtin_isless", "float", "float");
        this.function("bool", "__builtin_islessequal", "float", "float");
        this.function("bool", "__builtin_islessgreater", "float", "float");
        this.function("bool", "__builtin_isnan", "double");
        this.function("bool", "__builtin_isnormal", "double");
        this.function("bool", "__builtin_isunordered", "float", "float");
        this.function("long", "__builtin_labs", builtinLabs, "long");
        this.function("double", "__builtin_ldexp", "double", "int");
        this.function("float", "__builtin_ldexpf", "float", "int");
        this.function("long double", "__builtin_ldexpl", "long double", "int");
        this.function("double", "__builtin_lgamma", "double");
        this.function("float", "__builtin_lgammaf", "float");
        this.function("long double", "__builtin_lgammal", "long double");
        this.function("int", "__builtin_LINE", new String[0]);
        this.function("const char *", "__builtin_FUNCTION", new String[0]);
        this.function("const char *", "__builtin_FILE", new String[0]);
        this.function("long long", "__builtin_llabs", builtinLlabs, "long long");
        this.function("long long", "__builtin_llrint", "double");
        this.function("long long", "__builtin_llrintf", "float");
        this.function("long long", "__builtin_llrintl", "long double");
        this.function("long long", "__builtin_llround", "double");
        this.function("long long", "__builtin_llroundf", "float");
        this.function("long long", "__builtin_llroundl", "long double");
        this.function("double", "__builtin_log", "double");
        this.function("float", "__builtin_logf", "float");
        this.function("long double", "__builtin_logl", "long double");
        this.function("double", "__builtin_log10", "double");
        this.function("float", "__builtin_log10f", "float");
        this.function("long double", "__builtin_log10l", "long double");
        this.function("double", "__builtin_log1p", "double");
        this.function("float", "__builtin_log1pf", "float");
        this.function("long double", "__builtin_log1pl", "long double");
        this.function("double", "__builtin_log2", "double");
        this.function("float", "__builtin_log2f", "float");
        this.function("long double", "__builtin_log2l", "long double");
        this.function("double", "__builtin_logb", "double");
        this.function("float", "__builtin_logbf", "float");
        this.function("long double", "__builtin_logbl", "long double");
        this.function("long", "__builtin_lrint", "double");
        this.function("long", "__builtin_lrintf", "float");
        this.function("long", "__builtin_lrintl", "long double");
        this.function("long", "__builtin_lround", "double");
        this.function("long", "__builtin_lroundf", "float");
        this.function("long", "__builtin_lroundl", "long double");
        this.function("float", "__builtin_modff", "float", "float*");
        this.function("long double", "__builtin_modfl", "long double", "long double*");
        this.function("void*", "__builtin_memchr", "const void*", "int", "size_t");
        this.function("int", "__builtin_memcmp", "const void*", "const void*", "size_t");
        this.function("void*", "__builtin_memcpy", "void*", "const void*", "size_t");
        this.function("void*", "__builtin_memmove", "void*", "const void*", "size_t");
        this.function("void*", "__builtin_memset", "void*", "int", "size_t");
        this.function("double", "__builtin_nan", "const char*");
        this.function("_Decimal32", "__builtin_nand32", new String[0]);
        this.function("_Decimal64", "__builtin_nand64", new String[0]);
        this.function("_Decimal128", "__builtin_nand128", new String[0]);
        this.function("float", "__builtin_nanf", "const char*");
        this.function("long double", "__builtin_nanl", "const char*");
        this.function("double", "__builtin_nans", "const char*");
        this.function("float", "__builtin_nansf", "const char*");
        this.function("long double", "__builtin_nansl", "const char*");
        this.function("double", "__builtin_nearby", "double");
        this.function("float", "__builtin_nearbyf", "float");
        this.function("long double", "__builtin_nearbyl", "long double");
        this.function("double", "__builtin_nextafter", "double", "double");
        this.function("float", "__builtin_nextafterf", "float", "float");
        this.function("long double", "__builtin_nextafterl", "long double", "long double");
        this.function("double", "__builtin_nexttoward", "double", "long double");
        this.function("float", "__builtin_nexttowardf", "float", "long double");
        this.function("long double", "__builtin_nexttowardl", "long double", "long double");
        this.function("int", "__builtin_parity", builtinParity, "unsigned int");
        this.function("int", "__builtin_parityl", builtinParityl, "unsigned long");
        this.function("int", "__builtin_parityll", builtinParityll, "unsigned long long");
        this.function("int", "__builtin_popcount", builtinPopcount, "unsigned int");
        this.function("int", "__builtin_popcountl", builtinPopcountl, "unsigned long");
        this.function("int", "__builtin_popcountll", builtinPopcountll, "unsigned long long");
        this.function("double", "__builtin_pow", "double", "double");
        this.function("float", "__builtin_powf", "float", "float");
        this.function("long double", "__builtin_powl", "long double", "long double");
        this.function("double", "__builtin_powi", "double", "int");
        this.function("float", "__builtin_powif", "float", "int");
        this.function("long double", "__builtin_powil", "long double", "int");
        this.function("void", "__builtin_prefetch", "const void*", "...");
        this.function("int", "__builtin_printf", "const char*", "...");
        this.function("int", "__builtin_putchar", "int");
        this.function("int", "__builtin_puts", "const char*");
        this.function("double", "__builtin_remainder", "double", "double");
        this.function("float", "__builtin_remainderf", "float", "float");
        this.function("long double", "__builtin_remainderl", "long double", "long double");
        this.function("double", "__builtin_remquo", "double", "double", "int*");
        this.function("float", "__builtin_remquof", "float", "float", "int*");
        this.function("long double", "__builtin_remquol", "long double", "long double", "int*");
        this.function("double", "__builtin_rint", "double");
        this.function("float", "__builtin_rintf", "float");
        this.function("long double", "__builtin_rintl", "long double");
        this.function("double", "__builtin_round", "double");
        this.function("float", "__builtin_roundf", "float");
        this.function("long double", "__builtin_roundl", "long double");
        this.function("double", "__builtin_scalbln", "double", "long");
        this.function("float", "__builtin_scalblnf", "float", "long");
        this.function("long double", "__builtin_scalblnl", "long double", "long");
        this.function("double", "__builtin_scalbn", "double", "int");
        this.function("float", "__builtin_scalbnf", "float", "int");
        this.function("long double", "__builtin_scalbnl", "long double", "int");
        this.function("int", "__builtin_scanf", "const char*", "...");
        this.function("bool", "__builtin_signbit", "double");
        this.function("double", "__builtin_sin", "double");
        this.function("float", "__builtin_sinf", "float");
        this.function("long double", "__builtin_sinl", "long double");
        this.function("double", "__builtin_sinh", "double");
        this.function("float", "__builtin_sinhf", "float");
        this.function("long double", "__builtin_sinhl", "long double");
        this.function("int", "__builtin_snprintf", "char*", "size_t", "const char*", "...");
        this.function("int", "__builtin_sprintf", "char*", "const char*", "...");
        this.function("double", "__builtin_sqrt", "double");
        this.function("float", "__builtin_sqrtf", "float");
        this.function("long double", "__builtin_sqrtl", "long double");
        this.function("int", "__builtin_sscanf", "const char*", "const char*", "...");
        this.function("char*", "__builtin_strcat", "char*", "const char*");
        this.function("char*", "__builtin_strchr", "const char*", "int");
        this.function("int", "__builtin_strcmp", "const char*", "const char*");
        this.function("char*", "__builtin_strcpy", "char*", "const char*");
        this.function("size_t", "__builtin_strcspn", "const char*", "const char*");
        this.function("size_t", "__builtin_strlen", "const char*");
        this.function("char*", "__builtin_strncat", "char*", "const char*", "size_t");
        this.function("int", "__builtin_strncmp", "const char*", "const char*", "size_t");
        this.function("char*", "__builtin_strncpy", "char*", "const char*", "size_t");
        this.function("char*", "__builtin_strpbrk", "const char*", "const char*");
        this.function("char*", "__builtin_strrchr", "const char*", "int");
        this.function("size_t", "__builtin_strspn", "const char*", "const char*");
        this.function("char*", "__builtin_strstr", "const char*", "const char*");
        this.function("double", "__builtin_tan", "double");
        this.function("float", "__builtin_tanf", "float");
        this.function("long double", "__builtin_tanl", "long double");
        this.function("double", "__builtin_tanh", "double");
        this.function("float", "__builtin_tanhf", "float");
        this.function("long double", "__builtin_tanhl", "long double");
        this.function("double", "__builtin_tgamma", "double");
        this.function("float", "__builtin_tgammaf", "float");
        this.function("long double", "__builtin_tgammal", "long double");
        this.function("void", "__builtin_trap", new String[0]);
        this.function("double", "__builtin_trunc", "double");
        this.function("float", "__builtin_truncf", "float");
        this.function("long double", "__builtin_truncl", "long double");
        this.function("int", "__builtin_types_compatible_p", "", "");
        this.function("void", "__builtin_unreachable", new String[0]);
        this.function("int", "__builtin_vprintf", "const char*", "va_list");
        this.function("int", "__builtin_vscanf", "const char*", "va_list");
        this.function("int", "__builtin_vsnprintf", "char*", "size_t", "const char*", "va_list");
        this.function("int", "__builtin_vsprintf", "char*", "const char*", "va_list");
        this.function("int", "__builtin_vsscanf", "const char*", "const char*", "va_list");
        this.function("size_t", "__builtin_object_size", "const void*", "int");
        this.function("double", "__builtin_ia32_shufpd", "double", "double", "int");
    }

    private void variable(String type, String name) {
        PlatformObject b = this.fCpp ? new CPPBuiltinVariable(this.toType(type), this.toCharArray(name), this.fScope) : new CBuiltinVariable(this.toType(type), this.toCharArray(name), this.fScope);
        this.fBindingList.add((IBinding)b);
    }

    private void typedef(String type, String name) {
        PlatformObject b = this.fCpp ? new CPPImplicitTypedef(this.toType(type), this.toCharArray(name), this.fScope) : new CImplicitTypedef(this.toType(type), this.toCharArray(name), this.fScope);
        this.fBindingList.add((IBinding)b);
    }

    private void cfunction(String returnType, String name, String ... parameterTypes) {
        if (!this.fCpp) {
            this.function(returnType, name, parameterTypes);
        }
    }

    private void function(String returnType, String name, String ... parameterTypes) {
        this.function(returnType, name, (ICPPExecution)null, parameterTypes);
    }

    private void function(String returnType, String name, ICPPExecution exec, String ... parameterTypes) {
        boolean varargs;
        int len = parameterTypes.length;
        boolean bl = varargs = len > 0 && parameterTypes[len - 1].equals("...");
        if (varargs) {
            --len;
        }
        IType[] pTypes = new IType[len];
        IParameter[] theParms = this.fCpp ? new ICPPParameter[len] : new IParameter[len];
        int i = 0;
        while (i < len) {
            IType pType;
            pTypes[i] = pType = this.toType(parameterTypes[i]);
            theParms[i] = this.fCpp ? new CPPBuiltinParameter(pType, i) : new CBuiltinParameter(pType);
            ++i;
        }
        IType rt = this.toType(returnType);
        ISerializableType ft = this.fCpp ? new CPPFunctionType(rt, pTypes, null) : new CFunctionType(rt, pTypes);
        PlatformObject b = this.fCpp ? new CPPBuiltinImplicitFunction(this.toCharArray(name), this.fScope, (ICPPFunctionType)((Object)ft), (ICPPParameter[])theParms, varargs, exec) : new CImplicitFunction(this.toCharArray(name), this.fScope, (IFunctionType)((Object)ft), theParms, varargs);
        this.fBindingList.add((IBinding)b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] toCharArray(String name) {
        Map<String, char[]> map = CHAR_ARRAYS;
        synchronized (map) {
            char[] result = CHAR_ARRAYS.get(name);
            if (result == null) {
                result = name.toCharArray();
                CHAR_ARRAYS.put(name, result);
            }
            return result;
        }
    }

    private IType toType(String type) {
        IType t = this.fTypeMap.get(type);
        if (t == null) {
            t = this.createType(type);
            this.fTypeMap.put(type, t);
        }
        return t;
    }

    private IType createType(String type) {
        IType t;
        String tstr = type;
        if (this.fCpp && tstr.endsWith("&")) {
            String nested = tstr.substring(0, tstr.length() - 1).trim();
            return new CPPReferenceType(this.toType(nested), false);
        }
        if (tstr.equals("FILE*")) {
            return this.toType("void*");
        }
        if (tstr.endsWith("*")) {
            String nested = tstr.substring(0, tstr.length() - 1).trim();
            IType nt = this.toType(nested);
            return this.fCpp ? new CPPPointerType(nt) : new CPointerType(nt, 0);
        }
        if (tstr.endsWith("[1]")) {
            String nested = tstr.substring(0, tstr.length() - 3).trim();
            IType nt = this.toType(nested);
            return this.fCpp ? new CPPArrayType(nt, IntegralValue.create(1L)) : new CArrayType(nt);
        }
        boolean isConst = false;
        boolean isVolatile = false;
        if (tstr.startsWith("const ")) {
            isConst = true;
            tstr = tstr.substring(6);
        }
        if (tstr.endsWith("const")) {
            isConst = true;
            tstr = tstr.substring(0, tstr.length() - 5).trim();
        }
        if (tstr.startsWith("volatile ")) {
            isVolatile = true;
            tstr = tstr.substring(9);
        }
        if (tstr.endsWith("volatile")) {
            isVolatile = true;
            tstr = tstr.substring(0, tstr.length() - 8).trim();
        }
        int q = 0;
        if (tstr.startsWith("signed ")) {
            q |= 4;
            tstr = tstr.substring(7);
        }
        if (tstr.startsWith("unsigned ")) {
            q |= 8;
            tstr = tstr.substring(9);
        }
        if (tstr.startsWith("complex ")) {
            q |= 0x10;
            tstr = tstr.substring(8);
        }
        if (tstr.startsWith("long long")) {
            q |= 0x40;
            tstr = tstr.substring(9).trim();
        }
        if (tstr.startsWith("long")) {
            q |= 1;
            tstr = tstr.substring(4).trim();
        }
        if (tstr.equals("void")) {
            IBasicType.Kind kind = IBasicType.Kind.eVoid;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.isEmpty()) {
            IBasicType.Kind kind = IBasicType.Kind.eUnspecified;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("char")) {
            IBasicType.Kind kind = IBasicType.Kind.eChar;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("_Decimal32")) {
            IBasicType.Kind kind = IBasicType.Kind.eDecimal32;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("_Decimal64")) {
            IBasicType.Kind kind = IBasicType.Kind.eDecimal64;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("_Decimal128")) {
            IBasicType.Kind kind = IBasicType.Kind.eDecimal128;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("int")) {
            IBasicType.Kind kind = IBasicType.Kind.eInt;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("__int128")) {
            IBasicType.Kind kind = IBasicType.Kind.eInt128;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("float")) {
            IBasicType.Kind kind = IBasicType.Kind.eFloat;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("double")) {
            IBasicType.Kind kind = IBasicType.Kind.eDouble;
            t = this.fCpp ? new CPPBasicType(kind, q) : new CBasicType(kind, q);
        } else if (tstr.equals("bool")) {
            t = this.fCpp ? new CPPBasicType(IBasicType.Kind.eBoolean, q) : new CBasicType(IBasicType.Kind.eInt, q);
        } else if (tstr.equals("va_list")) {
            IType rt = this.toType("char*");
            t = this.fCpp ? new CPPPointerType(new CPPFunctionType(rt, IType.EMPTY_TYPE_ARRAY, null)) : new CPointerType(new CFunctionType(rt, IType.EMPTY_TYPE_ARRAY), 0);
        } else if (tstr.equals("size_t")) {
            t = this.toType("unsigned long");
        } else if (tstr.equals("void*")) {
            t = this.fCpp ? new CPPPointerType(new CPPBasicType(IBasicType.Kind.eVoid, q)) : new CPointerType(new CBasicType(IBasicType.Kind.eVoid, q), 0);
        } else {
            throw new IllegalArgumentException(type);
        }
        if (isConst || isVolatile) {
            return this.fCpp ? new CPPQualifierType(t, isConst, isVolatile) : new CQualifierType(t, isConst, isVolatile, false);
        }
        return t;
    }

    @Override
    public boolean isKnownBuiltin(char[] builtinName) {
        return this.fKnownBuiltins.containsKey(builtinName);
    }

    private static class CPPBuiltinImplicitFunction
    extends CPPImplicitFunction {
        private ICPPExecution execution;

        public CPPBuiltinImplicitFunction(char[] name, IScope scope, ICPPFunctionType type, ICPPParameter[] params, boolean takesVarArgs, ICPPExecution execution) {
            super(name, scope, type, params, true, takesVarArgs);
            this.execution = execution;
        }

        @Override
        public ICPPExecution getFunctionBodyExecution() {
            return this.execution;
        }
    }
}

