/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.dwarf;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICompileOptionsFinder;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.coff.Coff64;
import org.eclipse.cdt.utils.coff.PE64;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.dwarf.Dwarf;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DwarfReader
extends Dwarf
implements ISymbolReader,
ICompileOptionsFinder {
    static final String[] DWARF_SectionsToParse = new String[]{".debug_info", ".debug_line", ".debug_abbrev", ".debug_str", ".debug_macro", ".debug_line_str"};
    static final String[] DWARF_ALT_SectionsToParse = new String[]{".debug_str", ".debug_macro"};
    private final Collection<String> m_fileCollection = new HashSet<String>();
    private final Map<Long, String> m_stmtFileMap = new HashMap<Long, String>();
    private final Map<String, ArrayList<String>> m_compileOptionsMap = new HashMap<String, ArrayList<String>>();
    private String[] m_fileNames = null;
    private boolean m_parsed = false;
    private boolean m_macros_parsed = false;
    private final ArrayList<Integer> m_parsedLineTableOffsets = new ArrayList();
    private long m_parsedLineTableSize = 0L;

    public DwarfReader(String file) throws IOException {
        super(file);
    }

    public DwarfReader(Elf exe) throws IOException {
        super(exe);
    }

    public DwarfReader(PE64 exe) throws IOException {
        super(exe);
    }

    @Override
    public void init(Elf exe) throws IOException {
        Elf.Section[] sectionArray;
        Object buildId;
        Elf.Section section;
        int n;
        Elf.Section[] sectionArray2;
        Elf.Section[] sections;
        Path debugInfoPath;
        block56: {
            ByteBuffer data;
            Elf.Section gnuDebugLink;
            Elf.ELFhdr header = exe.getELFhdr();
            this.isLE = header.e_ident[5] == 1;
            debugInfoPath = new Path(exe.getFilename());
            sections = exe.getSections();
            boolean have_build_id = false;
            sectionArray2 = sections;
            n = sections.length;
            int n2 = 0;
            while (n2 < n) {
                block54: {
                    ByteBuffer data2;
                    section = sectionArray2[n2];
                    if (section.sh_type == 7L && (data2 = section.mapSectionData()).remaining() > 12) {
                        try {
                            int name_sz = this.read_4_bytes(data2);
                            int data_sz = this.read_4_bytes(data2);
                            int note_type22 = this.read_4_bytes(data2);
                            String noteName = this.readString(data2);
                            buildId = null;
                            if (!noteName.equals("GNU") || note_type22 != 3) break block54;
                            byte[] byteArray = new byte[data_sz];
                            while ((data2.position() & 3) != 0) {
                                data2.get();
                            }
                            int i = 0;
                            while (data2.hasRemaining() && data_sz-- > 0) {
                                byteArray[i++] = data2.get();
                            }
                            String bName = DwarfReader.printHexBinary(byteArray).toLowerCase();
                            buildId = String.valueOf(bName.substring(0, 2)) + "/" + bName.substring(2) + ".debug";
                            IPath buildIdPath = new Path("/usr/lib/debug/.build-id").append((String)buildId);
                            File buildIdFile = buildIdPath.toFile();
                            if (!buildIdFile.exists()) break block54;
                            Throwable throwable = null;
                            sectionArray = null;
                            try (Elf debugInfo = new Elf(buildIdFile.getCanonicalPath());){
                                sections = debugInfo.getSections();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            have_build_id = true;
                            debugInfoPath = new Path(buildIdFile.getCanonicalPath()).removeLastSegments(1);
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            CCorePlugin.log(e);
                        }
                    }
                }
                ++n2;
            }
            if (!have_build_id && (gnuDebugLink = exe.getSectionByName(".gnu_debuglink")) != null && (data = gnuDebugLink.mapSectionData()) != null) {
                try {
                    String debugName = "";
                    if (data.hasRemaining()) {
                        byte c;
                        StringBuilder sb = new StringBuilder();
                        while ((c = data.get()) != -1) {
                            if (c == 0) break;
                            sb.append((char)c);
                        }
                        debugName = sb.toString();
                    }
                    if (debugName.length() <= 0) break block56;
                    File debugFile = null;
                    Path exePath = new Path(exe.getFilename());
                    IPath p = exePath.removeLastSegments(1);
                    debugFile = p.append(debugName).toFile();
                    if (!debugFile.exists() && !(debugFile = p.append(".debug").append(debugName).toFile()).exists()) {
                        debugFile = new Path("/usr/lib/debug").append(p).append(debugName).toFile();
                    }
                    if (!debugFile.exists()) break block56;
                    Throwable data_sz = null;
                    Object note_type22 = null;
                    try (Elf debugInfo = new Elf(debugFile.getCanonicalPath());){
                        sections = debugInfo.getSections();
                    }
                    catch (Throwable note_type22) {
                        if (data_sz == null) {
                            data_sz = note_type22;
                        } else if (data_sz != note_type22) {
                            data_sz.addSuppressed(note_type22);
                        }
                        throw data_sz;
                    }
                    debugInfoPath = new Path(debugFile.getCanonicalPath()).removeLastSegments(1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CCorePlugin.log(e);
                }
            }
        }
        sectionArray2 = sections;
        n = sections.length;
        int n3 = 0;
        while (n3 < n) {
            block58: {
                section = sectionArray2[n3];
                String name = section.toString();
                if (name.equals(".gnu_debugaltlink")) {
                    ByteBuffer data = section.mapSectionData();
                    try {
                        File altFile;
                        String altInfoName = this.readString(data);
                        if (altInfoName.length() <= 0) break block58;
                        Path altPath = new Path(altInfoName);
                        if (!altPath.isAbsolute()) {
                            altPath = debugInfoPath.append((IPath)altPath);
                        }
                        if (!(altFile = altPath.toFile()).exists()) break block58;
                        buildId = null;
                        Object var16_37 = null;
                        try (Elf altInfo = new Elf(altFile.getCanonicalPath());){
                            Elf.Section[] altSections;
                            sectionArray = altSections = altInfo.getSections();
                            int n4 = altSections.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                Elf.Section altSection = sectionArray[n5];
                                String altName = altSection.toString();
                                String[] stringArray = DWARF_ALT_SectionsToParse;
                                int n6 = DWARF_ALT_SectionsToParse.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    String element = stringArray[n7];
                                    if (altName.equals(element)) {
                                        try {
                                            this.dwarfAltSections.put(element, altSection.mapSectionData());
                                        }
                                        catch (Exception e) {
                                            CCorePlugin.log(e);
                                        }
                                    }
                                    ++n7;
                                }
                                ++n5;
                            }
                        }
                        catch (Throwable throwable) {
                            if (buildId == null) {
                                buildId = throwable;
                            } else if (buildId != throwable) {
                                ((Throwable)buildId).addSuppressed(throwable);
                            }
                            throw buildId;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CCorePlugin.log(e);
                    }
                } else {
                    String[] stringArray = DWARF_SectionsToParse;
                    int n8 = DWARF_SectionsToParse.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        String element = stringArray[n9];
                        if (name.equals(element)) {
                            try {
                                this.dwarfSections.put(element, section.mapSectionData());
                            }
                            catch (Exception e) {
                                CCorePlugin.log(e);
                            }
                        }
                        ++n9;
                    }
                }
            }
            ++n3;
        }
        this.printEnabled = false;
        this.m_parsed = false;
    }

    @Override
    public void init(PE64 exe) throws IOException {
        this.isLE = true;
        Coff64.SectionHeader[] sections = exe.getSectionHeaders();
        int i = 0;
        while (i < sections.length) {
            String name = new String(sections[i].s_name).trim();
            if (name.startsWith("/")) {
                int stringTableOffset = Integer.parseInt(name.substring(1));
                name = exe.getStringTableEntry(stringTableOffset);
            }
            String[] stringArray = Dwarf.DWARF_SCNNAMES;
            int n = Dwarf.DWARF_SCNNAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (name.equals(element)) {
                    try {
                        this.dwarfSections.put(element, sections[i].mapSectionData());
                    }
                    catch (Exception e) {
                        CCorePlugin.log(e);
                    }
                }
                ++n2;
            }
            ++i;
        }
        this.printEnabled = false;
        this.m_parsed = false;
    }

    private static String printHexBinary(byte[] byteArray) {
        StringBuilder sb = new StringBuilder(byteArray.length * 2);
        byte[] byArray = byteArray;
        int n = byteArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x", b));
            ++n2;
        }
        return sb.toString();
    }

    void parseSourceInCULineInfo(String cuCompDir, int cuStmtList) {
        ByteBuffer data = (ByteBuffer)this.dwarfSections.get(".debug_line");
        if (data != null) {
            try {
                String fileName;
                String str;
                try {
                    data.position(cuStmtList);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(CCorePlugin.getResourceString("Util.exception.noData"));
                }
                Integer cuOffset = cuStmtList;
                boolean dwarf64Bit = false;
                if (!this.m_parsedLineTableOffsets.contains(cuOffset)) {
                    this.m_parsedLineTableOffsets.add(cuOffset);
                    Dwarf.InitialLengthValue length = this.readInitialLengthField(data);
                    dwarf64Bit = length.offsetSize == 8;
                    this.m_parsedLineTableSize += length.length + (long)(dwarf64Bit ? 12 : 4);
                } else {
                    return;
                }
                short version = this.read_2_bytes(data);
                int skip_bytes = 8;
                if (version >= 5) {
                    skip_bytes = (short)(skip_bytes + 2);
                }
                if (version >= 4) {
                    skip_bytes = (short)(skip_bytes + 1);
                }
                if (dwarf64Bit) {
                    skip_bytes = (short)(skip_bytes + 4);
                }
                data.position(data.position() + skip_bytes);
                byte opcode_base = data.get();
                data.position(data.position() + opcode_base - 1);
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add(cuCompDir);
                while ((str = this.readString(data)).length() != 0) {
                    Path dir = new Path(str);
                    if (!dir.isAbsolute()) {
                        dir = new Path(cuCompDir).append(str);
                    }
                    dirList.add(dir.toString());
                }
                while ((fileName = this.readString(data)).length() != 0) {
                    long leb128 = this.read_unsigned_leb128(data);
                    this.addSourceFile((String)dirList.get((int)leb128), fileName);
                    leb128 = this.read_unsigned_leb128(data);
                    leb128 = this.read_unsigned_leb128(data);
                }
            }
            catch (IOException e) {
                CCorePlugin.log("Failed to parse part of dwarf header", e);
            }
        }
    }

    private void getSourceFilesFromDebugLineSection() {
        int minHeaderSize;
        ByteBuffer data = (ByteBuffer)this.dwarfSections.get(".debug_line");
        if (data == null) {
            return;
        }
        int sectionSize = data.capacity();
        if (this.m_parsedLineTableSize >= (long)(sectionSize - (minHeaderSize = 16))) {
            return;
        }
        int lineTableStart = 0;
        try {
            while (lineTableStart < sectionSize - minHeaderSize) {
                String fileName;
                String str;
                data.position(lineTableStart);
                Integer currLineTableStart = lineTableStart;
                Dwarf.InitialLengthValue sectionLength = this.readInitialLengthField(data);
                boolean dwarf64Bit = sectionLength.offsetSize == 8;
                this.m_parsedLineTableSize += sectionLength.length + (long)(dwarf64Bit ? 12 : 4);
                if ((lineTableStart += (int)(sectionLength.length + (long)(dwarf64Bit ? 12 : 4))) < sectionSize - minHeaderSize && (lineTableStart & 3) != 0) {
                    boolean dataValid;
                    int savedPosition = data.position();
                    data.position(lineTableStart);
                    long ltLength = dwarf64Bit ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                    short dwarfVer = this.read_2_bytes(data);
                    byte minInstLengh = data.get(data.position() + (dwarf64Bit ? 8 : 4));
                    boolean bl = dataValid = ltLength > (long)minHeaderSize && ltLength < 0x100000L && dwarfVer > 0 && dwarfVer < 5 && minInstLengh > 0 && minInstLengh <= 8;
                    if (!dataValid) {
                        lineTableStart = lineTableStart + 3 & 0xFFFFFFFC;
                    }
                    data.position(savedPosition);
                }
                if (this.m_parsedLineTableOffsets.contains(currLineTableStart)) continue;
                short version = this.read_2_bytes(data);
                int skip_bytes = 8;
                if (version >= 4) {
                    skip_bytes = (short)(skip_bytes + 1);
                }
                if (dwarf64Bit) {
                    skip_bytes = (short)(skip_bytes + 4);
                }
                data.position(data.position() + skip_bytes);
                byte opcode_base = data.get();
                data.position(data.position() + opcode_base - 1);
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add("");
                while ((str = this.readString(data)).length() != 0) {
                    dirList.add(str);
                }
                while ((fileName = this.readString(data)).length() != 0) {
                    long leb128 = this.read_unsigned_leb128(data);
                    this.addSourceFile((String)dirList.get((int)leb128), fileName);
                    leb128 = this.read_unsigned_leb128(data);
                    leb128 = this.read_unsigned_leb128(data);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public String[] getSourceFiles() {
        if (!this.m_parsed) {
            this.m_fileCollection.clear();
            this.getSourceFilesFromDebugInfoSection();
            this.getSourceFilesFromDebugLineSection();
            this.m_parsed = true;
            this.m_fileNames = new String[this.m_fileCollection.size()];
            this.m_fileCollection.toArray(this.m_fileNames);
        }
        return this.m_fileNames;
    }

    private void getSourceFilesFromDebugInfoSection() {
        this.parse(null);
    }

    private String addSourceFileWithStmt(String dir, String name, int stmt) {
        String fullName = this.addSourceFile(dir, name);
        this.m_stmtFileMap.put(Long.valueOf(stmt), fullName);
        return fullName;
    }

    private String addSourceFile(String dir, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.charAt(0) == '<') {
            return null;
        }
        String fullName = name;
        Path dirPa = new Path(dir);
        Path pa = new Path(name);
        if (!pa.isAbsolute() && dir.length() > 0) {
            pa = dirPa.append((IPath)pa);
        }
        if (!this.m_fileCollection.contains(fullName = pa.toOSString())) {
            this.m_fileCollection.add(fullName);
        }
        return fullName;
    }

    @Override
    void processDebugInfoEntry(IDebugEntryRequestor requestor, Dwarf.AbbreviationEntry entry, List<Dwarf.AttributeValue> list) {
        int tag = (int)entry.tag;
        switch (tag) {
            case 17: {
                this.processCompileUnit(requestor, list);
                break;
            }
        }
    }

    @Override
    void processCompileUnit(IDebugEntryRequestor requestor, List<Dwarf.AttributeValue> list) {
        int stmtList = -1;
        String cuCompDir = "";
        String cuName = "";
        int i = 0;
        while (i < list.size()) {
            Dwarf.AttributeValue av = list.get(i);
            try {
                int name = (int)av.attribute.name;
                switch (name) {
                    case 3: {
                        cuName = (String)av.value;
                        break;
                    }
                    case 27: {
                        cuCompDir = (String)av.value;
                        break;
                    }
                    case 16: {
                        stmtList = ((Number)av.value).intValue();
                        break;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        this.addSourceFileWithStmt(cuCompDir, cuName, stmtList);
        if (stmtList > -1) {
            this.parseSourceInCULineInfo(cuCompDir, stmtList);
        }
    }

    @Override
    public String[] getSourceFiles(IProgressMonitor monitor) {
        return this.getSourceFiles();
    }

    private String getCommandLineMacro(String macro) {
        String commandLineMacro = "-D" + macro;
        commandLineMacro = commandLineMacro.replaceFirst(" ", "=");
        return commandLineMacro;
    }

    private void getCommandMacrosFromMacroSection() {
        ByteBuffer data = (ByteBuffer)this.dwarfSections.get(".debug_macro");
        ByteBuffer str = (ByteBuffer)this.dwarfSections.get(".debug_str");
        ByteBuffer altdata = (ByteBuffer)this.dwarfAltSections.get(".debug_macro");
        ByteBuffer altstr = (ByteBuffer)this.dwarfAltSections.get(".debug_str");
        HashSet<String> fixupList = new HashSet<String>();
        HashSet<String> fixupAltList = new HashSet<String>();
        boolean DEBUG = false;
        if (data == null) {
            return;
        }
        HashMap<Long, ArrayList<String>> t_macros = new HashMap<Long, ArrayList<String>>();
        HashMap<Long, ArrayList<String>> t_alt_macros = new HashMap<Long, ArrayList<String>>();
        this.parseMacroSection(data, str, altstr, fixupList, fixupAltList, "=FIXUP=", DEBUG, t_macros);
        if (altdata != null) {
            if (DEBUG) {
                System.out.println("Processing Alternate Macro Section");
            }
            this.parseMacroSection(altdata, altstr, altstr, fixupAltList, fixupAltList, "=FIXUPALT=", DEBUG, t_alt_macros);
        }
        this.fixupMacros(fixupList, "=FIXUP=", DEBUG, t_macros);
        if (DEBUG) {
            System.out.println("Fix up forward references in alternate macro section");
        }
        this.fixupMacros(fixupAltList, "=FIXUPALT=", DEBUG, t_alt_macros);
    }

    private void fixupMacros(Set<String> fixupList, String fixupMarker, boolean DEBUG, HashMap<Long, ArrayList<String>> t_macros) {
        for (String name : fixupList) {
            ArrayList<String> macros = this.m_compileOptionsMap.get(name);
            int i = 0;
            while (i < macros.size()) {
                String macroLine = macros.get(i);
                if (macroLine.startsWith(fixupMarker)) {
                    Long offset = Long.valueOf(macroLine.substring(7));
                    if (DEBUG) {
                        System.out.println("Found fixup needed for offset: " + offset + " for file: " + name);
                    }
                    ArrayList<String> insertMacros = t_macros.get(offset);
                    if (DEBUG) {
                        System.out.println("insert macros are: " + insertMacros.toString());
                    }
                    macros.remove(i);
                    macros.addAll(i, insertMacros);
                    i += insertMacros.size();
                }
                ++i;
            }
            this.m_compileOptionsMap.put(name, macros);
        }
    }

    private void parseMacroSection(ByteBuffer data, ByteBuffer str, ByteBuffer altstr, Set<String> fixupList, Set<String> fixupAltList, String fixupMarker, boolean DEBUG, HashMap<Long, ArrayList<String>> t_macros) {
        while (data.hasRemaining()) {
            try {
                OpcodeInfo info;
                boolean offset_size_8;
                int original_position = data.position();
                short type = this.read_2_bytes(data);
                byte flags = data.get();
                long lt_offset = -1L;
                String fileName = null;
                HashMap<Integer, OpcodeInfo> opcodeInfos = null;
                if (DEBUG) {
                    System.out.println("type is " + type);
                }
                boolean bl = offset_size_8 = (flags & 1) == 1;
                if (DEBUG) {
                    System.out.println("offset size is " + (offset_size_8 ? 8 : 4));
                }
                if ((flags & 2) != 0) {
                    lt_offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                    fileName = this.m_stmtFileMap.get(lt_offset);
                    if (DEBUG) {
                        System.out.println("debug line offset is " + lt_offset);
                    }
                }
                if ((flags & 4) != 0) {
                    opcodeInfos = new HashMap<Integer, OpcodeInfo>();
                    int num_opcodes = data.get();
                    int i = 0;
                    while (i < num_opcodes) {
                        info = new OpcodeInfo(offset_size_8);
                        byte opcode = data.get();
                        long numArgs = this.read_unsigned_leb128(data);
                        info.setNumArgs((int)numArgs);
                        int j = 0;
                        while ((long)j < numArgs) {
                            byte argType = data.get();
                            info.addArgType(argType);
                            ++j;
                        }
                        opcodeInfos.put(Integer.valueOf(opcode), info);
                        ++i;
                    }
                }
                ArrayList<String> macros = new ArrayList<String>();
                boolean done = false;
                block18: while (!done) {
                    byte op = data.get();
                    switch (op) {
                        case 3: {
                            long lineno = this.read_signed_leb128(data);
                            long filenum = this.read_signed_leb128(data);
                            if (filenum == 1L && lt_offset >= 0L) {
                                this.m_compileOptionsMap.put(fileName, macros);
                                if (DEBUG) {
                                    System.out.println("following macros found for file " + macros.toString());
                                }
                                macros = new ArrayList();
                            }
                            if (fileName == null) continue block18;
                            if (DEBUG) {
                                System.out.println(" DW_MACRO_start_file - lineno: " + lineno + " filenum: " + filenum + " " + fileName);
                                break;
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_start_file - lineno: " + lineno + " filenum: " + filenum);
                            break;
                        }
                        case 4: {
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_end_file");
                            break;
                        }
                        case 1: {
                            long lineno = this.read_signed_leb128(data);
                            String string = this.readString(data);
                            if (lineno == 0L) {
                                macros.add(this.getCommandLineMacro(string));
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_define - lineno : " + lineno + " macro : " + string);
                            break;
                        }
                        case 2: {
                            long lineno = this.read_signed_leb128(data);
                            String macro = this.readString(data);
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_undef - lineno : " + lineno + " macro : " + macro);
                            break;
                        }
                        case 5: {
                            long lineno = this.read_signed_leb128(data);
                            long offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            str.position((int)offset);
                            String macro = this.readString(str);
                            if (lineno == 0L) {
                                macros.add(this.getCommandLineMacro(macro));
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_define_indirect - lineno : " + lineno + " macro : " + macro);
                            break;
                        }
                        case 8: {
                            long lineno = this.read_signed_leb128(data);
                            long offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            altstr.position((int)offset);
                            String macro = this.readString(altstr);
                            if (lineno == 0L) {
                                macros.add(this.getCommandLineMacro(macro));
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_define_indirect_alt - lineno : " + lineno + " macro : " + macro);
                            break;
                        }
                        case 6: {
                            long lineno = this.read_signed_leb128(data);
                            long offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            str.position((int)offset);
                            String macro = this.readString(str);
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_undef_indirect - lineno : " + lineno + " macro : " + macro);
                            break;
                        }
                        case 9: {
                            long lineno = this.read_signed_leb128(data);
                            long offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            altstr.position((int)offset);
                            String macro = this.readString(altstr);
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_undef_indirect_alt - lineno : " + lineno + " macro : " + macro);
                            break;
                        }
                        case 7: {
                            long offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            ArrayList<String> foundMacros = t_macros.get(offset);
                            if (foundMacros != null) {
                                macros.addAll(foundMacros);
                            } else if (lt_offset >= 0L) {
                                macros.add(String.valueOf(fixupMarker) + offset);
                                if (DEBUG) {
                                    System.out.println("Adding fixup for offset: " + offset + " for file: " + fileName);
                                }
                                fixupList.add(fileName);
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_transparent_include - offset : " + offset);
                            break;
                        }
                        case 10: {
                            long offset;
                            long l = offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            if (lt_offset >= 0L) {
                                macros.add("=FIXUPALT=" + offset);
                                if (DEBUG) {
                                    System.out.println("Adding alt fixup for offset: " + offset + " for file: " + fileName);
                                }
                                fixupAltList.add(fileName);
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_transparent_include - offset : " + offset);
                            break;
                        }
                        case 0: {
                            if (lt_offset < 0L) {
                                if (DEBUG) {
                                    System.out.println("creating transparent include macros for offset: " + original_position);
                                }
                                t_macros.put(Long.valueOf(original_position), macros);
                            }
                            done = true;
                            break;
                        }
                        default: {
                            if (opcodeInfos == null) continue block18;
                            info = (OpcodeInfo)opcodeInfos.get(op);
                            info.readPastEntry(data);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getCompileOptions(String fileName) {
        ArrayList<String> macros;
        if (!this.m_macros_parsed) {
            this.getSourceFiles();
            this.getCommandMacrosFromMacroSection();
            this.m_macros_parsed = true;
        }
        if ((macros = this.m_compileOptionsMap.get(fileName)) == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String option : macros) {
            sb.append(option);
            sb.append(" ");
        }
        return sb.toString();
    }

    private class OpcodeInfo {
        private int numArgs;
        private final boolean offset_size_8;
        ArrayList<Integer> argTypes;

        public OpcodeInfo(boolean offset_size_8) {
            this.offset_size_8 = offset_size_8;
        }

        public void setNumArgs(int numArgs) {
            this.numArgs = numArgs;
        }

        public void addArgType(int argType) {
            this.argTypes.add(argType);
        }

        /*
         * Unable to fully structure code
         */
        public void readPastEntry(ByteBuffer data) {
            i = 0;
            while (i < this.numArgs) {
                argType = this.argTypes.get(i);
                switch (argType) {
                    case 11: 
                    case 12: {
                        data.get();
                        break;
                    }
                    case 5: {
                        data.getShort();
                        break;
                    }
                    case 6: {
                        data.getInt();
                        break;
                    }
                    case 7: {
                        data.getLong();
                        break;
                    }
                    case 13: 
                    case 15: {
                        try {
                            DwarfReader.this.read_signed_leb128(data);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 9: {
                        try {
                            off = DwarfReader.this.read_signed_leb128(data);
                            data.position((int)((long)data.position() + off));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 10: {
                        off = data.get();
                        data.position(data.position() + off + 1);
                        break;
                    }
                    case 3: {
                        off = data.getShort();
                        data.position(data.position() + off + 2);
                        break;
                    }
                    case 4: {
                        off = data.getInt();
                        data.position(data.position() + off + 4);
                        break;
                    }
lbl53:
                    // 2 sources

                    case 8: {
                        if (data.get() != 0) ** GOTO lbl53
                        break;
                    }
                    case 14: 
                    case 23: 
                    case 7968: 
                    case 7969: {
                        if (this.offset_size_8) {
                            data.getLong();
                            break;
                        }
                        data.getInt();
                    }
                }
                ++i;
            }
        }
    }
}

