/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlOutputElement;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.ITmfXmlSchemaParser;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlUtils {
    private static final String XML_DIRECTORY = "xml_files";
    private static final String XSD = "xmlDefinition.xsd";
    private static final String TMF_XML_BUILTIN_ID = "org.eclipse.linuxtools.tmf.analysis.xml.core.files";
    private static final String XML_FILE_ELEMENT = "xmlfile";
    private static final String XML_FILE_ATTRIB = "file";
    private static final String TMF_XSD_ID = "org.eclipse.tracecompass.tmf.analysis.xml.core.xsd";
    private static final String XSD_FILE_ELEMENT = "xsdfile";
    private static final String XSD_FILE_ATTRIB = "file";
    private static final String XSD_SCHEMA_PARSER_ELEMENT = "schemaParser";
    private static final String XSD_PARSER_CLASS_ATTRIB = "class";
    private static final @NonNull Multimap<String, XmlOutputElement> XML_OUTPUT_ELEMENTS = HashMultimap.create();
    private static Multimap<String, XmlOutputElement> fCachedOutputElement = HashMultimap.create();
    private static final String ENABLED_FILES_PREFERENCE_KEY = "enabled_files";
    private static final String ENABLED_FILES_SEP = ";";
    private static Set<String> fEnabledFiles;
    public static final String XML_EXTENSION = "xml";

    private XmlUtils() {
    }

    public static void loadFilesStatus() {
        IEclipsePreferences preferences = Activator.getDefault().getCorePreferenceStore();
        String enabledFiles = preferences.get(ENABLED_FILES_PREFERENCE_KEY, null);
        fEnabledFiles = enabledFiles != null ? Sets.newHashSet((Iterable)Splitter.on((String)ENABLED_FILES_SEP).omitEmptyStrings().split((CharSequence)enabledFiles)) : Sets.newHashSet();
    }

    public static void saveFilesStatus() {
        IEclipsePreferences preferences = Activator.getDefault().getCorePreferenceStore();
        String enabledFiles = Joiner.on((String)ENABLED_FILES_SEP).join(fEnabledFiles);
        preferences.put(ENABLED_FILES_PREFERENCE_KEY, enabledFiles);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError(Messages.XmlUtils_ErrorSavingPreferences, e);
        }
    }

    public static IPath getXmlFilesPath() {
        IPath path = Activator.getDefault().getStateLocation();
        File dir = (path = path.addTrailingSeparator().append(XML_DIRECTORY)).toFile();
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        return path;
    }

    public static IStatus xmlValidate(File xmlFile) {
        URL url = TmfXmlUtils.class.getResource(XSD);
        List<@NonNull URL> xsdFiles = XmlUtils.getExtraXsdFiles();
        Schema schema = null;
        Source[] sources = new Source[xsdFiles.size() + 1];
        sources[0] = new StreamSource(url.toExternalForm());
        int i = 0;
        while (i < xsdFiles.size()) {
            sources[i + 1] = new StreamSource(xsdFiles.get(i).toExternalForm());
            ++i;
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature("http://apache.org/xml/features/namespace-growth", true);
            schema = schemaFactory.newSchema(sources);
        }
        catch (SAXException e) {
            String error = NLS.bind((String)Messages.XmlUtils_XsdValidationError, (Object)e.getLocalizedMessage());
            Activator.logError(error);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error, (Throwable)e);
        }
        StreamSource xmlSource = new StreamSource(xmlFile);
        try {
            schema.newValidator().validate(xmlSource);
        }
        catch (SAXParseException e) {
            String error = NLS.bind((String)Messages.XmlUtils_XmlParseError, (Object)e.getLineNumber(), (Object)e.getLocalizedMessage());
            Activator.logError(error);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error, (Throwable)e);
        }
        catch (SAXException e) {
            String error = NLS.bind((String)Messages.XmlUtils_XmlValidationError, (Object)e.getLocalizedMessage());
            Activator.logError(error);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error, (Throwable)e);
        }
        catch (IOException e) {
            String error = Messages.XmlUtils_XmlValidateError;
            Activator.logError(Messages.XmlUtils_ExceptionIO, e);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public static IStatus addXmlFile(File fromFile) {
        File toFile = XmlUtils.getXmlFilesPath().addTrailingSeparator().append(fromFile.getName()).toFile();
        IStatus status = XmlUtils.copyXmlFile(fromFile, toFile);
        if (status.isOK()) {
            XmlUtils.preloadXmlAnalysesOutput(toFile);
            fEnabledFiles.add(fromFile.getName());
        }
        return status;
    }

    public static synchronized @NonNull Map<@NonNull String, @NonNull File> listFiles() {
        IPath pathToFiles = XmlUtils.getXmlFilesPath();
        File folder = pathToFiles.toFile();
        HashMap<@NonNull String, @NonNull File> fileMap = new HashMap<String, File>();
        if (folder.isDirectory() && folder.exists()) {
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles != null) {
                File[] fileArray = listOfFiles;
                int n = listOfFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    Path path = new Path(file.getName());
                    if (path.getFileExtension().equals(XML_EXTENSION)) {
                        fileMap.put(file.getName(), file);
                    }
                    ++n2;
                }
            } else {
                Activator.logError(String.valueOf(Messages.XmlUtils_ErrorAccessIO) + " " + folder.getPath());
            }
        }
        return Collections.unmodifiableMap(fileMap);
    }

    public static synchronized @NonNull Map<String, IPath> listBuiltinFiles() {
        List<URL> urls = XmlUtils.getUrlsFromConfiguration(TMF_XML_BUILTIN_ID, XML_FILE_ELEMENT, "file");
        HashMap<String, IPath> map = new HashMap<String, IPath>();
        urls.forEach(url -> {
            Path path = map.put(FilenameUtils.getName((String)url.getPath()), (IPath)new Path(url.getPath()));
        });
        return map;
    }

    private static synchronized @NonNull List<@NonNull URL> getExtraXsdFiles() {
        return XmlUtils.getUrlsFromConfiguration(TMF_XSD_ID, XSD_FILE_ELEMENT, "file");
    }

    private static synchronized @NonNull List<@NonNull URL> getUrlsFromConfiguration(String extensionName, String elementName, String attribName) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionName);
        final ArrayList<@NonNull URL> list = new ArrayList<URL>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(elementName)) {
                final String filename = element.getAttribute(attribName);
                final String name = element.getContributor().getName();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws IOException {
                        Bundle bundle;
                        if (name != null && (bundle = Platform.getBundle((String)name)) != null) {
                            URL xmlUrl = bundle.getResource(filename);
                            if (xmlUrl == null) {
                                throw new FileNotFoundException(filename);
                            }
                            URL locatedURL = FileLocator.toFileURL((URL)xmlUrl);
                            list.add((URL)NonNullUtils.checkNotNull((Object)locatedURL));
                        }
                    }

                    public void handleException(Throwable exception) {
                    }
                });
            }
            ++n2;
        }
        return list;
    }

    public static synchronized @NonNull Collection<ITmfXmlSchemaParser> getExtraSchemaParsers() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_XSD_ID);
        ArrayList<ITmfXmlSchemaParser> list = new ArrayList<ITmfXmlSchemaParser>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(XSD_SCHEMA_PARSER_ELEMENT)) {
                try {
                    ITmfXmlSchemaParser parser = (ITmfXmlSchemaParser)NonNullUtils.checkNotNull((Object)((ITmfXmlSchemaParser)element.createExecutableExtension(XSD_PARSER_CLASS_ATTRIB)));
                    list.add(parser);
                }
                catch (CoreException e) {
                    Activator.logError(Messages.XmlUtils_ErrorAnalysisModules, e);
                }
            }
            ++n2;
        }
        return list;
    }

    public static void deleteFiles(Iterable<String> names) {
        Map<String, File> files = XmlUtils.listFiles();
        for (String name : names) {
            File file = files.get(name);
            if (file == null) continue;
            XmlUtils.removeXmlOutput(file.getAbsolutePath());
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
    }

    public static void enableFiles(Iterable<String> names) {
        for (String name : names) {
            File fileName = XmlUtils.getXmlFilesPath().addTrailingSeparator().append(name).toFile();
            XmlUtils.preloadXmlAnalysesOutput(fileName);
            fEnabledFiles.add(name);
        }
    }

    public static void disableFiles(Iterable<String> names) {
        Map<String, File> files = XmlUtils.listFiles();
        for (String name : names) {
            File file = files.get(name);
            if (file == null) continue;
            XmlUtils.removeXmlOutput(file.getAbsolutePath());
            fEnabledFiles.remove(name);
        }
    }

    public static IStatus exportXmlFile(String from, String to) {
        File fromFile = XmlUtils.getXmlFilesPath().addTrailingSeparator().append(from).toFile();
        if (!fromFile.exists()) {
            Activator.logError(String.valueOf(Messages.XmlUtils_ErrorNotFound) + " " + fromFile.getName());
            return Status.CANCEL_STATUS;
        }
        File toFile = new File(to);
        return XmlUtils.copyXmlFile(fromFile, toFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IStatus copyXmlFile(File fromFile, File toFile) {
        try {
            boolean success;
            if (!toFile.exists() && !(success = toFile.createNewFile())) {
                throw new IllegalStateException("File " + toFile.getAbsolutePath() + " failed to create.");
            }
        }
        catch (IOException e) {
            String error2 = Messages.XmlUtils_ErrorCopyingFile;
            Activator.logError(error2, e);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error2, (Throwable)e);
        }
        try {
            Throwable e = null;
            Object error2 = null;
            try {
                FileInputStream fis = new FileInputStream(fromFile);
                try {
                    block29: {
                        FileOutputStream fos = new FileOutputStream(toFile);
                        try {
                            block28: {
                                FileChannel source = fis.getChannel();
                                try {
                                    try (FileChannel destination = fos.getChannel();){
                                        destination.transferFrom(source, 0L, source.size());
                                    }
                                    if (source == null) break block28;
                                }
                                catch (Throwable error2) {
                                    if (e == null) {
                                        e = error2;
                                    } else if (e != error2) {
                                        e.addSuppressed(error2);
                                    }
                                    if (source == null) throw e;
                                    source.close();
                                    throw e;
                                }
                                source.close();
                            }
                            if (fos == null) break block29;
                        }
                        catch (Throwable error2) {
                            if (e == null) {
                                e = error2;
                            } else if (e != error2) {
                                e.addSuppressed(error2);
                            }
                            if (fos == null) throw e;
                            fos.close();
                            throw e;
                        }
                        fos.close();
                    }
                    if (fis == null) return Status.OK_STATUS;
                }
                catch (Throwable error2) {
                    if (e == null) {
                        e = error2;
                    } else if (e != error2) {
                        e.addSuppressed(error2);
                    }
                    if (fis == null) throw e;
                    fis.close();
                    throw e;
                }
                fis.close();
                return Status.OK_STATUS;
            }
            catch (Throwable error2) {
                if (e == null) {
                    e = error2;
                    throw e;
                }
                if (e == error2) throw e;
                e.addSuppressed(error2);
                throw e;
            }
        }
        catch (IOException e) {
            String error = Messages.XmlUtils_ErrorCopyingFile;
            Activator.logError(error, e);
            return new Status(4, "org.eclipse.tracecompass.tmf.analysis.xml.core", error, (Throwable)e);
        }
    }

    public static List<String> getAnalysisIdsFromFile(String fileName) {
        ArrayList<String> ids = new ArrayList<String>();
        File file = XmlUtils.getXmlFilesPath().addTrailingSeparator().append(fileName).toFile();
        if (file.exists()) {
            try {
                Document doc = XmlUtils.getDocumentFromFile(file);
                NodeList stateproviderNodes = doc.getElementsByTagName("stateProvider");
                int i = 0;
                while (i < stateproviderNodes.getLength()) {
                    ids.add(NonNullUtils.nullToEmptyString((Object)((Element)stateproviderNodes.item(i)).getAttribute("id")));
                    ++i;
                }
                NodeList patternNodes = doc.getElementsByTagName("pattern");
                int i2 = 0;
                while (i2 < patternNodes.getLength()) {
                    ids.add(NonNullUtils.nullToEmptyString((Object)((Element)patternNodes.item(i2)).getAttribute("id")));
                    ++i2;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                Activator.logError(String.valueOf(Messages.XmlUtils_ErrorAnalysesID) + " " + fileName);
            }
        }
        return ids;
    }

    public static Document getDocumentFromFile(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = org.eclipse.tracecompass.common.core.xml.XmlUtils.newSafeDocumentBuilderFactory();
        Document doc = dbFactory.newDocumentBuilder().parse(file);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static @NonNull List<@Nullable Element> getChildElements(Node parent) {
        NodeList childNodes = parent.getChildNodes();
        ArrayList<@Nullable Element> childElements = new ArrayList<Element>();
        int index = 0;
        while (index < childNodes.getLength()) {
            if (childNodes.item(index).getNodeType() == 1) {
                childElements.add((Element)childNodes.item(index));
            }
            ++index;
        }
        return childElements;
    }

    public static void initOutputElements() {
        for (IPath iPath : XmlUtils.listBuiltinFiles().values()) {
            XmlUtils.preloadXmlAnalysesOutput(iPath.toFile());
        }
        for (Map.Entry entry : XmlUtils.listFiles().entrySet()) {
            if (!XmlUtils.isAnalysisEnabled((String)entry.getKey())) continue;
            XmlUtils.preloadXmlAnalysesOutput((File)entry.getValue());
        }
    }

    public static void updateXmlFile(File file) {
        XmlUtils.preloadXmlAnalysesOutput(file);
    }

    private static void preloadXmlAnalysesOutput(File xmlFile) {
        if (!XmlUtils.xmlValidate(xmlFile).isOK()) {
            return;
        }
        XmlUtils.removeXmlOutput(xmlFile.getAbsolutePath());
        try {
            Document doc = XmlUtils.getDocumentFromFile(xmlFile);
            OutputType[] outputTypeArray = OutputType.values();
            int n = outputTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OutputType outputType = outputTypeArray[n2];
                NodeList outputNodes = doc.getElementsByTagName(outputType.getXmlElem());
                int i = 0;
                while (i < outputNodes.getLength()) {
                    Element node = (Element)outputNodes.item(i);
                    List<Element> headNodes = TmfXmlUtils.getChildElements(node, "head");
                    if (headNodes.size() != 1) {
                        return;
                    }
                    HashSet<String> analysesId = new HashSet<String>();
                    Element headElement = headNodes.get(0);
                    List<Element> analysisNodes = TmfXmlUtils.getChildElements(headElement, "analysis");
                    for (Element analysis : analysisNodes) {
                        String analysisId = analysis.getAttribute("id");
                        analysesId.add(analysisId);
                    }
                    String outputId = node.getAttribute("id");
                    List<Element> label = TmfXmlUtils.getChildElements(headNodes.get(0), "label");
                    String outputLabel = outputId;
                    if (!label.isEmpty()) {
                        Element labelElement = label.get(0);
                        outputLabel = labelElement.getAttribute("value");
                    }
                    XmlOutputElement output = new XmlOutputElement(xmlFile.getAbsolutePath(), outputType.getXmlElem(), outputId, outputLabel, analysesId);
                    XmlUtils.addXmlOutput(output);
                    ++i;
                }
                ++n2;
            }
            XmlUtils.updateCachedOuputElements();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Activator.logError(Messages.XmlUtils_ErrorOpeningFile, e);
        }
    }

    private static void updateCachedOuputElements() {
        fCachedOutputElement = ImmutableMultimap.copyOf(XML_OUTPUT_ELEMENTS);
    }

    private static void addXmlOutput(XmlOutputElement output) {
        XML_OUTPUT_ELEMENTS.put((Object)output.getPath(), (Object)output);
    }

    private static void removeXmlOutput(String path) {
        XML_OUTPUT_ELEMENTS.removeAll((Object)path);
    }

    public static void clearOutputElements() {
        XML_OUTPUT_ELEMENTS.clear();
    }

    public static Multimap<String, XmlOutputElement> getXmlOutputElements() {
        return fCachedOutputElement;
    }

    public static boolean isAnalysisEnabled(String xmlName) {
        return fEnabledFiles.contains(xmlName);
    }

    public static String createXmlFileString(String baseName) {
        IPath path = new Path(baseName).addFileExtension(XML_EXTENSION);
        return path.toString();
    }

    public static Map<String, @NonNull File> getEnabledFiles() {
        Map<@NonNull String, @NonNull File> files = XmlUtils.listFiles();
        HashMap<@NonNull String, @NonNull File> enabledFiles = new HashMap<String, File>();
        files.forEach((name, file) -> {
            if (XmlUtils.isAnalysisEnabled(name)) {
                enabledFiles.put((String)name, (File)file);
            }
        });
        return enabledFiles;
    }

    public static enum OutputType {
        TIME_GRAPH("timeGraphView"),
        XY("xyView");

        private final @NonNull String fXmlElem;

        private OutputType(String xmlElem) {
            this.fXmlElem = xmlElem;
        }

        public @NonNull String getXmlElem() {
            return this.fXmlElem;
        }
    }
}

