/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.graph;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.CycleDetectedException;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.ITmfGraphVisitor;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.TestGraphWorker;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfGraphStatistics;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class TmfGraphTest {
    private static final @NonNull IGraphWorker WORKER1 = new TestGraphWorker(1);
    private static final @NonNull IGraphWorker WORKER2 = new TestGraphWorker(2);
    private static final @NonNull IGraphWorker WORKER3 = new TestGraphWorker(3);
    private final @NonNull TmfGraph fGraph = new TmfGraph();
    private final @NonNull TmfVertex fV0 = new TmfVertex(0L);
    private final @NonNull TmfVertex fV1 = new TmfVertex(1L);

    @Test
    public void testDefaultConstructor() {
        TmfGraph g = new TmfGraph();
        Assert.assertEquals((long)0L, (long)g.size());
    }

    @Test
    public void testAddVertex() {
        this.fGraph.add(WORKER1, this.fV0);
        this.fGraph.add(WORKER1, this.fV1);
        List list = this.fGraph.getNodesOf(WORKER1);
        Assert.assertEquals((long)2L, (long)list.size());
        int i = 0;
        while (i < list.size() - 1) {
            TmfVertex vertex = (TmfVertex)list.get(i);
            Assert.assertEquals((long)i, (long)vertex.getTs());
            Assert.assertNull((Object)vertex.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE));
            Assert.assertNull((Object)vertex.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
            Assert.assertNull((Object)vertex.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
            Assert.assertNull((Object)vertex.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
            ++i;
        }
    }

    @Test
    public void testAppendVertex() {
        this.fGraph.append(WORKER1, this.fV0);
        TmfEdge edge = this.fGraph.append(WORKER1, this.fV1);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)TmfEdge.EdgeType.DEFAULT, (Object)edge.getType());
        Assert.assertEquals((Object)this.fV1, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)this.fV0, (Object)edge.getVertexFrom());
        Assert.assertEquals((long)(this.fV1.getTs() - this.fV0.getTs()), (long)edge.getDuration());
        List list = this.fGraph.getNodesOf(WORKER1);
        Assert.assertEquals((long)2L, (long)list.size());
        TmfGraphTest.checkLinkHorizontal(list);
        Assert.assertEquals((Object)this.fV0, (Object)this.fGraph.getHead(WORKER1));
        Assert.assertEquals((Object)this.fV1, (Object)this.fGraph.getTail(WORKER1));
        TmfVertex v2 = new TmfVertex(2L);
        edge = this.fGraph.append(WORKER1, v2, TmfEdge.EdgeType.BLOCKED);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)TmfEdge.EdgeType.BLOCKED, (Object)edge.getType());
        Assert.assertEquals((Object)v2, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)this.fV1, (Object)edge.getVertexFrom());
        Assert.assertEquals((long)(v2.getTs() - this.fV1.getTs()), (long)edge.getDuration());
        list = this.fGraph.getNodesOf(WORKER1);
        Assert.assertEquals((long)3L, (long)list.size());
        TmfGraphTest.checkLinkHorizontal(list);
        Assert.assertEquals((Object)this.fV0, (Object)this.fGraph.getHead(WORKER1));
        Assert.assertEquals((Object)v2, (Object)this.fGraph.getTail(WORKER1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalVertex() {
        this.fGraph.append(WORKER1, this.fV1);
        this.fGraph.append(WORKER1, this.fV0);
    }

    @Test
    public void testLink() {
        this.fGraph.add(WORKER1, this.fV0);
        TmfEdge edge = this.fGraph.link(this.fV0, this.fV1);
        Assert.assertEquals((Object)this.fV1, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)this.fV0, (Object)edge.getVertexFrom());
        Assert.assertEquals((Object)TmfEdge.EdgeType.DEFAULT, (Object)edge.getType());
        Assert.assertEquals((long)(this.fV1.getTs() - this.fV0.getTs()), (long)edge.getDuration());
        List list = this.fGraph.getNodesOf(WORKER1);
        Assert.assertEquals((long)2L, (long)list.size());
        edge = this.fV1.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)this.fV0, (Object)edge.getVertexFrom());
        edge = this.fV0.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)this.fV1, (Object)edge.getVertexTo());
        TmfVertex v2 = new TmfVertex(2L);
        this.fGraph.add(WORKER1, v2);
        edge = this.fGraph.link(this.fV1, v2, TmfEdge.EdgeType.NETWORK);
        Assert.assertEquals((Object)v2, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)this.fV1, (Object)edge.getVertexFrom());
        Assert.assertEquals((Object)TmfEdge.EdgeType.NETWORK, (Object)edge.getType());
        list = this.fGraph.getNodesOf(WORKER1);
        Assert.assertEquals((long)3L, (long)list.size());
        edge = this.fV1.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v2, (Object)edge.getVertexTo());
        edge = v2.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)this.fV1, (Object)edge.getVertexFrom());
        TmfVertex v3 = new TmfVertex(3L);
        this.fGraph.add(WORKER2, v3);
        edge = this.fGraph.link(v2, v3, TmfEdge.EdgeType.NETWORK);
        Assert.assertEquals((Object)v3, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)v2, (Object)edge.getVertexFrom());
        Assert.assertEquals((Object)TmfEdge.EdgeType.NETWORK, (Object)edge.getType());
        list = this.fGraph.getNodesOf(WORKER2);
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.fGraph.getNodesOf(WORKER1);
        Assert.assertEquals((long)3L, (long)list.size());
        edge = v3.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v2, (Object)edge.getVertexFrom());
        edge = v2.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v3, (Object)edge.getVertexTo());
    }

    private static void checkLinkHorizontal(List<TmfVertex> list) {
        if (list.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < list.size() - 1) {
            TmfVertex v0 = list.get(i);
            TmfVertex v1 = list.get(i + 1);
            TmfEdge edge = v0.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
            Assert.assertNotNull((Object)edge);
            Assert.assertEquals((Object)v0, (Object)edge.getVertexFrom());
            Assert.assertEquals((Object)v1, (Object)edge.getVertexTo());
            edge = v1.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
            Assert.assertNotNull((Object)edge);
            Assert.assertEquals((Object)v0, (Object)edge.getVertexFrom());
            Assert.assertEquals((Object)v1, (Object)edge.getVertexTo());
            Assert.assertNull((Object)v1.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
            Assert.assertNull((Object)v1.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
            Assert.assertNull((Object)v0.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE));
            Assert.assertNull((Object)v0.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE));
            ++i;
        }
    }

    @Test
    public void testTail() {
        this.fGraph.append(WORKER1, this.fV0);
        this.fGraph.append(WORKER1, this.fV1);
        Assert.assertEquals((Object)this.fV1, (Object)this.fGraph.getTail(WORKER1));
        Assert.assertEquals((Object)this.fV1, (Object)this.fGraph.removeTail(WORKER1));
        Assert.assertEquals((Object)this.fV0, (Object)this.fGraph.getTail(WORKER1));
    }

    @Test
    public void testHead() {
        Assert.assertNull((Object)this.fGraph.getHead());
        this.fGraph.append(WORKER1, this.fV0);
        this.fGraph.append(WORKER1, this.fV1);
        Assert.assertEquals((Object)this.fV0, (Object)this.fGraph.getHead());
        Assert.assertEquals((Object)this.fV0, (Object)this.fGraph.getHead(WORKER1));
        Assert.assertEquals((Object)this.fV0, (Object)this.fGraph.getHead(this.fV1));
        Assert.assertEquals((Object)this.fV0, (Object)this.fGraph.getHead(this.fV0));
    }

    @Test
    public void testHead2() {
        this.fGraph.append(WORKER1, this.fV1);
        this.fGraph.append(WORKER2, this.fV0);
        Assert.assertEquals((Object)this.fV0, (Object)this.fGraph.getHead());
        Assert.assertEquals((Object)this.fV1, (Object)this.fGraph.getHead(WORKER1));
        Assert.assertEquals((Object)this.fV0, (Object)this.fGraph.getHead(WORKER2));
        Assert.assertEquals((Object)this.fV1, (Object)this.fGraph.getHead(this.fV1));
        Assert.assertEquals((Object)this.fV0, (Object)this.fGraph.getHead(this.fV0));
    }

    @Test
    public void testParent() {
        this.fGraph.append(WORKER1, this.fV0);
        this.fGraph.append(WORKER2, this.fV1);
        Assert.assertEquals((Object)WORKER1, (Object)this.fGraph.getParentOf(this.fV0));
        Assert.assertNotSame((Object)WORKER1, (Object)this.fGraph.getParentOf(this.fV1));
        Assert.assertEquals((Object)WORKER2, (Object)this.fGraph.getParentOf(this.fV1));
    }

    @Test
    public void testVertexAt() {
        TmfVertex[] vertices = new TmfVertex[5];
        int i = 0;
        while (i < 5) {
            TmfVertex v;
            vertices[i] = v = new TmfVertex((long)((i + 1) * 5));
            this.fGraph.append(WORKER1, v);
            ++i;
        }
        Assert.assertEquals((Object)vertices[0], (Object)this.fGraph.getVertexAt(TmfTimestamp.fromSeconds((long)5L), WORKER1));
        Assert.assertEquals((Object)vertices[0], (Object)this.fGraph.getVertexAt(TmfTimestamp.fromSeconds((long)0L), WORKER1));
        Assert.assertEquals((Object)vertices[1], (Object)this.fGraph.getVertexAt(TmfTimestamp.fromSeconds((long)6L), WORKER1));
        Assert.assertEquals((Object)vertices[3], (Object)this.fGraph.getVertexAt(TmfTimestamp.fromSeconds((long)19L), WORKER1));
        Assert.assertNull((Object)this.fGraph.getVertexAt(TmfTimestamp.fromSeconds((long)19L), WORKER2));
        Assert.assertEquals((Object)vertices[3], (Object)this.fGraph.getVertexAt(TmfTimestamp.fromSeconds((long)20L), WORKER1));
        Assert.assertEquals((Object)vertices[4], (Object)this.fGraph.getVertexAt(TmfTimestamp.fromSeconds((long)21L), WORKER1));
        Assert.assertNull((Object)this.fGraph.getVertexAt(TmfTimestamp.fromSeconds((long)26L), WORKER1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCheckHorizontal() {
        TmfVertex n0 = new TmfVertex(10L);
        TmfVertex n1 = new TmfVertex(0L);
        n0.linkHorizontal(n1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCheckVertical() {
        TmfVertex n0 = new TmfVertex(10L);
        TmfVertex n1 = new TmfVertex(0L);
        n0.linkVertical(n1);
    }

    private static @NonNull TmfGraph buildFullGraph() {
        TmfGraph graph = new TmfGraph();
        long[] lArray = new long[12];
        lArray[1] = 2L;
        lArray[2] = 4L;
        lArray[3] = 5L;
        lArray[4] = 7L;
        lArray[5] = 8L;
        lArray[6] = 9L;
        lArray[7] = 10L;
        lArray[8] = 11L;
        lArray[9] = 12L;
        lArray[10] = 13L;
        lArray[11] = 15L;
        long[] timesA = lArray;
        long[] timesB = new long[]{1L, 2L, 3L, 5L, 6L, 8L, 11L, 12L, 14L};
        TmfVertex[] vertexA = new TmfVertex[timesA.length];
        TmfVertex[] vertexB = new TmfVertex[timesB.length];
        int i = 0;
        while (i < timesA.length) {
            vertexA[i] = new TmfVertex(timesA[i]);
            ++i;
        }
        i = 0;
        while (i < timesB.length) {
            vertexB[i] = new TmfVertex(timesB[i]);
            ++i;
        }
        graph.append(WORKER1, vertexA[0]);
        graph.append(WORKER1, vertexA[1]);
        graph.add(WORKER1, vertexA[2]);
        graph.append(WORKER1, vertexA[3]);
        graph.append(WORKER1, vertexA[4]);
        graph.append(WORKER1, vertexA[5]);
        graph.append(WORKER1, vertexA[6]);
        graph.add(WORKER1, vertexA[7]);
        graph.append(WORKER1, vertexA[8]);
        graph.append(WORKER1, vertexA[9]);
        graph.append(WORKER1, vertexA[10]);
        graph.append(WORKER1, vertexA[11]);
        graph.append(WORKER2, vertexB[0]);
        graph.append(WORKER2, vertexB[1]);
        graph.append(WORKER2, vertexB[2]);
        graph.append(WORKER2, vertexB[3]);
        graph.add(WORKER2, vertexB[4]);
        graph.append(WORKER2, vertexB[5]);
        graph.append(WORKER2, vertexB[6]);
        graph.add(WORKER2, vertexB[7]);
        graph.append(WORKER2, vertexB[8]);
        vertexA[1].linkVertical(vertexB[1]);
        vertexB[3].linkVertical(vertexA[3]);
        vertexA[5].linkVertical(vertexB[5]);
        vertexB[6].linkVertical(vertexA[8]);
        vertexA[9].linkVertical(vertexB[7]);
        return graph;
    }

    @Test
    public void testScanCount() {
        TmfGraph graph = TmfGraphTest.buildFullGraph();
        ScanCountVertex visitor = new ScanCountVertex();
        graph.scanLineTraverse(graph.getHead(WORKER1), (ITmfGraphVisitor)visitor);
        Assert.assertEquals((long)21L, (long)visitor.nbVertex);
        Assert.assertEquals((long)6L, (long)visitor.nbStartVertex);
        Assert.assertEquals((long)5L, (long)visitor.nbVLink);
        Assert.assertEquals((long)15L, (long)visitor.nbHLink);
    }

    @Test
    public void testGraphStatistics() {
        TmfGraph graph = TmfGraphTest.buildFullGraph();
        TmfGraphStatistics stats = new TmfGraphStatistics();
        stats.computeGraphStatistics(graph, WORKER1);
        Assert.assertEquals((long)12L, (long)stats.getSum(WORKER1));
        Assert.assertEquals((long)11L, (long)stats.getSum(WORKER2));
        Assert.assertEquals((long)23L, (long)stats.getSum());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHorizontalSelfLink() {
        TmfVertex n0 = new TmfVertex(0L);
        n0.linkHorizontal(n0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVerticalSelfLink() {
        TmfVertex n0 = new TmfVertex(0L);
        n0.linkVertical(n0);
    }

    @Test(expected=CycleDetectedException.class)
    public void testHorizontalCycle() {
        TmfVertex n0 = new TmfVertex(0L);
        TmfVertex n1 = new TmfVertex(0L);
        n0.linkHorizontal(n1);
        n1.linkHorizontal(n0);
        TmfGraph graph = new TmfGraph();
        graph.add(WORKER1, n0);
        graph.add(WORKER1, n1);
        graph.scanLineTraverse(n0, (ITmfGraphVisitor)new DuplicateDetectorVisitor());
    }

    @Test
    public void testScanLineTerminates() {
        TmfVertex n10 = new TmfVertex(0L);
        TmfVertex n20 = new TmfVertex(0L);
        TmfVertex n21 = new TmfVertex(1L);
        TmfVertex n30 = new TmfVertex(1L);
        TmfGraph graph = new TmfGraph();
        n10.linkVertical(n20);
        n20.linkHorizontal(n21);
        n21.linkVertical(n30);
        graph.add(WORKER1, n10);
        graph.add(WORKER2, n20);
        graph.add(WORKER2, n21);
        graph.add(WORKER3, n30);
        graph.scanLineTraverse(n20, (ITmfGraphVisitor)new DuplicateDetectorVisitor());
    }

    private class DuplicateDetectorVisitor
    implements ITmfGraphVisitor {
        private final Set<TmfVertex> set = new HashSet<TmfVertex>();

        private DuplicateDetectorVisitor() {
        }

        public void visitHead(TmfVertex vertex) {
        }

        public void visit(TmfEdge edge, boolean horizontal) {
        }

        public void visit(TmfVertex vertex) {
            if (this.set.contains(vertex)) {
                throw new RuntimeException("node already visited");
            }
            this.set.add(vertex);
        }
    }

    private class ScanCountVertex
    implements ITmfGraphVisitor {
        public int nbVertex = 0;
        public int nbVLink = 0;
        public int nbHLink = 0;
        public int nbStartVertex = 0;

        private ScanCountVertex() {
        }

        public void visitHead(TmfVertex node) {
            ++this.nbStartVertex;
        }

        public void visit(TmfVertex node) {
            ++this.nbVertex;
        }

        public void visit(TmfEdge edge, boolean horizontal) {
            if (horizontal) {
                ++this.nbHLink;
            } else {
                ++this.nbVLink;
            }
        }
    }
}

