/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.protocol;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.junit.Assert;
import org.junit.Test;

public class ProtocolTest {
    @Test
    public void TestProtocolAttributes() {
        Assert.assertEquals((Object)PcapProtocol.PCAP.getName(), (Object)"Packet Capture");
        Assert.assertEquals((Object)PcapProtocol.PCAP.getShortName(), (Object)"pcap");
        Assert.assertEquals((Object)PcapProtocol.PCAP.getLayer(), (Object)PcapProtocol.Layer.LAYER_0);
    }

    @Test
    public void TestgetProtocols() {
        ArrayList<PcapProtocol> manualListLayer = new ArrayList<PcapProtocol>();
        PcapProtocol.Layer[] layerArray = PcapProtocol.Layer.values();
        int n = layerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PcapProtocol.Layer layer = layerArray[n2];
            Assert.assertNotNull((Object)layer);
            Collection listLayer = PcapProtocol.getProtocolsOnLayer((PcapProtocol.Layer)layer);
            manualListLayer.clear();
            switch (layer) {
                case LAYER_0: {
                    manualListLayer.add(PcapProtocol.PCAP);
                    break;
                }
                case LAYER_1: {
                    break;
                }
                case LAYER_2: {
                    manualListLayer.add(PcapProtocol.ETHERNET_II);
                    break;
                }
                case LAYER_3: {
                    manualListLayer.add(PcapProtocol.IPV4);
                    break;
                }
                case LAYER_4: {
                    manualListLayer.add(PcapProtocol.TCP);
                    manualListLayer.add(PcapProtocol.UDP);
                    break;
                }
                case LAYER_5: {
                    break;
                }
                case LAYER_6: {
                    break;
                }
                case LAYER_7: {
                    manualListLayer.add(PcapProtocol.UNKNOWN);
                    break;
                }
                default: {
                    Assert.fail((String)"Illegal layer value!");
                }
            }
            Assert.assertEquals(manualListLayer, (Object)listLayer);
            ++n2;
        }
    }
}

