/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.IAnnotation;
import org.eclipse.tracecompass.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfTreeDataModelTest {
    private static final String TO_STRING = "toString";
    private static final String HASH_CODE = "hashCode";
    private static final String EQUALS = "equals";
    private static final @NonNull List<@NonNull String> LABELS0 = Arrays.asList("label1, label2, label3");
    private static final long ID0 = 0L;
    private static final long PARENT_ID0 = -1L;
    private static final OutputElementStyle STYLE0 = null;
    private static final @NonNull List<@NonNull String> LABELS1 = Arrays.asList("label4, label5, label6", "label7");
    private static final long ID1 = 1L;
    private static final long PARENT_ID1 = 0L;
    private static final boolean HAS_MODEL1 = false;
    private static final @NonNull OutputElementStyle STYLE1 = new OutputElementStyle("1");
    private static final long ID2 = 2L;
    private static final long PARENT_ID2 = -1L;
    private static final OutputElementStyle STYLE3 = null;
    private static final String NAME = "Name";
    private static final String SCOPE = "scope";
    private TmfTreeDataModel fModel0 = null;
    private TmfTreeDataModel fModel1 = null;

    @Before
    public void setUp() {
        this.fModel0 = TmfTreeDataModelTest.createModel(0);
        this.fModel1 = TmfTreeDataModelTest.createModel(1);
    }

    @Test
    public void testConstructors() {
        TmfTreeDataModel model0 = TmfTreeDataModelTest.createModel(0);
        Assert.assertEquals((long)0L, (long)model0.getId());
        Assert.assertEquals((long)-1L, (long)model0.getParentId());
        Assert.assertEquals((Object)LABELS0.get(0), (Object)model0.getName());
        Assert.assertEquals(LABELS0, (Object)model0.getLabels());
        Assert.assertTrue((boolean)model0.hasRowModel());
        Assert.assertEquals((Object)STYLE0, (Object)model0.getStyle());
        TmfTreeDataModel model1 = TmfTreeDataModelTest.createModel(1);
        Assert.assertEquals((long)1L, (long)model1.getId());
        Assert.assertEquals((long)0L, (long)model1.getParentId());
        Assert.assertEquals((Object)LABELS1.get(0), (Object)model1.getName());
        Assert.assertEquals(LABELS1, (Object)model1.getLabels());
        Assert.assertFalse((boolean)model1.hasRowModel());
        Assert.assertEquals((Object)STYLE1, (Object)model1.getStyle());
        TmfTreeDataModel model2 = TmfTreeDataModelTest.createModel(2);
        Assert.assertEquals((long)2L, (long)model2.getId());
        Assert.assertEquals((long)-1L, (long)model2.getParentId());
        Assert.assertEquals((Object)NAME, (Object)model2.getName());
        Assert.assertEquals((long)1L, (long)model2.getLabels().size());
        Assert.assertEquals((Object)NAME, model2.getLabels().get(0));
        Assert.assertTrue((boolean)model2.hasRowModel());
        Assert.assertEquals((Object)STYLE3, (Object)model2.getStyle());
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)EQUALS, (boolean)this.fModel0.equals((Object)this.fModel0));
        Assert.assertTrue((String)EQUALS, (boolean)this.fModel1.equals((Object)this.fModel1));
        Assert.assertTrue((String)EQUALS, (!this.fModel0.equals((Object)this.fModel1) ? 1 : 0) != 0);
        Assert.assertTrue((String)EQUALS, (!this.fModel1.equals((Object)this.fModel0) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        TmfTreeDataModel model0 = TmfTreeDataModelTest.createModel(0);
        TmfTreeDataModel model1 = TmfTreeDataModelTest.createModel(1);
        Assert.assertTrue((String)EQUALS, (boolean)model0.equals((Object)this.fModel0));
        Assert.assertTrue((String)EQUALS, (boolean)this.fModel0.equals((Object)model0));
        Assert.assertTrue((String)EQUALS, (boolean)model1.equals((Object)this.fModel1));
        Assert.assertTrue((String)EQUALS, (boolean)this.fModel1.equals((Object)model1));
    }

    @Test
    public void testEqualsTransivity() {
        TmfTreeDataModel model0 = TmfTreeDataModelTest.createModel(0);
        TmfTreeDataModel model1 = TmfTreeDataModelTest.createModel(0);
        TmfTreeDataModel model2 = TmfTreeDataModelTest.createModel(0);
        Assert.assertTrue((String)EQUALS, (boolean)model0.equals((Object)model1));
        Assert.assertTrue((String)EQUALS, (boolean)model1.equals((Object)model2));
        Assert.assertTrue((String)EQUALS, (boolean)model0.equals((Object)model2));
    }

    @Test
    public void testEqualsNull() {
        Object model0 = null;
        Assert.assertFalse((String)EQUALS, (boolean)this.fModel0.equals(model0));
        Assert.assertFalse((String)EQUALS, (boolean)this.fModel1.equals(model0));
    }

    @Test
    public void testHashCode() {
        TmfTreeDataModel model0 = TmfTreeDataModelTest.createModel(0);
        TmfTreeDataModel model1 = TmfTreeDataModelTest.createModel(1);
        Assert.assertTrue((String)HASH_CODE, (this.fModel0.hashCode() == model0.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)HASH_CODE, (this.fModel1.hashCode() == model1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)HASH_CODE, (this.fModel0.hashCode() != model1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)HASH_CODE, (this.fModel1.hashCode() != model0.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((String)TO_STRING, (Object)"<name=[label1, label2, label3] id=0 parentId=-1 style=null hasRowModel=true>", (Object)this.fModel0.toString());
        Assert.assertEquals((String)TO_STRING, (Object)"<name=[label4, label5, label6, label7] id=1 parentId=0 style=Style [1, {}] hasRowModel=false>", (Object)this.fModel1.toString());
        TmfTreeDataModel model2 = TmfTreeDataModelTest.createModel(2);
        Assert.assertEquals((String)TO_STRING, (Object)"<name=[Name] id=2 parentId=-1 style=null hasRowModel=true>", (Object)model2.toString());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testCompositeTree() {
        ArrayList<DummyDataProvider> ddps = new ArrayList<DummyDataProvider>();
        int i = 0;
        while (i < 3) {
            ddps.add(new DummyDataProvider(i));
            ++i;
        }
        @NonNull @NonNull TmfTreeCompositeDataProvider composite = new TmfTreeCompositeDataProvider(ddps, "composite-dummy");
        Assert.assertNotNull((Object)composite);
        NullProgressMonitor monitor = new NullProgressMonitor();
        @NonNull @NonNull TmfModelResponse tree = composite.fetchTree(Collections.emptyMap(), (IProgressMonitor)monitor);
        @NonNull TmfTreeModel model = (TmfTreeModel)tree.getModel();
        Assert.assertNotNull((Object)model);
        Assert.assertEquals(Arrays.asList("header"), (Object)model.getHeaders());
        Assert.assertEquals((long)3L, (long)model.getEntries().size());
        @NonNull TmfModelResponse returnVal = composite.fetchAnnotationCategories(Collections.emptyMap(), (IProgressMonitor)monitor);
        AnnotationCategoriesModel categoryModel = (AnnotationCategoriesModel)returnVal.getModel();
        Assert.assertNotNull((Object)categoryModel);
        Assert.assertEquals(Arrays.asList("common", "0", "1", "2"), (Object)categoryModel.getAnnotationCategories());
        @NonNull TmfModelResponse annotations = composite.fetchAnnotations(Collections.emptyMap(), (IProgressMonitor)monitor);
        AnnotationModel annotationsModel = (AnnotationModel)annotations.getModel();
        Assert.assertNotNull((Object)annotationsModel);
        @NonNull Collection collection = (Collection)annotationsModel.getAnnotations().get("test");
        Assert.assertNotNull((Object)collection);
        Assert.assertEquals((long)6L, (long)collection.size());
    }

    private static @NonNull TmfTreeDataModel createModel(int i) {
        switch (i) {
            case 0: {
                return new TmfTreeDataModel(0L, -1L, LABELS0);
            }
            case 1: {
                return new TmfTreeDataModel(1L, 0L, LABELS1, false, STYLE1);
            }
            case 2: {
                return new TmfTreeDataModel(2L, -1L, NAME);
            }
        }
        return new TmfTreeDataModel(0L, -1L, LABELS0);
    }

    @NonNullByDefault
    private static class DummyDataProvider
    implements ITmfTreeDataProvider<TmfTreeDataModel>,
    IOutputAnnotationProvider {
        private final int fModelNo;

        public DummyDataProvider(int modelNo) {
            this.fModelNo = modelNo;
        }

        public TmfModelResponse<TmfTreeModel<TmfTreeDataModel>> fetchTree(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
            ArrayList<TmfTreeDataModel> modelList = new ArrayList<TmfTreeDataModel>();
            TmfTreeDataModel model = TmfTreeDataModelTest.createModel(this.fModelNo);
            modelList.add(model);
            long parentId = model.getParentId();
            while (parentId != -1L) {
                TmfTreeDataModel parent = TmfTreeDataModelTest.createModel((int)parentId);
                modelList.add(0, parent);
                parentId = parent.getParentId();
            }
            TmfModelResponse response = new TmfModelResponse((Object)new TmfTreeModel(Arrays.asList("header"), modelList, TmfTreeDataModelTest.SCOPE), ITmfResponse.Status.COMPLETED, "");
            return response;
        }

        public @NonNull String getId() {
            return "dummy";
        }

        public TmfModelResponse<AnnotationCategoriesModel> fetchAnnotationCategories(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
            AnnotationCategoriesModel model = new AnnotationCategoriesModel(Arrays.asList("common", Integer.toString(this.fModelNo)));
            return new TmfModelResponse((Object)model, ITmfResponse.Status.COMPLETED, "");
        }

        public TmfModelResponse<AnnotationModel> fetchAnnotations(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
            HashMap<String, List<Annotation>> annotations = new HashMap<String, List<Annotation>>();
            annotations.put("test", Arrays.asList(new Annotation(0L, 1L, 2L, IAnnotation.AnnotationType.CHART, "Hi" + this.fModelNo, new OutputElementStyle("black")), new Annotation(0L, 1L, 2L, IAnnotation.AnnotationType.CHART, "Hello", new OutputElementStyle("pink"))));
            annotations.put("test" + this.fModelNo, Arrays.asList(new Annotation(0L, 1L, 2L, IAnnotation.AnnotationType.CHART, "bye", new OutputElementStyle("white"))));
            AnnotationModel model = new AnnotationModel(annotations);
            return new TmfModelResponse((Object)model, ITmfResponse.Status.COMPLETED, "");
        }
    }
}

