/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
@NonNullByDefault
public class ExportToTsvTest {
    private static final String HEADER_TEXT = "Timestamp\tHost\tLogger\tFile\tLine\tMessage";
    private static final String EVENT1_TEXT = "01:01:01.000 000 000\tHostA\tLoggerA\tSourceFile\t4\tMessage A";
    private static final String EVENT2_TEXT = "02:02:02.000 000 000\tHostB\tLoggerB\tSourceFile\t5\tMessage B";
    private static final String EVENT3_TEXT = "03:03:03.000 000 000\tHostC\tLoggerC\tSourceFile\t6\tMessage C";
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String TRACE_NAME = "syslog_collapse";
    private static final String TRACE_PATH = "testfiles/syslog_collapse";
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static final String EXPORT_TO_TSV = "Export To Text...";
    private static final int TIMEOUT = 20000;
    private static @Nullable File fTestFile = null;
    private static SWTWorkbenchBot fBot = new SWTWorkbenchBot();
    private @Nullable SWTBotEditor fEditorBot;
    private @Nullable String fAbsolutePath;
    private static final Logger fLogger = Logger.getRootLogger();

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            fTestFile = new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
        File testFile = fTestFile;
        Assert.assertNotNull((Object)testFile);
        Assume.assumeTrue((boolean)testFile.exists());
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
        fLogger.removeAllAppenders();
    }

    @Before
    public void before() {
        File testFile = fTestFile;
        Assert.assertNotNull((Object)testFile);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, testFile.getAbsolutePath(), TRACE_TYPE);
        this.fEditorBot = SWTBotUtils.activateEditor(fBot, testFile.getName());
        this.fAbsolutePath = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + "exportToTsvTest.tsv";
        TmfFileDialogFactory.setOverrideFiles((String[])new String[]{this.fAbsolutePath});
    }

    @After
    public void after() {
        fBot.closeAllEditors();
    }

    @Test
    public void testExport() throws IOException {
        SWTBotEditor editorBot = this.fEditorBot;
        Assert.assertNotNull((Object)editorBot);
        SWTBotTable tableBot = editorBot.bot().table();
        tableBot.getTableItem(1).contextMenu(EXPORT_TO_TSV).click();
        File file = new File(this.fAbsolutePath);
        fBot.waitUntil((ICondition)new FileLargerThanZeroCondition(file));
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                long lines = br.lines().count();
                Assert.assertEquals((String)"Line count", (long)23L, (long)lines);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            new File(this.fAbsolutePath).delete();
        }
    }

    @Test
    public void testExportWithFilter() throws IOException {
        SWTBotEditor editorBot = this.fEditorBot;
        Assert.assertNotNull((Object)editorBot);
        SWTBotTable tableBot = editorBot.bot().table();
        tableBot.getTableItem(0).click(3);
        SWTBotText textBot = editorBot.bot().text();
        textBot.typeText("LoggerA|LoggerB|LoggerC");
        textBot.pressShortcut(new KeyStroke[]{Keystrokes.CTRL, Keystrokes.CR});
        fBot.waitUntil(Conditions.tableHasRows((SWTBotTable)tableBot, (int)6), 5000L);
        tableBot.getTableItem(1).contextMenu(EXPORT_TO_TSV).click();
        this.assertTsvContentsEquals((List<String>)ImmutableList.of((Object)HEADER_TEXT, (Object)EVENT1_TEXT, (Object)EVENT2_TEXT, (Object)EVENT3_TEXT));
    }

    private void assertTsvContentsEquals(List<String> expected) throws FileNotFoundException, IOException {
        File file = new File(this.fAbsolutePath);
        fBot.waitUntil((ICondition)new FileLargerThanZeroCondition(file));
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                List lines = br.lines().collect(Collectors.toList());
                Assert.assertEquals((String)"File content", expected, lines);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            file.delete();
        }
    }

    private static final class FileLargerThanZeroCondition
    implements ICondition {
        private File fFile;

        public FileLargerThanZeroCondition(File file) {
            this.fFile = file;
        }

        public boolean test() throws Exception {
            return this.fFile.length() >= 1L;
        }

        public void init(@Nullable SWTBot bot) {
        }

        public String getFailureMessage() {
            return "File is still of length 0 : " + this.fFile.getAbsolutePath();
        }
    }
}

