/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.project.model;

import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfViewsElement;
import org.eclipse.tracecompass.tmf.ui.tests.shared.ProjectModelTestData;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitTimeoutException;
import org.eclipse.tracecompass.tmf.ui.tests.stubs.analysis.TestAnalysisUi;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectModelAnalysisTest {
    public static final String MODULE_UI = "org.eclipse.linuxtools.tmf.ui.tests.test";
    private TmfProjectElement fixture;

    @Before
    public void setUp() {
        try {
            this.fixture = ProjectModelTestData.getFilledProject();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void cleanUp() {
        ProjectModelTestData.deleteProject(this.fixture);
    }

    private TmfTraceElement getTraceElement() {
        TmfTraceElement trace = null;
        TmfTraceFolder tracesFolder = this.fixture.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        for (ITmfProjectModelElement element : tracesFolder.getChildren()) {
            TmfTraceElement traceElement;
            if (!(element instanceof TmfTraceElement) || !(traceElement = (TmfTraceElement)element).getName().equals(ProjectModelTestData.getTraceName())) continue;
            trace = traceElement;
        }
        Assert.assertNotNull(trace);
        return trace;
    }

    @Test
    public void testListAnalysis() {
        TmfTraceElement trace = this.getTraceElement();
        List analysisList = trace.getAvailableAnalysis();
        Assert.assertFalse((boolean)analysisList.isEmpty());
        TmfAnalysisElement analysis = null;
        for (TmfAnalysisElement analysisElement : analysisList) {
            if (!analysisElement.getAnalysisId().equals(MODULE_UI)) continue;
            analysis = analysisElement;
        }
        Assert.assertNotNull(analysis);
        Assert.assertEquals((Object)"Test analysis in UI", (Object)analysis.getName());
    }

    @Test
    public void testPopulate() {
        TmfTraceElement trace = this.getTraceElement();
        Optional<TmfViewsElement> possibleViewsElem = trace.getChildren().stream().filter(child -> child instanceof TmfViewsElement).map(elem -> (TmfViewsElement)elem).findFirst();
        Assert.assertTrue((boolean)possibleViewsElem.isPresent());
        TmfViewsElement viewsElem = possibleViewsElem.get();
        Optional<TmfAnalysisElement> possibleAnalysisElem = viewsElem.getChildren().stream().filter(child -> child instanceof TmfAnalysisElement).map(elem -> (TmfAnalysisElement)elem).filter(analysisElem -> analysisElem.getAnalysisId().equals(MODULE_UI)).findFirst();
        Assert.assertTrue((boolean)possibleAnalysisElem.isPresent());
        Assert.assertEquals((Object)"Test analysis in UI", (Object)possibleAnalysisElem.get().getName());
    }

    @Test
    public void testInstantiate() {
        TmfTraceElement traceElement = this.getTraceElement();
        TmfAnalysisElement analysis = traceElement.getAvailableAnalysis().stream().filter(availableAnalysis -> availableAnalysis.getAnalysisId().equals(MODULE_UI)).findFirst().get();
        traceElement.closeEditors();
        analysis.activateParentTrace();
        try {
            ProjectModelTestData.delayUntilTraceOpened((TmfCommonProjectElement)traceElement);
        }
        catch (WaitTimeoutException e) {
            Assert.fail((String)"The analysis parent did not open in a reasonable time");
        }
        ITmfTrace trace = traceElement.getTrace();
        Assert.assertNotNull((Object)trace);
        TestAnalysisUi module = (TestAnalysisUi)trace.getAnalysisModule(analysis.getAnalysisId());
        Assert.assertNotNull((Object)((Object)module));
        traceElement.closeEditors();
    }
}

