/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine.phases;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CertificateChecker {
    private static final String CC = "certificate checker";
    private ArrayList<File> artifacts;
    private final IProvisioningAgent agent;

    public CertificateChecker() {
        this(null);
    }

    public CertificateChecker(IProvisioningAgent agent) {
        this.agent = agent;
        this.artifacts = new ArrayList();
    }

    public IStatus start() {
        IStatus iStatus;
        Class<?> clazz;
        BundleContext context = EngineActivator.getContext();
        try {
            clazz = Class.forName("org.eclipse.osgi.signedcontent.SignedContentFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ServiceReference contentFactoryRef = context.getServiceReference(clazz);
        SignedContentFactory verifierFactory = (SignedContentFactory)context.getService(contentFactoryRef);
        try {
            iStatus = this.checkCertificates(verifierFactory);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            context.ungetService(contentFactoryRef);
            throw throwable;
        }
        context.ungetService(contentFactoryRef);
        return iStatus;
    }

    private IStatus checkCertificates(SignedContentFactory verifierFactory) {
        Certificate[][] unTrustedCertificateChains;
        String[] details;
        int i;
        UIServices serviceUI = (UIServices)this.agent.getService(UIServices.SERVICE_NAME);
        SignedContent content = null;
        SignerInfo[] signerInfo = null;
        ArrayList<Certificate> untrusted = new ArrayList<Certificate>();
        ArrayList<File> unsigned = new ArrayList<File>();
        ArrayList<Certificate[]> untrustedChain = new ArrayList<Certificate[]>();
        HashMap<Certificate, ArrayList<File>> untrustedArtifacts = new HashMap<Certificate, ArrayList<File>>();
        IStatus status = Status.OK_STATUS;
        if (this.artifacts.size() == 0 || serviceUI == null) {
            return status;
        }
        Iterator<File> iterator = this.artifacts.iterator();
        while (iterator.hasNext()) {
            File artifact = iterator.next();
            try {
                content = verifierFactory.getSignedContent(artifact);
                if (!content.isSigned()) {
                    unsigned.add(artifact);
                    continue;
                }
                signerInfo = content.getSignerInfos();
            }
            catch (GeneralSecurityException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentError, (Throwable)e);
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentIOError, (Throwable)e);
            }
            i = 0;
            while (i < signerInfo.length) {
                Iterator<Object> iterator2;
                StringBuilder message;
                if (!signerInfo[i].isTrusted()) {
                    Certificate[] certificateChain = signerInfo[i].getCertificateChain();
                    if (!untrusted.contains(certificateChain[0])) {
                        untrusted.add(certificateChain[0]);
                        untrustedChain.add(certificateChain);
                    }
                    if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNTRUSTED) {
                        if (untrustedArtifacts.containsKey(certificateChain[0])) {
                            ((Collection)untrustedArtifacts.get(certificateChain[0])).add(artifact);
                        } else {
                            untrustedArtifacts.put(certificateChain[0], new ArrayList<File>(Arrays.asList(artifact)));
                        }
                    }
                }
                if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNSIGNED && !unsigned.isEmpty()) {
                    message = new StringBuilder("The following artifacts are unsigned:\n");
                    iterator2 = unsigned.iterator();
                    while (iterator2.hasNext()) {
                        File file = (File)iterator2.next();
                        message.append(NLS.bind((String)"  {0}\n", (Object)file.getPath()));
                    }
                    DebugHelper.debug(CC, message.toString());
                }
                if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNTRUSTED && !untrusted.isEmpty()) {
                    message = new StringBuilder("The following certificates are untrusted:\n");
                    iterator2 = untrustedArtifacts.keySet().iterator();
                    while (iterator2.hasNext()) {
                        Certificate cert = (Certificate)iterator2.next();
                        message.append(String.valueOf(cert.toString()) + "\n");
                        message.append("  used by the following artifacts:\n");
                        Iterator iterator3 = ((Collection)untrustedArtifacts.get(cert)).iterator();
                        while (iterator3.hasNext()) {
                            File file = (File)iterator3.next();
                            message.append(NLS.bind((String)"    {0}\n", (Object)file.getPath()));
                        }
                    }
                    DebugHelper.debug(CC, message.toString());
                }
                ++i;
            }
        }
        String policy = this.getUnsignedContentPolicy();
        if (!unsigned.isEmpty() && "fail".equals(policy)) {
            return new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.CertificateChecker_UnsignedNotAllowed, unsigned));
        }
        if ("allow".equals(policy) || unsigned.isEmpty()) {
            details = null;
        } else {
            details = new String[unsigned.size()];
            i = 0;
            while (i < details.length) {
                details[i] = ((File)unsigned.get(i)).toString();
                ++i;
            }
        }
        if (untrusted.isEmpty()) {
            unTrustedCertificateChains = null;
        } else {
            unTrustedCertificateChains = new Certificate[untrustedChain.size()][];
            int i2 = 0;
            while (i2 < untrustedChain.size()) {
                unTrustedCertificateChains[i2] = (Certificate[])untrustedChain.get(i2);
                ++i2;
            }
        }
        if (details == null && unTrustedCertificateChains == null) {
            return status;
        }
        UIServices.TrustInfo trustInfo = serviceUI.getTrustInfo(unTrustedCertificateChains, details);
        if (!trustInfo.trustUnsignedContent()) {
            return Status.CANCEL_STATUS;
        }
        Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
        if (unTrustedCertificateChains != null && trustedCertificates == null) {
            return new Status(8, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        if (trustedCertificates != null) {
            int i3 = 0;
            while (i3 < trustedCertificates.length) {
                untrusted.remove(trustedCertificates[i3]);
                ++i3;
            }
        }
        if (untrusted.size() > 0) {
            return new Status(8, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        if (trustInfo.persistTrust()) {
            return this.persistTrustedCertificates(trustedCertificates);
        }
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus persistTrustedCertificates(Certificate[] trustedCertificates) {
        ServiceTracker trustEngineTracker;
        block14: {
            block13: {
                Class<?> clazz;
                if (trustedCertificates == null) {
                    return new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
                }
                try {
                    clazz = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                trustEngineTracker = new ServiceTracker(EngineActivator.getContext(), clazz, null);
                trustEngineTracker.open();
                Object[] trustEngines = trustEngineTracker.getServices();
                try {
                    if (trustEngines == null) {
                        Object var14_4 = null;
                        break block13;
                    }
                    Certificate[] certificateArray = trustedCertificates;
                    int n = trustedCertificates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Certificate trustedCertificate = certificateArray[n2];
                        Object[] objectArray = trustEngines;
                        int n3 = trustEngines.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object engine = objectArray[n4];
                            TrustEngine trustEngine = (TrustEngine)engine;
                            if (trustEngine.isReadOnly()) {
                                ++n4;
                                continue;
                            }
                            try {
                                trustEngine.addTrustAnchor(trustedCertificate, trustedCertificate.toString());
                                break;
                            }
                            catch (IOException e) {
                                Status status = new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                                Object var14_5 = null;
                                trustEngineTracker.close();
                                return status;
                            }
                            catch (GeneralSecurityException e) {
                                Status status = new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateError, (Throwable)e);
                                Object var14_6 = null;
                                trustEngineTracker.close();
                                return status;
                            }
                        }
                        ++n2;
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var14_7 = null;
                    trustEngineTracker.close();
                    throw throwable;
                }
            }
            trustEngineTracker.close();
            return null;
        }
        Object var14_8 = null;
        trustEngineTracker.close();
        return Status.OK_STATUS;
    }

    private String getUnsignedContentPolicy() {
        String policy = EngineActivator.getContext().getProperty("eclipse.p2.unsignedPolicy");
        if (policy == null) {
            policy = "prompt";
        }
        return policy;
    }

    public void add(File toAdd) {
        this.artifacts.add(toAdd);
    }

    public void add(Object[] toAdd) {
        int i = 0;
        while (i < toAdd.length) {
            if (toAdd[i] instanceof File) {
                this.add((File)toAdd[i]);
            }
            ++i;
        }
    }
}

