/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.planar.AbstractMultiShape;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IMultiShape;
import org.eclipse.gef4.geometry.planar.IRotatable;
import org.eclipse.gef4.geometry.planar.IScalable;
import org.eclipse.gef4.geometry.planar.ITranslatable;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polygon;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.Ring;
import org.eclipse.gef4.geometry.planar.ShapeUtils;

public class Region
extends AbstractMultiShape
implements ITranslatable<Region>,
IScalable<Region>,
IRotatable<Ring> {
    private static final long serialVersionUID = 1L;
    private ArrayList<Rectangle> rects;

    private static void cutH(double y, ArrayList<Rectangle> parts) {
        for (Rectangle r : new ArrayList<Rectangle>(parts)) {
            if (!(r.y < y) || !(y < r.y + r.height)) continue;
            parts.remove(r);
            parts.add(new Rectangle(r.x, r.y, r.width, y - r.y));
            parts.add(new Rectangle(r.x, y, r.width, r.y + r.height - y));
        }
    }

    private static void cutV(double x, ArrayList<Rectangle> parts) {
        for (Rectangle r : new ArrayList<Rectangle>(parts)) {
            if (!(r.x < x) || !(x < r.x + r.width)) continue;
            parts.remove(r);
            parts.add(new Rectangle(r.x, r.y, x - r.x, r.height));
            parts.add(new Rectangle(x, r.y, r.x + r.width - x, r.height));
        }
    }

    public Region() {
        this.rects = new ArrayList();
    }

    public Region(Rectangle ... rectangles) {
        this();
        this.rects.add(rectangles[0].getCopy());
        int i = 1;
        while (i < rectangles.length) {
            this.add(rectangles[i].getCopy());
            ++i;
        }
    }

    public Region(Region other) {
        this.rects = new ArrayList(other.rects.size());
        for (Rectangle or : other.rects) {
            this.rects.add(or.getCopy());
        }
    }

    public Region add(Rectangle rectangle) {
        ArrayList<Rectangle> toAdd = new ArrayList<Rectangle>(1);
        toAdd.add(rectangle.getCopy());
        for (Rectangle retain : this.rects) {
            for (Rectangle addend : new ArrayList(toAdd)) {
                ArrayList<Rectangle> parts = new ArrayList<Rectangle>(8);
                parts.add(addend);
                if (addend.x <= retain.x && retain.x <= addend.x + addend.width || retain.x <= addend.x && addend.x <= retain.x + retain.width) {
                    Region.cutH(retain.y, parts);
                    Region.cutH(retain.y + retain.height, parts);
                }
                if (addend.y <= retain.y && retain.y <= addend.y + addend.height || retain.y <= addend.y && addend.y <= retain.y + retain.height) {
                    Region.cutV(retain.x, parts);
                    Region.cutV(retain.x + retain.width, parts);
                }
                Iterator<Rectangle> p = parts.iterator();
                while (p.hasNext()) {
                    if (!retain.contains(p.next())) continue;
                    p.remove();
                }
                toAdd.remove(addend);
                toAdd.addAll(parts);
            }
        }
        this.rects.addAll(toAdd);
        return this;
    }

    @Override
    public boolean contains(IGeometry g) {
        return ShapeUtils.contains((IMultiShape)this, g);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Region) {
            Region o = (Region)obj;
            return this.contains(o) && o.contains(this);
        }
        return false;
    }

    @Override
    protected Line[] getAllEdges() {
        Stack<Line> edges = new Stack<Line>();
        for (Rectangle r : this.rects) {
            Line[] lineArray = r.getOutlineSegments();
            int n = lineArray.length;
            int n2 = 0;
            while (n2 < n) {
                Line e = lineArray[n2];
                edges.push(e);
                ++n2;
            }
        }
        return edges.toArray(new Line[0]);
    }

    @Override
    public Rectangle getBounds() {
        if (this.rects.size() == 0) {
            return null;
        }
        Rectangle bounds = this.rects.get(0).getBounds();
        int i = 1;
        while (i < this.rects.size()) {
            bounds.union(this.rects.get(i).getBounds());
            ++i;
        }
        return bounds;
    }

    @Override
    public Region getCopy() {
        return new Region(this);
    }

    public Point[] getOutlineIntersections(ICurve c) {
        HashSet<Point> intersections = new HashSet<Point>(0);
        Line[] lineArray = this.getOutlineSegments();
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line seg = lineArray[n2];
            intersections.addAll(Arrays.asList(seg.getIntersections(c)));
            ++n2;
        }
        return intersections.toArray(new Point[0]);
    }

    @Override
    public Ring getRotatedCCW(Angle angle) {
        Point centroid = this.getBounds().getCenter();
        return this.getRotatedCCW(angle, centroid.x, centroid.y);
    }

    @Override
    public Ring getRotatedCCW(Angle angle, double cx, double cy) {
        Polygon[] polys = new Polygon[this.rects.size()];
        int i = 0;
        while (i < polys.length) {
            polys[i] = this.rects.get(i).getRotatedCCW(angle, cx, cy);
            ++i;
        }
        return new Ring(polys);
    }

    @Override
    public Ring getRotatedCCW(Angle angle, Point center) {
        return this.getRotatedCCW(angle, center.x, center.y);
    }

    @Override
    public Ring getRotatedCW(Angle angle) {
        Point centroid = this.getBounds().getCenter();
        return this.getRotatedCW(angle, centroid.x, centroid.y);
    }

    @Override
    public Ring getRotatedCW(Angle angle, double cx, double cy) {
        Polygon[] polys = new Polygon[this.rects.size()];
        int i = 0;
        while (i < polys.length) {
            polys[i] = this.rects.get(i).getRotatedCW(angle, cx, cy);
            ++i;
        }
        return new Ring(polys);
    }

    @Override
    public Ring getRotatedCW(Angle angle, Point center) {
        return this.getRotatedCW(angle, center.x, center.y);
    }

    @Override
    public Region getScaled(double factor) {
        return this.getCopy().scale(factor);
    }

    @Override
    public Region getScaled(double fx, double fy) {
        return this.getCopy().scale(fx, fy);
    }

    @Override
    public Region getScaled(double factor, double cx, double cy) {
        return this.getCopy().scale(factor, cx, cy);
    }

    @Override
    public Region getScaled(double fx, double fy, double cx, double cy) {
        return this.getCopy().scale(fx, fy, cx, cy);
    }

    @Override
    public Region getScaled(double fx, double fy, Point center) {
        return this.getCopy().scale(fx, fy, center);
    }

    @Override
    public Region getScaled(double factor, Point center) {
        return this.getCopy().scale(factor, center);
    }

    public Rectangle[] getShapes() {
        return this.rects.toArray(new Rectangle[0]);
    }

    @Override
    public Ring getTransformed(AffineTransform t) {
        ArrayList<Polygon> transformedRectangles = new ArrayList<Polygon>();
        for (Rectangle r : this.rects) {
            transformedRectangles.add(r.getTransformed(t));
        }
        return new Ring(transformedRectangles.toArray(new Polygon[0]));
    }

    @Override
    public Region getTranslated(double dx, double dy) {
        return this.getCopy().translate(dx, dy);
    }

    @Override
    public Region getTranslated(Point d) {
        return this.getCopy().translate(d.x, d.y);
    }

    @Override
    public Region scale(double factor) {
        return this.scale(factor, factor);
    }

    @Override
    public Region scale(double fx, double fy) {
        Point centroid = this.getBounds().getCenter();
        return this.scale(fx, fy, centroid.x, centroid.y);
    }

    @Override
    public Region scale(double factor, double cx, double cy) {
        return this.scale(factor, factor, cx, cy);
    }

    @Override
    public Region scale(double fx, double fy, double cx, double cy) {
        for (Rectangle r : this.rects) {
            r.scale(fx, fy, cx, cy);
        }
        return this;
    }

    @Override
    public Region scale(double fx, double fy, Point center) {
        return this.scale(fx, fy, center.x, center.y);
    }

    @Override
    public Region scale(double factor, Point center) {
        return this.scale(factor, factor, center.x, center.y);
    }

    public Ring toRing() {
        Polygon[] polys = new Polygon[this.rects.size()];
        Iterator<Rectangle> i = this.rects.iterator();
        int j = 0;
        while (j < this.rects.size()) {
            polys[j] = i.next().toPolygon();
            ++j;
        }
        return new Ring(polys);
    }

    @Override
    public Region translate(double dx, double dy) {
        for (Rectangle r : this.rects) {
            r.translate(dx, dy);
        }
        return this;
    }

    @Override
    public Region translate(Point d) {
        return this.translate(d.x, d.y);
    }
}

